package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ReplicaHealthsClient is the client for the ReplicaHealths methods of the Servicefabric service.
type ReplicaHealthsClient struct {
	BaseClient
}

// NewReplicaHealthsClient creates an instance of the ReplicaHealthsClient client.
func NewReplicaHealthsClient(timeout *int32) ReplicaHealthsClient {
	return NewReplicaHealthsClientWithBaseURI(DefaultBaseURI, timeout)
}

// NewReplicaHealthsClientWithBaseURI creates an instance of the ReplicaHealthsClient client.
func NewReplicaHealthsClientWithBaseURI(baseURI string, timeout *int32) ReplicaHealthsClient {
	return ReplicaHealthsClient{NewWithBaseURI(baseURI, timeout)}
}

// Get get replica healths
// Parameters:
// partitionID - the id of the partition
// replicaID - the id of the replica
// eventsHealthStateFilter - the filter of the events health state
func (client ReplicaHealthsClient) Get(ctx context.Context, partitionID string, replicaID string, eventsHealthStateFilter string) (result ReplicaHealth, err error) {
	req, err := client.GetPreparer(ctx, partitionID, replicaID, eventsHealthStateFilter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ReplicaHealthsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ReplicaHealthsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ReplicaHealthsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReplicaHealthsClient) GetPreparer(ctx context.Context, partitionID string, replicaID string, eventsHealthStateFilter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"partitionId": autorest.Encode("path", partitionID),
		"replicaId":   autorest.Encode("path", replicaID),
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(eventsHealthStateFilter) > 0 {
		queryParameters["EventsHealthStateFilter"] = autorest.Encode("query", eventsHealthStateFilter)
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetHealth", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicaHealthsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReplicaHealthsClient) GetResponder(resp *http.Response) (result ReplicaHealth, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Send send replica healths
// Parameters:
// partitionID - the id of the partition
// replicaID - the id of the replica
// replicaHealthReport - the report of the replica health
func (client ReplicaHealthsClient) Send(ctx context.Context, partitionID string, replicaID string, replicaHealthReport ReplicaHealthReport) (result String, err error) {
	req, err := client.SendPreparer(ctx, partitionID, replicaID, replicaHealthReport)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ReplicaHealthsClient", "Send", nil, "Failure preparing request")
		return
	}

	resp, err := client.SendSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ReplicaHealthsClient", "Send", resp, "Failure sending request")
		return
	}

	result, err = client.SendResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ReplicaHealthsClient", "Send", resp, "Failure responding to request")
	}

	return
}

// SendPreparer prepares the Send request.
func (client ReplicaHealthsClient) SendPreparer(ctx context.Context, partitionID string, replicaID string, replicaHealthReport ReplicaHealthReport) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"partitionId": autorest.Encode("path", partitionID),
		"replicaId":   autorest.Encode("path", replicaID),
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/ReportHealth", pathParameters),
		autorest.WithJSON(replicaHealthReport),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SendSender sends the Send request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicaHealthsClient) SendSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SendResponder handles the response to the Send request. The method always
// closes the http.Response Body.
func (client ReplicaHealthsClient) SendResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
