package keyvault

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// AutoRenew ...
	AutoRenew ActionType = "AutoRenew"
	// EmailContacts ...
	EmailContacts ActionType = "EmailContacts"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{AutoRenew, EmailContacts}
}

// DeletionRecoveryLevel enumerates the values for deletion recovery level.
type DeletionRecoveryLevel string

const (
	// CustomizedRecoverable Denotes a vault state in which deletion is recoverable without the possibility for
	// immediate and permanent deletion (i.e. purge when 7<= SoftDeleteRetentionInDays < 90).This level
	// guarantees the recoverability of the deleted entity during the retention interval and while the
	// subscription is still available.
	CustomizedRecoverable DeletionRecoveryLevel = "CustomizedRecoverable"
	// CustomizedRecoverableProtectedSubscription Denotes a vault and subscription state in which deletion is
	// recoverable, immediate and permanent deletion (i.e. purge) is not permitted, and in which the
	// subscription itself cannot be permanently canceled when 7<= SoftDeleteRetentionInDays < 90. This level
	// guarantees the recoverability of the deleted entity during the retention interval, and also reflects the
	// fact that the subscription itself cannot be cancelled.
	CustomizedRecoverableProtectedSubscription DeletionRecoveryLevel = "CustomizedRecoverable+ProtectedSubscription"
	// CustomizedRecoverablePurgeable Denotes a vault state in which deletion is recoverable, and which also
	// permits immediate and permanent deletion (i.e. purge when 7<= SoftDeleteRetentionInDays < 90). This
	// level guarantees the recoverability of the deleted entity during the retention interval, unless a Purge
	// operation is requested, or the subscription is cancelled.
	CustomizedRecoverablePurgeable DeletionRecoveryLevel = "CustomizedRecoverable+Purgeable"
	// Purgeable Denotes a vault state in which deletion is an irreversible operation, without the possibility
	// for recovery. This level corresponds to no protection being available against a Delete operation; the
	// data is irretrievably lost upon accepting a Delete operation at the entity level or higher (vault,
	// resource group, subscription etc.)
	Purgeable DeletionRecoveryLevel = "Purgeable"
	// Recoverable Denotes a vault state in which deletion is recoverable without the possibility for immediate
	// and permanent deletion (i.e. purge). This level guarantees the recoverability of the deleted entity
	// during the retention interval(90 days) and while the subscription is still available. System wil
	// permanently delete it after 90 days, if not recovered
	Recoverable DeletionRecoveryLevel = "Recoverable"
	// RecoverableProtectedSubscription Denotes a vault and subscription state in which deletion is recoverable
	// within retention interval (90 days), immediate and permanent deletion (i.e. purge) is not permitted, and
	// in which the subscription itself  cannot be permanently canceled. System wil permanently delete it after
	// 90 days, if not recovered
	RecoverableProtectedSubscription DeletionRecoveryLevel = "Recoverable+ProtectedSubscription"
	// RecoverablePurgeable Denotes a vault state in which deletion is recoverable, and which also permits
	// immediate and permanent deletion (i.e. purge). This level guarantees the recoverability of the deleted
	// entity during the retention interval (90 days), unless a Purge operation is requested, or the
	// subscription is cancelled. System wil permanently delete it after 90 days, if not recovered
	RecoverablePurgeable DeletionRecoveryLevel = "Recoverable+Purgeable"
)

// PossibleDeletionRecoveryLevelValues returns an array of possible values for the DeletionRecoveryLevel const type.
func PossibleDeletionRecoveryLevelValues() []DeletionRecoveryLevel {
	return []DeletionRecoveryLevel{CustomizedRecoverable, CustomizedRecoverableProtectedSubscription, CustomizedRecoverablePurgeable, Purgeable, Recoverable, RecoverableProtectedSubscription, RecoverablePurgeable}
}

// JSONWebKeyCurveName enumerates the values for json web key curve name.
type JSONWebKeyCurveName string

const (
	// P256 ...
	P256 JSONWebKeyCurveName = "P-256"
	// P256K ...
	P256K JSONWebKeyCurveName = "P-256K"
	// P384 ...
	P384 JSONWebKeyCurveName = "P-384"
	// P521 ...
	P521 JSONWebKeyCurveName = "P-521"
)

// PossibleJSONWebKeyCurveNameValues returns an array of possible values for the JSONWebKeyCurveName const type.
func PossibleJSONWebKeyCurveNameValues() []JSONWebKeyCurveName {
	return []JSONWebKeyCurveName{P256, P256K, P384, P521}
}

// JSONWebKeyEncryptionAlgorithm enumerates the values for json web key encryption algorithm.
type JSONWebKeyEncryptionAlgorithm string

const (
	// RSA15 ...
	RSA15 JSONWebKeyEncryptionAlgorithm = "RSA1_5"
	// RSAOAEP ...
	RSAOAEP JSONWebKeyEncryptionAlgorithm = "RSA-OAEP"
	// RSAOAEP256 ...
	RSAOAEP256 JSONWebKeyEncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleJSONWebKeyEncryptionAlgorithmValues returns an array of possible values for the JSONWebKeyEncryptionAlgorithm const type.
func PossibleJSONWebKeyEncryptionAlgorithmValues() []JSONWebKeyEncryptionAlgorithm {
	return []JSONWebKeyEncryptionAlgorithm{RSA15, RSAOAEP, RSAOAEP256}
}

// JSONWebKeyOperation enumerates the values for json web key operation.
type JSONWebKeyOperation string

const (
	// Decrypt ...
	Decrypt JSONWebKeyOperation = "decrypt"
	// Encrypt ...
	Encrypt JSONWebKeyOperation = "encrypt"
	// Import ...
	Import JSONWebKeyOperation = "import"
	// Sign ...
	Sign JSONWebKeyOperation = "sign"
	// UnwrapKey ...
	UnwrapKey JSONWebKeyOperation = "unwrapKey"
	// Verify ...
	Verify JSONWebKeyOperation = "verify"
	// WrapKey ...
	WrapKey JSONWebKeyOperation = "wrapKey"
)

// PossibleJSONWebKeyOperationValues returns an array of possible values for the JSONWebKeyOperation const type.
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return []JSONWebKeyOperation{Decrypt, Encrypt, Import, Sign, UnwrapKey, Verify, WrapKey}
}

// JSONWebKeySignatureAlgorithm enumerates the values for json web key signature algorithm.
type JSONWebKeySignatureAlgorithm string

const (
	// ES256 ECDSA using P-256 and SHA-256, as described in https://tools.ietf.org/html/rfc7518.
	ES256 JSONWebKeySignatureAlgorithm = "ES256"
	// ES256K ECDSA using P-256K and SHA-256, as described in https://tools.ietf.org/html/rfc7518
	ES256K JSONWebKeySignatureAlgorithm = "ES256K"
	// ES384 ECDSA using P-384 and SHA-384, as described in https://tools.ietf.org/html/rfc7518
	ES384 JSONWebKeySignatureAlgorithm = "ES384"
	// ES512 ECDSA using P-521 and SHA-512, as described in https://tools.ietf.org/html/rfc7518
	ES512 JSONWebKeySignatureAlgorithm = "ES512"
	// PS256 RSASSA-PSS using SHA-256 and MGF1 with SHA-256, as described in
	// https://tools.ietf.org/html/rfc7518
	PS256 JSONWebKeySignatureAlgorithm = "PS256"
	// PS384 RSASSA-PSS using SHA-384 and MGF1 with SHA-384, as described in
	// https://tools.ietf.org/html/rfc7518
	PS384 JSONWebKeySignatureAlgorithm = "PS384"
	// PS512 RSASSA-PSS using SHA-512 and MGF1 with SHA-512, as described in
	// https://tools.ietf.org/html/rfc7518
	PS512 JSONWebKeySignatureAlgorithm = "PS512"
	// RS256 RSASSA-PKCS1-v1_5 using SHA-256, as described in https://tools.ietf.org/html/rfc7518
	RS256 JSONWebKeySignatureAlgorithm = "RS256"
	// RS384 RSASSA-PKCS1-v1_5 using SHA-384, as described in https://tools.ietf.org/html/rfc7518
	RS384 JSONWebKeySignatureAlgorithm = "RS384"
	// RS512 RSASSA-PKCS1-v1_5 using SHA-512, as described in https://tools.ietf.org/html/rfc7518
	RS512 JSONWebKeySignatureAlgorithm = "RS512"
	// RSNULL Reserved
	RSNULL JSONWebKeySignatureAlgorithm = "RSNULL"
)

// PossibleJSONWebKeySignatureAlgorithmValues returns an array of possible values for the JSONWebKeySignatureAlgorithm const type.
func PossibleJSONWebKeySignatureAlgorithmValues() []JSONWebKeySignatureAlgorithm {
	return []JSONWebKeySignatureAlgorithm{ES256, ES256K, ES384, ES512, PS256, PS384, PS512, RS256, RS384, RS512, RSNULL}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// EC ...
	EC JSONWebKeyType = "EC"
	// ECHSM ...
	ECHSM JSONWebKeyType = "EC-HSM"
	// Oct ...
	Oct JSONWebKeyType = "oct"
	// RSA ...
	RSA JSONWebKeyType = "RSA"
	// RSAHSM ...
	RSAHSM JSONWebKeyType = "RSA-HSM"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{EC, ECHSM, Oct, RSA, RSAHSM}
}

// KeyUsageType enumerates the values for key usage type.
type KeyUsageType string

const (
	// CRLSign ...
	CRLSign KeyUsageType = "cRLSign"
	// DataEncipherment ...
	DataEncipherment KeyUsageType = "dataEncipherment"
	// DecipherOnly ...
	DecipherOnly KeyUsageType = "decipherOnly"
	// DigitalSignature ...
	DigitalSignature KeyUsageType = "digitalSignature"
	// EncipherOnly ...
	EncipherOnly KeyUsageType = "encipherOnly"
	// KeyAgreement ...
	KeyAgreement KeyUsageType = "keyAgreement"
	// KeyCertSign ...
	KeyCertSign KeyUsageType = "keyCertSign"
	// KeyEncipherment ...
	KeyEncipherment KeyUsageType = "keyEncipherment"
	// NonRepudiation ...
	NonRepudiation KeyUsageType = "nonRepudiation"
)

// PossibleKeyUsageTypeValues returns an array of possible values for the KeyUsageType const type.
func PossibleKeyUsageTypeValues() []KeyUsageType {
	return []KeyUsageType{CRLSign, DataEncipherment, DecipherOnly, DigitalSignature, EncipherOnly, KeyAgreement, KeyCertSign, KeyEncipherment, NonRepudiation}
}

// SasTokenType enumerates the values for sas token type.
type SasTokenType string

const (
	// Account ...
	Account SasTokenType = "account"
	// Service ...
	Service SasTokenType = "service"
)

// PossibleSasTokenTypeValues returns an array of possible values for the SasTokenType const type.
func PossibleSasTokenTypeValues() []SasTokenType {
	return []SasTokenType{Account, Service}
}
