package communication

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/communication/mgmt/2020-08-20-preview/communication"

// Dimension specifications of the Dimension of metrics.
type Dimension struct {
	// Name - The public facing name of the dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// InternalName - Name of the dimension as it appears in MDM.
	InternalName *string `json:"internalName,omitempty"`
	// ToBeExportedForShoebox - A Boolean flag indicating whether this dimension should be included for the shoebox export scenario.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// ErrorResponse error response indicating why the requested operation could not be performed.
type ErrorResponse struct {
	// Error - The error
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError the error
type ErrorResponseError struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// LinkedNotificationHub a notification hub that has been linked to the communication service
type LinkedNotificationHub struct {
	autorest.Response `json:"-"`
	// ResourceID - The resource ID of the notification hub
	ResourceID *string `json:"resourceId,omitempty"`
}

// LinkNotificationHubParameters description of an Azure Notification Hub to link to the communication
// service
type LinkNotificationHubParameters struct {
	// ResourceID - The resource ID of the notification hub
	ResourceID *string `json:"resourceId,omitempty"`
	// ConnectionString - Connection string for the notification hub
	ConnectionString *string `json:"connectionString,omitempty"`
}

// LocationResource an ARM resource with its own location (not a global or an inherited location).
type LocationResource struct {
	// Location - The Azure location where the CommunicationService is running.
	Location *string `json:"location,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring.
type MetricSpecification struct {
	// Name - Name of the metric.
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - The unit that makes sense for the metric.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - The method for aggregating the metric. Possible values include: 'Average', 'Minimum', 'Maximum', 'Total', 'Count'
	AggregationType AggregationType `json:"aggregationType,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	// Ex. a metric that returns the number of times a particular error code was emitted. The error code may not appear
	// often, instead of the RP publishing 0, Shoebox can auto fill in 0s for time periods where nothing was emitted.
	FillGapWithZero *string `json:"fillGapWithZero,omitempty"`
	// Category - The name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// Dimensions - The dimensions of the metrics.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
}

// NameAvailability result of the request to check name availability. It contains a flag and possible
// reason of failure.
type NameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates whether the name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason of the availability. Required if name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - The message of the operation.
	Message *string `json:"message,omitempty"`
}

// NameAvailabilityParameters data POST-ed to the nameAvailability action
type NameAvailabilityParameters struct {
	// Type - The resource type. Should be always "Microsoft.Communication/CommunicationServices".
	Type *string `json:"type,omitempty"`
	// Name - The CommunicationService name to validate. e.g."my-CommunicationService-name-here"
	Name *string `json:"name,omitempty"`
}

// Operation REST API operation supported by CommunicationService resource provider.
type Operation struct {
	// Name - Name of the operation with format: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Optional. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX.
	Origin *string `json:"origin,omitempty"`
	// Properties - Extra properties for the operation.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay the object that describes a operation.
type OperationDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - The localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationList result of the request to list REST API operations. It contains a list of operations.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationProperties extra Operation properties.
type OperationProperties struct {
	// ServiceSpecification - The service specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationStatus the current status of an async operation
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified ID for the operation status.
	ID *string `json:"id,omitempty"`
	// Status - READ-ONLY; Provisioning state of the resource. Possible values include: 'StatusSucceeded', 'StatusFailed', 'StatusCanceled', 'StatusCreating', 'StatusDeleting', 'StatusMoving'
	Status Status `json:"status,omitempty"`
	// StartTime - READ-ONLY; The start time of the operation
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time of the operation
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - READ-ONLY; Percent of the operation that is complete
	PercentComplete *float64 `json:"percentComplete,omitempty"`
	// ErrorResponse - Operation Error message
	*ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatus.
func (osVar OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osVar.ErrorResponse != nil {
		objectMap["error"] = osVar.ErrorResponse
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationStatus struct.
func (osVar *OperationStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				osVar.ID = &ID
			}
		case "status":
			if v != nil {
				var status Status
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				osVar.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				osVar.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				osVar.EndTime = &endTime
			}
		case "percentComplete":
			if v != nil {
				var percentComplete float64
				err = json.Unmarshal(*v, &percentComplete)
				if err != nil {
					return err
				}
				osVar.PercentComplete = &percentComplete
			}
		case "error":
			if v != nil {
				var errorResponse ErrorResponse
				err = json.Unmarshal(*v, &errorResponse)
				if err != nil {
					return err
				}
				osVar.ErrorResponse = &errorResponse
			}
		}
	}

	return nil
}

// RegenerateKeyParameters parameters describes the request to regenerate access keys
type RegenerateKeyParameters struct {
	// KeyType - The keyType to regenerate. Must be either 'primary' or 'secondary'(case-insensitive). Possible values include: 'Primary', 'Secondary'
	KeyType KeyType `json:"keyType,omitempty"`
}

// Resource the core properties of ARM resources.
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the service - e.g. "Microsoft.Communication/CommunicationServices"
	Type *string `json:"type,omitempty"`
}

// ServiceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceClient) (ServiceResource, error)
}

// ServiceDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceClient) (autorest.Response, error)
}

// ServiceKeys a class representing the access keys of a CommunicationService.
type ServiceKeys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - The primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// PrimaryConnectionString - CommunicationService connection string constructed via the primaryKey
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - CommunicationService connection string constructed via the secondaryKey
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
}

// ServiceProperties a class that describes the properties of the CommunicationService.
type ServiceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Unknown', 'Succeeded', 'Failed', 'Canceled', 'Running', 'Creating', 'Updating', 'Deleting', 'Moving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// HostName - READ-ONLY; FQDN of the CommunicationService instance.
	HostName *string `json:"hostName,omitempty"`
	// DataLocation - The location where the communication service stores its data at rest.
	DataLocation *string `json:"dataLocation,omitempty"`
	// NotificationHubID - READ-ONLY; Resource ID of an Azure Notification Hub linked to this resource.
	NotificationHubID *string `json:"notificationHubId,omitempty"`
	// Version - READ-ONLY; Version of the CommunicationService resource. Probably you need the same or higher version of client SDKs.
	Version *string `json:"version,omitempty"`
	// ImmutableResourceID - READ-ONLY; The immutable resource Id of the communication service.
	ImmutableResourceID *string `json:"immutableResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.DataLocation != nil {
		objectMap["dataLocation"] = sp.DataLocation
	}
	return json.Marshal(objectMap)
}

// ServiceResource a class representing a CommunicationService resource.
type ServiceResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the service - e.g. "Microsoft.Communication/CommunicationServices"
	Type *string `json:"type,omitempty"`
	// Location - The Azure location where the CommunicationService is running.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
	// ServiceProperties - The properties of the service.
	*ServiceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	if sr.ServiceProperties != nil {
		objectMap["properties"] = sr.ServiceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResource struct.
func (sr *ServiceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sr.Tags = tags
			}
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				sr.ServiceProperties = &serviceProperties
			}
		}
	}

	return nil
}

// ServiceResourceList object that includes an array of CommunicationServices and a possible link for next
// set.
type ServiceResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of CommunicationService
	Value *[]ServiceResource `json:"value,omitempty"`
	// NextLink - The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceResourceListIterator provides access to a complete listing of ServiceResource values.
type ServiceResourceListIterator struct {
	i    int
	page ServiceResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceResourceListIterator) Response() ServiceResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceResourceListIterator) Value() ServiceResource {
	if !iter.page.NotDone() {
		return ServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceResourceListIterator type.
func NewServiceResourceListIterator(page ServiceResourceListPage) ServiceResourceListIterator {
	return ServiceResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srl ServiceResourceList) IsEmpty() bool {
	return srl.Value == nil || len(*srl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srl ServiceResourceList) hasNextLink() bool {
	return srl.NextLink != nil && len(*srl.NextLink) != 0
}

// serviceResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srl ServiceResourceList) serviceResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !srl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srl.NextLink)))
}

// ServiceResourceListPage contains a page of ServiceResource values.
type ServiceResourceListPage struct {
	fn  func(context.Context, ServiceResourceList) (ServiceResourceList, error)
	srl ServiceResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srl)
		if err != nil {
			return err
		}
		page.srl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceResourceListPage) NotDone() bool {
	return !page.srl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceResourceListPage) Response() ServiceResourceList {
	return page.srl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceResourceListPage) Values() []ServiceResource {
	if page.srl.IsEmpty() {
		return nil
	}
	return *page.srl.Value
}

// Creates a new instance of the ServiceResourceListPage type.
func NewServiceResourceListPage(cur ServiceResourceList, getNextPage func(context.Context, ServiceResourceList) (ServiceResourceList, error)) ServiceResourceListPage {
	return ServiceResourceListPage{
		fn:  getNextPage,
		srl: cur,
	}
}

// ServiceSpecification an object that describes a specification.
type ServiceSpecification struct {
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// TaggedResource an ARM resource with that can accept tags
type TaggedResource struct {
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TaggedResource.
func (tr TaggedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}
