// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/cloud/osconfig/v1/patch_jobs.proto

package osconfig

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Enumeration of the various states a patch job passes through as it
// executes.
type PatchJob_State int32

const (
	// State must be specified.
	PatchJob_STATE_UNSPECIFIED PatchJob_State = 0
	// The patch job was successfully initiated.
	PatchJob_STARTED PatchJob_State = 1
	// The patch job is looking up instances to run the patch on.
	PatchJob_INSTANCE_LOOKUP PatchJob_State = 2
	// Instances are being patched.
	PatchJob_PATCHING PatchJob_State = 3
	// Patch job completed successfully.
	PatchJob_SUCCEEDED PatchJob_State = 4
	// Patch job completed but there were errors.
	PatchJob_COMPLETED_WITH_ERRORS PatchJob_State = 5
	// The patch job was canceled.
	PatchJob_CANCELED PatchJob_State = 6
	// The patch job timed out.
	PatchJob_TIMED_OUT PatchJob_State = 7
)

// Enum value maps for PatchJob_State.
var (
	PatchJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "INSTANCE_LOOKUP",
		3: "PATCHING",
		4: "SUCCEEDED",
		5: "COMPLETED_WITH_ERRORS",
		6: "CANCELED",
		7: "TIMED_OUT",
	}
	PatchJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED":     0,
		"STARTED":               1,
		"INSTANCE_LOOKUP":       2,
		"PATCHING":              3,
		"SUCCEEDED":             4,
		"COMPLETED_WITH_ERRORS": 5,
		"CANCELED":              6,
		"TIMED_OUT":             7,
	}
)

func (x PatchJob_State) Enum() *PatchJob_State {
	p := new(PatchJob_State)
	*p = x
	return p
}

func (x PatchJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PatchJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[0].Descriptor()
}

func (PatchJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[0]
}

func (x PatchJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PatchJob_State.Descriptor instead.
func (PatchJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{7, 0}
}

// Post-patch reboot settings.
type PatchConfig_RebootConfig int32

const (
	// The default behavior is DEFAULT.
	PatchConfig_REBOOT_CONFIG_UNSPECIFIED PatchConfig_RebootConfig = 0
	// The agent decides if a reboot is necessary by checking signals such as
	// registry keys on Windows or `/var/run/reboot-required` on APT based
	// systems. On RPM based systems, a set of core system package install times
	// are compared with system boot time.
	PatchConfig_DEFAULT PatchConfig_RebootConfig = 1
	// Always reboot the machine after the update completes.
	PatchConfig_ALWAYS PatchConfig_RebootConfig = 2
	// Never reboot the machine after the update completes.
	PatchConfig_NEVER PatchConfig_RebootConfig = 3
)

// Enum value maps for PatchConfig_RebootConfig.
var (
	PatchConfig_RebootConfig_name = map[int32]string{
		0: "REBOOT_CONFIG_UNSPECIFIED",
		1: "DEFAULT",
		2: "ALWAYS",
		3: "NEVER",
	}
	PatchConfig_RebootConfig_value = map[string]int32{
		"REBOOT_CONFIG_UNSPECIFIED": 0,
		"DEFAULT":                   1,
		"ALWAYS":                    2,
		"NEVER":                     3,
	}
)

func (x PatchConfig_RebootConfig) Enum() *PatchConfig_RebootConfig {
	p := new(PatchConfig_RebootConfig)
	*p = x
	return p
}

func (x PatchConfig_RebootConfig) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PatchConfig_RebootConfig) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[1].Descriptor()
}

func (PatchConfig_RebootConfig) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[1]
}

func (x PatchConfig_RebootConfig) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PatchConfig_RebootConfig.Descriptor instead.
func (PatchConfig_RebootConfig) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{8, 0}
}

// Patch state of an instance.
type Instance_PatchState int32

const (
	// Unspecified.
	Instance_PATCH_STATE_UNSPECIFIED Instance_PatchState = 0
	// The instance is not yet notified.
	Instance_PENDING Instance_PatchState = 1
	// Instance is inactive and cannot be patched.
	Instance_INACTIVE Instance_PatchState = 2
	// The instance is notified that it should be patched.
	Instance_NOTIFIED Instance_PatchState = 3
	// The instance has started the patching process.
	Instance_STARTED Instance_PatchState = 4
	// The instance is downloading patches.
	Instance_DOWNLOADING_PATCHES Instance_PatchState = 5
	// The instance is applying patches.
	Instance_APPLYING_PATCHES Instance_PatchState = 6
	// The instance is rebooting.
	Instance_REBOOTING Instance_PatchState = 7
	// The instance has completed applying patches.
	Instance_SUCCEEDED Instance_PatchState = 8
	// The instance has completed applying patches but a reboot is required.
	Instance_SUCCEEDED_REBOOT_REQUIRED Instance_PatchState = 9
	// The instance has failed to apply the patch.
	Instance_FAILED Instance_PatchState = 10
	// The instance acked the notification and will start shortly.
	Instance_ACKED Instance_PatchState = 11
	// The instance exceeded the time out while applying the patch.
	Instance_TIMED_OUT Instance_PatchState = 12
	// The instance is running the pre-patch step.
	Instance_RUNNING_PRE_PATCH_STEP Instance_PatchState = 13
	// The instance is running the post-patch step.
	Instance_RUNNING_POST_PATCH_STEP Instance_PatchState = 14
	// The service could not detect the presence of the agent. Check to ensure
	// that the agent is installed, running, and able to communicate with the
	// service.
	Instance_NO_AGENT_DETECTED Instance_PatchState = 15
)

// Enum value maps for Instance_PatchState.
var (
	Instance_PatchState_name = map[int32]string{
		0:  "PATCH_STATE_UNSPECIFIED",
		1:  "PENDING",
		2:  "INACTIVE",
		3:  "NOTIFIED",
		4:  "STARTED",
		5:  "DOWNLOADING_PATCHES",
		6:  "APPLYING_PATCHES",
		7:  "REBOOTING",
		8:  "SUCCEEDED",
		9:  "SUCCEEDED_REBOOT_REQUIRED",
		10: "FAILED",
		11: "ACKED",
		12: "TIMED_OUT",
		13: "RUNNING_PRE_PATCH_STEP",
		14: "RUNNING_POST_PATCH_STEP",
		15: "NO_AGENT_DETECTED",
	}
	Instance_PatchState_value = map[string]int32{
		"PATCH_STATE_UNSPECIFIED":   0,
		"PENDING":                   1,
		"INACTIVE":                  2,
		"NOTIFIED":                  3,
		"STARTED":                   4,
		"DOWNLOADING_PATCHES":       5,
		"APPLYING_PATCHES":          6,
		"REBOOTING":                 7,
		"SUCCEEDED":                 8,
		"SUCCEEDED_REBOOT_REQUIRED": 9,
		"FAILED":                    10,
		"ACKED":                     11,
		"TIMED_OUT":                 12,
		"RUNNING_PRE_PATCH_STEP":    13,
		"RUNNING_POST_PATCH_STEP":   14,
		"NO_AGENT_DETECTED":         15,
	}
)

func (x Instance_PatchState) Enum() *Instance_PatchState {
	p := new(Instance_PatchState)
	*p = x
	return p
}

func (x Instance_PatchState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_PatchState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[2].Descriptor()
}

func (Instance_PatchState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[2]
}

func (x Instance_PatchState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_PatchState.Descriptor instead.
func (Instance_PatchState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{9, 0}
}

// Apt patch type.
type AptSettings_Type int32

const (
	// By default, upgrade will be performed.
	AptSettings_TYPE_UNSPECIFIED AptSettings_Type = 0
	// Runs `apt-get dist-upgrade`.
	AptSettings_DIST AptSettings_Type = 1
	// Runs `apt-get upgrade`.
	AptSettings_UPGRADE AptSettings_Type = 2
)

// Enum value maps for AptSettings_Type.
var (
	AptSettings_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DIST",
		2: "UPGRADE",
	}
	AptSettings_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"DIST":             1,
		"UPGRADE":          2,
	}
)

func (x AptSettings_Type) Enum() *AptSettings_Type {
	p := new(AptSettings_Type)
	*p = x
	return p
}

func (x AptSettings_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AptSettings_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[3].Descriptor()
}

func (AptSettings_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[3]
}

func (x AptSettings_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AptSettings_Type.Descriptor instead.
func (AptSettings_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{11, 0}
}

// Microsoft Windows update classifications as defined in
// [1]
// https://support.microsoft.com/en-us/help/824684/description-of-the-standard-terminology-that-is-used-to-describe-micro
type WindowsUpdateSettings_Classification int32

const (
	// Invalid. If classifications are included, they must be specified.
	WindowsUpdateSettings_CLASSIFICATION_UNSPECIFIED WindowsUpdateSettings_Classification = 0
	// "A widely released fix for a specific problem that addresses a critical,
	// non-security-related bug." [1]
	WindowsUpdateSettings_CRITICAL WindowsUpdateSettings_Classification = 1
	// "A widely released fix for a product-specific, security-related
	// vulnerability. Security vulnerabilities are rated by their severity. The
	// severity rating is indicated in the Microsoft security bulletin as
	// critical, important, moderate, or low." [1]
	WindowsUpdateSettings_SECURITY WindowsUpdateSettings_Classification = 2
	// "A widely released and frequent software update that contains additions
	// to a product's definition database. Definition databases are often used
	// to detect objects that have specific attributes, such as malicious code,
	// phishing websites, or junk mail." [1]
	WindowsUpdateSettings_DEFINITION WindowsUpdateSettings_Classification = 3
	// "Software that controls the input and output of a device." [1]
	WindowsUpdateSettings_DRIVER WindowsUpdateSettings_Classification = 4
	// "New product functionality that is first distributed outside the context
	// of a product release and that is typically included in the next full
	// product release." [1]
	WindowsUpdateSettings_FEATURE_PACK WindowsUpdateSettings_Classification = 5
	// "A tested, cumulative set of all hotfixes, security updates, critical
	// updates, and updates. Additionally, service packs may contain additional
	// fixes for problems that are found internally since the release of the
	// product. Service packs my also contain a limited number of
	// customer-requested design changes or features." [1]
	WindowsUpdateSettings_SERVICE_PACK WindowsUpdateSettings_Classification = 6
	// "A utility or feature that helps complete a task or set of tasks." [1]
	WindowsUpdateSettings_TOOL WindowsUpdateSettings_Classification = 7
	// "A tested, cumulative set of hotfixes, security updates, critical
	// updates, and updates that are packaged together for easy deployment. A
	// rollup generally targets a specific area, such as security, or a
	// component of a product, such as Internet Information Services (IIS)." [1]
	WindowsUpdateSettings_UPDATE_ROLLUP WindowsUpdateSettings_Classification = 8
	// "A widely released fix for a specific problem. An update addresses a
	// noncritical, non-security-related bug." [1]
	WindowsUpdateSettings_UPDATE WindowsUpdateSettings_Classification = 9
)

// Enum value maps for WindowsUpdateSettings_Classification.
var (
	WindowsUpdateSettings_Classification_name = map[int32]string{
		0: "CLASSIFICATION_UNSPECIFIED",
		1: "CRITICAL",
		2: "SECURITY",
		3: "DEFINITION",
		4: "DRIVER",
		5: "FEATURE_PACK",
		6: "SERVICE_PACK",
		7: "TOOL",
		8: "UPDATE_ROLLUP",
		9: "UPDATE",
	}
	WindowsUpdateSettings_Classification_value = map[string]int32{
		"CLASSIFICATION_UNSPECIFIED": 0,
		"CRITICAL":                   1,
		"SECURITY":                   2,
		"DEFINITION":                 3,
		"DRIVER":                     4,
		"FEATURE_PACK":               5,
		"SERVICE_PACK":               6,
		"TOOL":                       7,
		"UPDATE_ROLLUP":              8,
		"UPDATE":                     9,
	}
)

func (x WindowsUpdateSettings_Classification) Enum() *WindowsUpdateSettings_Classification {
	p := new(WindowsUpdateSettings_Classification)
	*p = x
	return p
}

func (x WindowsUpdateSettings_Classification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WindowsUpdateSettings_Classification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[4].Descriptor()
}

func (WindowsUpdateSettings_Classification) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[4]
}

func (x WindowsUpdateSettings_Classification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WindowsUpdateSettings_Classification.Descriptor instead.
func (WindowsUpdateSettings_Classification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{15, 0}
}

// The interpreter used to execute the a file.
type ExecStepConfig_Interpreter int32

const (
	// Invalid for a Windows ExecStepConfig. For a Linux ExecStepConfig, the
	// interpreter will be parsed from the shebang line of the script if
	// unspecified.
	ExecStepConfig_INTERPRETER_UNSPECIFIED ExecStepConfig_Interpreter = 0
	// Indicates that the script is run with `/bin/sh` on Linux and `cmd`
	// on Windows.
	ExecStepConfig_SHELL ExecStepConfig_Interpreter = 1
	// Indicates that the file is run with PowerShell flags
	// `-NonInteractive`, `-NoProfile`, and `-ExecutionPolicy Bypass`.
	ExecStepConfig_POWERSHELL ExecStepConfig_Interpreter = 2
)

// Enum value maps for ExecStepConfig_Interpreter.
var (
	ExecStepConfig_Interpreter_name = map[int32]string{
		0: "INTERPRETER_UNSPECIFIED",
		1: "SHELL",
		2: "POWERSHELL",
	}
	ExecStepConfig_Interpreter_value = map[string]int32{
		"INTERPRETER_UNSPECIFIED": 0,
		"SHELL":                   1,
		"POWERSHELL":              2,
	}
)

func (x ExecStepConfig_Interpreter) Enum() *ExecStepConfig_Interpreter {
	p := new(ExecStepConfig_Interpreter)
	*p = x
	return p
}

func (x ExecStepConfig_Interpreter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecStepConfig_Interpreter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[5].Descriptor()
}

func (ExecStepConfig_Interpreter) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes[5]
}

func (x ExecStepConfig_Interpreter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecStepConfig_Interpreter.Descriptor instead.
func (ExecStepConfig_Interpreter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{17, 0}
}

// A request message to initiate patching across Compute Engine
// instances.
type ExecutePatchJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which to run this patch in the form `projects/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Description of the patch job. Length of the description is limited
	// to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Instances to patch, either explicitly or filtered by some criteria such
	// as zone or labels.
	InstanceFilter *PatchInstanceFilter `protobuf:"bytes,7,opt,name=instance_filter,json=instanceFilter,proto3" json:"instance_filter,omitempty"`
	// Patch configuration being applied. If omitted, instances are
	// patched using the default configurations.
	PatchConfig *PatchConfig `protobuf:"bytes,4,opt,name=patch_config,json=patchConfig,proto3" json:"patch_config,omitempty"`
	// Duration of the patch job. After the duration ends, the patch job
	// times out.
	Duration *duration.Duration `protobuf:"bytes,5,opt,name=duration,proto3" json:"duration,omitempty"`
	// If this patch is a dry-run only, instances are contacted but
	// will do nothing.
	DryRun bool `protobuf:"varint,6,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Display name for this patch job. This does not have to be unique.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ExecutePatchJobRequest) Reset() {
	*x = ExecutePatchJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutePatchJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutePatchJobRequest) ProtoMessage() {}

func (x *ExecutePatchJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutePatchJobRequest.ProtoReflect.Descriptor instead.
func (*ExecutePatchJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{0}
}

func (x *ExecutePatchJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExecutePatchJobRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ExecutePatchJobRequest) GetInstanceFilter() *PatchInstanceFilter {
	if x != nil {
		return x.InstanceFilter
	}
	return nil
}

func (x *ExecutePatchJobRequest) GetPatchConfig() *PatchConfig {
	if x != nil {
		return x.PatchConfig
	}
	return nil
}

func (x *ExecutePatchJobRequest) GetDuration() *duration.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *ExecutePatchJobRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *ExecutePatchJobRequest) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Request to get an active or completed patch job.
type GetPatchJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the patch in the form `projects/*/patchJobs/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPatchJobRequest) Reset() {
	*x = GetPatchJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPatchJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPatchJobRequest) ProtoMessage() {}

func (x *GetPatchJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPatchJobRequest.ProtoReflect.Descriptor instead.
func (*GetPatchJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{1}
}

func (x *GetPatchJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list details for all instances that are part of a patch job.
type ListPatchJobInstanceDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent for the instances are in the form of `projects/*/patchJobs/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of instance details records to return.  Default is 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters results listed in the response. This
	// field supports filtering results by instance zone, name, state, or
	// `failure_reason`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPatchJobInstanceDetailsRequest) Reset() {
	*x = ListPatchJobInstanceDetailsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPatchJobInstanceDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPatchJobInstanceDetailsRequest) ProtoMessage() {}

func (x *ListPatchJobInstanceDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPatchJobInstanceDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListPatchJobInstanceDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{2}
}

func (x *ListPatchJobInstanceDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPatchJobInstanceDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPatchJobInstanceDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPatchJobInstanceDetailsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A response message for listing the instances details for a patch job.
type ListPatchJobInstanceDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of instance status.
	PatchJobInstanceDetails []*PatchJobInstanceDetails `protobuf:"bytes,1,rep,name=patch_job_instance_details,json=patchJobInstanceDetails,proto3" json:"patch_job_instance_details,omitempty"`
	// A pagination token that can be used to get the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPatchJobInstanceDetailsResponse) Reset() {
	*x = ListPatchJobInstanceDetailsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPatchJobInstanceDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPatchJobInstanceDetailsResponse) ProtoMessage() {}

func (x *ListPatchJobInstanceDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPatchJobInstanceDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListPatchJobInstanceDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{3}
}

func (x *ListPatchJobInstanceDetailsResponse) GetPatchJobInstanceDetails() []*PatchJobInstanceDetails {
	if x != nil {
		return x.PatchJobInstanceDetails
	}
	return nil
}

func (x *ListPatchJobInstanceDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Patch details for a VM instance. For more information about reviewing VM
// instance details, see
// [Listing all VM instance details for a specific patch
// job](https://cloud.google.com/compute/docs/os-patch-management/manage-patch-jobs#list-instance-details).
type PatchJobInstanceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance name in the form `projects/*/zones/*/instances/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique identifier for the instance. This identifier is
	// defined by the server.
	InstanceSystemId string `protobuf:"bytes,2,opt,name=instance_system_id,json=instanceSystemId,proto3" json:"instance_system_id,omitempty"`
	// Current state of instance patch.
	State Instance_PatchState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.osconfig.v1.Instance_PatchState" json:"state,omitempty"`
	// If the patch fails, this field provides the reason.
	FailureReason string `protobuf:"bytes,4,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	// The number of times the agent that the agent attempts to apply the patch.
	AttemptCount int64 `protobuf:"varint,5,opt,name=attempt_count,json=attemptCount,proto3" json:"attempt_count,omitempty"`
}

func (x *PatchJobInstanceDetails) Reset() {
	*x = PatchJobInstanceDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchJobInstanceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchJobInstanceDetails) ProtoMessage() {}

func (x *PatchJobInstanceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchJobInstanceDetails.ProtoReflect.Descriptor instead.
func (*PatchJobInstanceDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{4}
}

func (x *PatchJobInstanceDetails) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PatchJobInstanceDetails) GetInstanceSystemId() string {
	if x != nil {
		return x.InstanceSystemId
	}
	return ""
}

func (x *PatchJobInstanceDetails) GetState() Instance_PatchState {
	if x != nil {
		return x.State
	}
	return Instance_PATCH_STATE_UNSPECIFIED
}

func (x *PatchJobInstanceDetails) GetFailureReason() string {
	if x != nil {
		return x.FailureReason
	}
	return ""
}

func (x *PatchJobInstanceDetails) GetAttemptCount() int64 {
	if x != nil {
		return x.AttemptCount
	}
	return 0
}

// A request message for listing patch jobs.
type ListPatchJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. In the form of `projects/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of instance status to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// If provided, this field specifies the criteria that must be met by patch
	// jobs to be included in the response.
	// Currently, filtering is only available on the patch_deployment field.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPatchJobsRequest) Reset() {
	*x = ListPatchJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPatchJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPatchJobsRequest) ProtoMessage() {}

func (x *ListPatchJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPatchJobsRequest.ProtoReflect.Descriptor instead.
func (*ListPatchJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{5}
}

func (x *ListPatchJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPatchJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPatchJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPatchJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A response message for listing patch jobs.
type ListPatchJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of patch jobs.
	PatchJobs []*PatchJob `protobuf:"bytes,1,rep,name=patch_jobs,json=patchJobs,proto3" json:"patch_jobs,omitempty"`
	// A pagination token that can be used to get the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPatchJobsResponse) Reset() {
	*x = ListPatchJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPatchJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPatchJobsResponse) ProtoMessage() {}

func (x *ListPatchJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPatchJobsResponse.ProtoReflect.Descriptor instead.
func (*ListPatchJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{6}
}

func (x *ListPatchJobsResponse) GetPatchJobs() []*PatchJob {
	if x != nil {
		return x.PatchJobs
	}
	return nil
}

func (x *ListPatchJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A high level representation of a patch job that is either in progress
// or has completed.
//
// Instances details are not included in the job. To paginate through instance
// details, use ListPatchJobInstanceDetails.
//
// For more information about patch jobs, see
// [Creating patch
// jobs](https://cloud.google.com/compute/docs/os-patch-management/create-patch-job).
type PatchJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for this patch job in the form
	// `projects/*/patchJobs/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name for this patch job. This is not a unique identifier.
	DisplayName string `protobuf:"bytes,14,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the patch job. Length of the description is limited
	// to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Time this patch job was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Last time this patch job was updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The current state of the PatchJob .
	State PatchJob_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.osconfig.v1.PatchJob_State" json:"state,omitempty"`
	// Instances to patch.
	InstanceFilter *PatchInstanceFilter `protobuf:"bytes,13,opt,name=instance_filter,json=instanceFilter,proto3" json:"instance_filter,omitempty"`
	// Patch configuration being applied.
	PatchConfig *PatchConfig `protobuf:"bytes,7,opt,name=patch_config,json=patchConfig,proto3" json:"patch_config,omitempty"`
	// Duration of the patch job. After the duration ends, the
	// patch job times out.
	Duration *duration.Duration `protobuf:"bytes,8,opt,name=duration,proto3" json:"duration,omitempty"`
	// Summary of instance details.
	InstanceDetailsSummary *PatchJob_InstanceDetailsSummary `protobuf:"bytes,9,opt,name=instance_details_summary,json=instanceDetailsSummary,proto3" json:"instance_details_summary,omitempty"`
	// If this patch job is a dry run, the agent reports that it has
	// finished without running any updates on the VM instance.
	DryRun bool `protobuf:"varint,10,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// If this patch job failed, this message provides information about the
	// failure.
	ErrorMessage string `protobuf:"bytes,11,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Reflects the overall progress of the patch job in the range of
	// 0.0 being no progress to 100.0 being complete.
	PercentComplete float64 `protobuf:"fixed64,12,opt,name=percent_complete,json=percentComplete,proto3" json:"percent_complete,omitempty"`
	// Output only. Name of the patch deployment that created this patch job.
	PatchDeployment string `protobuf:"bytes,15,opt,name=patch_deployment,json=patchDeployment,proto3" json:"patch_deployment,omitempty"`
}

func (x *PatchJob) Reset() {
	*x = PatchJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchJob) ProtoMessage() {}

func (x *PatchJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchJob.ProtoReflect.Descriptor instead.
func (*PatchJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{7}
}

func (x *PatchJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PatchJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PatchJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PatchJob) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PatchJob) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PatchJob) GetState() PatchJob_State {
	if x != nil {
		return x.State
	}
	return PatchJob_STATE_UNSPECIFIED
}

func (x *PatchJob) GetInstanceFilter() *PatchInstanceFilter {
	if x != nil {
		return x.InstanceFilter
	}
	return nil
}

func (x *PatchJob) GetPatchConfig() *PatchConfig {
	if x != nil {
		return x.PatchConfig
	}
	return nil
}

func (x *PatchJob) GetDuration() *duration.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *PatchJob) GetInstanceDetailsSummary() *PatchJob_InstanceDetailsSummary {
	if x != nil {
		return x.InstanceDetailsSummary
	}
	return nil
}

func (x *PatchJob) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *PatchJob) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *PatchJob) GetPercentComplete() float64 {
	if x != nil {
		return x.PercentComplete
	}
	return 0
}

func (x *PatchJob) GetPatchDeployment() string {
	if x != nil {
		return x.PatchDeployment
	}
	return ""
}

// Patch configuration specifications. Contains details on how to apply the
// patch(es) to a VM instance.
type PatchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Post-patch reboot settings.
	RebootConfig PatchConfig_RebootConfig `protobuf:"varint,1,opt,name=reboot_config,json=rebootConfig,proto3,enum=google.cloud.osconfig.v1.PatchConfig_RebootConfig" json:"reboot_config,omitempty"`
	// Apt update settings. Use this setting to override the default `apt` patch
	// rules.
	Apt *AptSettings `protobuf:"bytes,3,opt,name=apt,proto3" json:"apt,omitempty"`
	// Yum update settings. Use this setting to override the default `yum` patch
	// rules.
	Yum *YumSettings `protobuf:"bytes,4,opt,name=yum,proto3" json:"yum,omitempty"`
	// Goo update settings. Use this setting to override the default `goo` patch
	// rules.
	Goo *GooSettings `protobuf:"bytes,5,opt,name=goo,proto3" json:"goo,omitempty"`
	// Zypper update settings. Use this setting to override the default `zypper`
	// patch rules.
	Zypper *ZypperSettings `protobuf:"bytes,6,opt,name=zypper,proto3" json:"zypper,omitempty"`
	// Windows update settings. Use this override the default windows patch rules.
	WindowsUpdate *WindowsUpdateSettings `protobuf:"bytes,7,opt,name=windows_update,json=windowsUpdate,proto3" json:"windows_update,omitempty"`
	// The `ExecStep` to run before the patch update.
	PreStep *ExecStep `protobuf:"bytes,8,opt,name=pre_step,json=preStep,proto3" json:"pre_step,omitempty"`
	// The `ExecStep` to run after the patch update.
	PostStep *ExecStep `protobuf:"bytes,9,opt,name=post_step,json=postStep,proto3" json:"post_step,omitempty"`
}

func (x *PatchConfig) Reset() {
	*x = PatchConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchConfig) ProtoMessage() {}

func (x *PatchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchConfig.ProtoReflect.Descriptor instead.
func (*PatchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{8}
}

func (x *PatchConfig) GetRebootConfig() PatchConfig_RebootConfig {
	if x != nil {
		return x.RebootConfig
	}
	return PatchConfig_REBOOT_CONFIG_UNSPECIFIED
}

func (x *PatchConfig) GetApt() *AptSettings {
	if x != nil {
		return x.Apt
	}
	return nil
}

func (x *PatchConfig) GetYum() *YumSettings {
	if x != nil {
		return x.Yum
	}
	return nil
}

func (x *PatchConfig) GetGoo() *GooSettings {
	if x != nil {
		return x.Goo
	}
	return nil
}

func (x *PatchConfig) GetZypper() *ZypperSettings {
	if x != nil {
		return x.Zypper
	}
	return nil
}

func (x *PatchConfig) GetWindowsUpdate() *WindowsUpdateSettings {
	if x != nil {
		return x.WindowsUpdate
	}
	return nil
}

func (x *PatchConfig) GetPreStep() *ExecStep {
	if x != nil {
		return x.PreStep
	}
	return nil
}

func (x *PatchConfig) GetPostStep() *ExecStep {
	if x != nil {
		return x.PostStep
	}
	return nil
}

// Namespace for instance state enums.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{9}
}

// Message for canceling a patch job.
type CancelPatchJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the patch in the form `projects/*/patchJobs/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelPatchJobRequest) Reset() {
	*x = CancelPatchJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelPatchJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelPatchJobRequest) ProtoMessage() {}

func (x *CancelPatchJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelPatchJobRequest.ProtoReflect.Descriptor instead.
func (*CancelPatchJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{10}
}

func (x *CancelPatchJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Apt patching is completed by executing `apt-get update && apt-get
// upgrade`. Additional options can be set to control how this is executed.
type AptSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// By changing the type to DIST, the patching is performed
	// using `apt-get dist-upgrade` instead.
	Type AptSettings_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.osconfig.v1.AptSettings_Type" json:"type,omitempty"`
	// List of packages to exclude from update. These packages will be excluded
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field cannot be specified with any other patch configuration
	// fields.
	ExclusivePackages []string `protobuf:"bytes,3,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
}

func (x *AptSettings) Reset() {
	*x = AptSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AptSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AptSettings) ProtoMessage() {}

func (x *AptSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AptSettings.ProtoReflect.Descriptor instead.
func (*AptSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{11}
}

func (x *AptSettings) GetType() AptSettings_Type {
	if x != nil {
		return x.Type
	}
	return AptSettings_TYPE_UNSPECIFIED
}

func (x *AptSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *AptSettings) GetExclusivePackages() []string {
	if x != nil {
		return x.ExclusivePackages
	}
	return nil
}

// Yum patching is performed by executing `yum update`. Additional options
// can be set to control how this is executed.
//
// Note that not all settings are supported on all platforms.
type YumSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Adds the `--security` flag to `yum update`. Not supported on
	// all platforms.
	Security bool `protobuf:"varint,1,opt,name=security,proto3" json:"security,omitempty"`
	// Will cause patch to run `yum update-minimal` instead.
	Minimal bool `protobuf:"varint,2,opt,name=minimal,proto3" json:"minimal,omitempty"`
	// List of packages to exclude from update. These packages are excluded by
	// using the yum `--exclude` flag.
	Excludes []string `protobuf:"bytes,3,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field must not be specified with any other patch
	// configuration fields.
	ExclusivePackages []string `protobuf:"bytes,4,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
}

func (x *YumSettings) Reset() {
	*x = YumSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *YumSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*YumSettings) ProtoMessage() {}

func (x *YumSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use YumSettings.ProtoReflect.Descriptor instead.
func (*YumSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{12}
}

func (x *YumSettings) GetSecurity() bool {
	if x != nil {
		return x.Security
	}
	return false
}

func (x *YumSettings) GetMinimal() bool {
	if x != nil {
		return x.Minimal
	}
	return false
}

func (x *YumSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *YumSettings) GetExclusivePackages() []string {
	if x != nil {
		return x.ExclusivePackages
	}
	return nil
}

// Googet patching is performed by running `googet update`.
type GooSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GooSettings) Reset() {
	*x = GooSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GooSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GooSettings) ProtoMessage() {}

func (x *GooSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GooSettings.ProtoReflect.Descriptor instead.
func (*GooSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{13}
}

// Zypper patching is performed by running `zypper patch`.
// See also https://en.opensuse.org/SDB:Zypper_manual.
type ZypperSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Adds the `--with-optional` flag to `zypper patch`.
	WithOptional bool `protobuf:"varint,1,opt,name=with_optional,json=withOptional,proto3" json:"with_optional,omitempty"`
	// Adds the `--with-update` flag, to `zypper patch`.
	WithUpdate bool `protobuf:"varint,2,opt,name=with_update,json=withUpdate,proto3" json:"with_update,omitempty"`
	// Install only patches with these categories.
	// Common categories include security, recommended, and feature.
	Categories []string `protobuf:"bytes,3,rep,name=categories,proto3" json:"categories,omitempty"`
	// Install only patches with these severities.
	// Common severities include critical, important, moderate, and low.
	Severities []string `protobuf:"bytes,4,rep,name=severities,proto3" json:"severities,omitempty"`
	// List of patches to exclude from update.
	Excludes []string `protobuf:"bytes,5,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of patches to be updated. These are the only patches
	// that will be installed using 'zypper patch patch:<patch_name>' command.
	// This field must not be used with any other patch configuration fields.
	ExclusivePatches []string `protobuf:"bytes,6,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
}

func (x *ZypperSettings) Reset() {
	*x = ZypperSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZypperSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZypperSettings) ProtoMessage() {}

func (x *ZypperSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZypperSettings.ProtoReflect.Descriptor instead.
func (*ZypperSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{14}
}

func (x *ZypperSettings) GetWithOptional() bool {
	if x != nil {
		return x.WithOptional
	}
	return false
}

func (x *ZypperSettings) GetWithUpdate() bool {
	if x != nil {
		return x.WithUpdate
	}
	return false
}

func (x *ZypperSettings) GetCategories() []string {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *ZypperSettings) GetSeverities() []string {
	if x != nil {
		return x.Severities
	}
	return nil
}

func (x *ZypperSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *ZypperSettings) GetExclusivePatches() []string {
	if x != nil {
		return x.ExclusivePatches
	}
	return nil
}

// Windows patching is performed using the Windows Update Agent.
type WindowsUpdateSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only apply updates of these windows update classifications. If empty, all
	// updates are applied.
	Classifications []WindowsUpdateSettings_Classification `protobuf:"varint,1,rep,packed,name=classifications,proto3,enum=google.cloud.osconfig.v1.WindowsUpdateSettings_Classification" json:"classifications,omitempty"`
	// List of KBs to exclude from update.
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of kbs to be updated. These are the only patches
	// that will be updated. This field must not be used with other
	// patch configurations.
	ExclusivePatches []string `protobuf:"bytes,3,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
}

func (x *WindowsUpdateSettings) Reset() {
	*x = WindowsUpdateSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsUpdateSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsUpdateSettings) ProtoMessage() {}

func (x *WindowsUpdateSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsUpdateSettings.ProtoReflect.Descriptor instead.
func (*WindowsUpdateSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{15}
}

func (x *WindowsUpdateSettings) GetClassifications() []WindowsUpdateSettings_Classification {
	if x != nil {
		return x.Classifications
	}
	return nil
}

func (x *WindowsUpdateSettings) GetExcludes() []string {
	if x != nil {
		return x.Excludes
	}
	return nil
}

func (x *WindowsUpdateSettings) GetExclusivePatches() []string {
	if x != nil {
		return x.ExclusivePatches
	}
	return nil
}

// A step that runs an executable for a PatchJob.
type ExecStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ExecStepConfig for all Linux VMs targeted by the PatchJob.
	LinuxExecStepConfig *ExecStepConfig `protobuf:"bytes,1,opt,name=linux_exec_step_config,json=linuxExecStepConfig,proto3" json:"linux_exec_step_config,omitempty"`
	// The ExecStepConfig for all Windows VMs targeted by the PatchJob.
	WindowsExecStepConfig *ExecStepConfig `protobuf:"bytes,2,opt,name=windows_exec_step_config,json=windowsExecStepConfig,proto3" json:"windows_exec_step_config,omitempty"`
}

func (x *ExecStep) Reset() {
	*x = ExecStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecStep) ProtoMessage() {}

func (x *ExecStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecStep.ProtoReflect.Descriptor instead.
func (*ExecStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{16}
}

func (x *ExecStep) GetLinuxExecStepConfig() *ExecStepConfig {
	if x != nil {
		return x.LinuxExecStepConfig
	}
	return nil
}

func (x *ExecStep) GetWindowsExecStepConfig() *ExecStepConfig {
	if x != nil {
		return x.WindowsExecStepConfig
	}
	return nil
}

// Common configurations for an ExecStep.
type ExecStepConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the executable.
	//
	// Types that are assignable to Executable:
	//	*ExecStepConfig_LocalPath
	//	*ExecStepConfig_GcsObject
	Executable isExecStepConfig_Executable `protobuf_oneof:"executable"`
	// Defaults to [0]. A list of possible return values that the
	// execution can return to indicate a success.
	AllowedSuccessCodes []int32 `protobuf:"varint,3,rep,packed,name=allowed_success_codes,json=allowedSuccessCodes,proto3" json:"allowed_success_codes,omitempty"`
	// The script interpreter to use to run the script. If no interpreter is
	// specified the script will be executed directly, which will likely
	// only succeed for scripts with [shebang lines]
	// (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
	Interpreter ExecStepConfig_Interpreter `protobuf:"varint,4,opt,name=interpreter,proto3,enum=google.cloud.osconfig.v1.ExecStepConfig_Interpreter" json:"interpreter,omitempty"`
}

func (x *ExecStepConfig) Reset() {
	*x = ExecStepConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecStepConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecStepConfig) ProtoMessage() {}

func (x *ExecStepConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecStepConfig.ProtoReflect.Descriptor instead.
func (*ExecStepConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{17}
}

func (m *ExecStepConfig) GetExecutable() isExecStepConfig_Executable {
	if m != nil {
		return m.Executable
	}
	return nil
}

func (x *ExecStepConfig) GetLocalPath() string {
	if x, ok := x.GetExecutable().(*ExecStepConfig_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (x *ExecStepConfig) GetGcsObject() *GcsObject {
	if x, ok := x.GetExecutable().(*ExecStepConfig_GcsObject); ok {
		return x.GcsObject
	}
	return nil
}

func (x *ExecStepConfig) GetAllowedSuccessCodes() []int32 {
	if x != nil {
		return x.AllowedSuccessCodes
	}
	return nil
}

func (x *ExecStepConfig) GetInterpreter() ExecStepConfig_Interpreter {
	if x != nil {
		return x.Interpreter
	}
	return ExecStepConfig_INTERPRETER_UNSPECIFIED
}

type isExecStepConfig_Executable interface {
	isExecStepConfig_Executable()
}

type ExecStepConfig_LocalPath struct {
	// An absolute path to the executable on the VM.
	LocalPath string `protobuf:"bytes,1,opt,name=local_path,json=localPath,proto3,oneof"`
}

type ExecStepConfig_GcsObject struct {
	// A Cloud Storage object containing the executable.
	GcsObject *GcsObject `protobuf:"bytes,2,opt,name=gcs_object,json=gcsObject,proto3,oneof"`
}

func (*ExecStepConfig_LocalPath) isExecStepConfig_Executable() {}

func (*ExecStepConfig_GcsObject) isExecStepConfig_Executable() {}

// Cloud Storage object representation.
type GcsObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Bucket of the Cloud Storage object.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the Cloud Storage object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Required. Generation number of the Cloud Storage object. This is used to
	// ensure that the ExecStep specified by this PatchJob does not change.
	GenerationNumber int64 `protobuf:"varint,3,opt,name=generation_number,json=generationNumber,proto3" json:"generation_number,omitempty"`
}

func (x *GcsObject) Reset() {
	*x = GcsObject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsObject) ProtoMessage() {}

func (x *GcsObject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsObject.ProtoReflect.Descriptor instead.
func (*GcsObject) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{18}
}

func (x *GcsObject) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GcsObject) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *GcsObject) GetGenerationNumber() int64 {
	if x != nil {
		return x.GenerationNumber
	}
	return 0
}

// A filter to target VM instances for patching. The targeted
// VMs must meet all criteria specified. So if both labels and zones are
// specified, the patch job targets only VMs with those labels and in those
// zones.
type PatchInstanceFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target all VM instances in the project. If true, no other criteria is
	// permitted.
	All bool `protobuf:"varint,1,opt,name=all,proto3" json:"all,omitempty"`
	// Targets VM instances matching ANY of these GroupLabels. This allows
	// targeting of disparate groups of VM instances.
	GroupLabels []*PatchInstanceFilter_GroupLabel `protobuf:"bytes,2,rep,name=group_labels,json=groupLabels,proto3" json:"group_labels,omitempty"`
	// Targets VM instances in ANY of these zones. Leave empty to target VM
	// instances in any zone.
	Zones []string `protobuf:"bytes,3,rep,name=zones,proto3" json:"zones,omitempty"`
	// Targets any of the VM instances specified. Instances are specified by their
	// URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME],
	// `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or
	// `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
	Instances []string `protobuf:"bytes,4,rep,name=instances,proto3" json:"instances,omitempty"`
	// Targets VMs whose name starts with one of these prefixes. Similar to
	// labels, this is another way to group VMs when targeting configs, for
	// example prefix="prod-".
	InstanceNamePrefixes []string `protobuf:"bytes,5,rep,name=instance_name_prefixes,json=instanceNamePrefixes,proto3" json:"instance_name_prefixes,omitempty"`
}

func (x *PatchInstanceFilter) Reset() {
	*x = PatchInstanceFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchInstanceFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchInstanceFilter) ProtoMessage() {}

func (x *PatchInstanceFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchInstanceFilter.ProtoReflect.Descriptor instead.
func (*PatchInstanceFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{19}
}

func (x *PatchInstanceFilter) GetAll() bool {
	if x != nil {
		return x.All
	}
	return false
}

func (x *PatchInstanceFilter) GetGroupLabels() []*PatchInstanceFilter_GroupLabel {
	if x != nil {
		return x.GroupLabels
	}
	return nil
}

func (x *PatchInstanceFilter) GetZones() []string {
	if x != nil {
		return x.Zones
	}
	return nil
}

func (x *PatchInstanceFilter) GetInstances() []string {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *PatchInstanceFilter) GetInstanceNamePrefixes() []string {
	if x != nil {
		return x.InstanceNamePrefixes
	}
	return nil
}

// A summary of the current patch state across all instances that this patch
// job affects. Contains counts of instances in different states. These states
// map to `InstancePatchState`. List patch job instance details to see the
// specific states of each instance.
type PatchJob_InstanceDetailsSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of instances pending patch job.
	PendingInstanceCount int64 `protobuf:"varint,1,opt,name=pending_instance_count,json=pendingInstanceCount,proto3" json:"pending_instance_count,omitempty"`
	// Number of instances that are inactive.
	InactiveInstanceCount int64 `protobuf:"varint,2,opt,name=inactive_instance_count,json=inactiveInstanceCount,proto3" json:"inactive_instance_count,omitempty"`
	// Number of instances notified about patch job.
	NotifiedInstanceCount int64 `protobuf:"varint,3,opt,name=notified_instance_count,json=notifiedInstanceCount,proto3" json:"notified_instance_count,omitempty"`
	// Number of instances that have started.
	StartedInstanceCount int64 `protobuf:"varint,4,opt,name=started_instance_count,json=startedInstanceCount,proto3" json:"started_instance_count,omitempty"`
	// Number of instances that are downloading patches.
	DownloadingPatchesInstanceCount int64 `protobuf:"varint,5,opt,name=downloading_patches_instance_count,json=downloadingPatchesInstanceCount,proto3" json:"downloading_patches_instance_count,omitempty"`
	// Number of instances that are applying patches.
	ApplyingPatchesInstanceCount int64 `protobuf:"varint,6,opt,name=applying_patches_instance_count,json=applyingPatchesInstanceCount,proto3" json:"applying_patches_instance_count,omitempty"`
	// Number of instances rebooting.
	RebootingInstanceCount int64 `protobuf:"varint,7,opt,name=rebooting_instance_count,json=rebootingInstanceCount,proto3" json:"rebooting_instance_count,omitempty"`
	// Number of instances that have completed successfully.
	SucceededInstanceCount int64 `protobuf:"varint,8,opt,name=succeeded_instance_count,json=succeededInstanceCount,proto3" json:"succeeded_instance_count,omitempty"`
	// Number of instances that require reboot.
	SucceededRebootRequiredInstanceCount int64 `protobuf:"varint,9,opt,name=succeeded_reboot_required_instance_count,json=succeededRebootRequiredInstanceCount,proto3" json:"succeeded_reboot_required_instance_count,omitempty"`
	// Number of instances that failed.
	FailedInstanceCount int64 `protobuf:"varint,10,opt,name=failed_instance_count,json=failedInstanceCount,proto3" json:"failed_instance_count,omitempty"`
	// Number of instances that have acked and will start shortly.
	AckedInstanceCount int64 `protobuf:"varint,11,opt,name=acked_instance_count,json=ackedInstanceCount,proto3" json:"acked_instance_count,omitempty"`
	// Number of instances that exceeded the time out while applying the patch.
	TimedOutInstanceCount int64 `protobuf:"varint,12,opt,name=timed_out_instance_count,json=timedOutInstanceCount,proto3" json:"timed_out_instance_count,omitempty"`
	// Number of instances that are running the pre-patch step.
	PrePatchStepInstanceCount int64 `protobuf:"varint,13,opt,name=pre_patch_step_instance_count,json=prePatchStepInstanceCount,proto3" json:"pre_patch_step_instance_count,omitempty"`
	// Number of instances that are running the post-patch step.
	PostPatchStepInstanceCount int64 `protobuf:"varint,14,opt,name=post_patch_step_instance_count,json=postPatchStepInstanceCount,proto3" json:"post_patch_step_instance_count,omitempty"`
	// Number of instances that do not appear to be running the agent. Check to
	// ensure that the agent is installed, running, and able to communicate with
	// the service.
	NoAgentDetectedInstanceCount int64 `protobuf:"varint,15,opt,name=no_agent_detected_instance_count,json=noAgentDetectedInstanceCount,proto3" json:"no_agent_detected_instance_count,omitempty"`
}

func (x *PatchJob_InstanceDetailsSummary) Reset() {
	*x = PatchJob_InstanceDetailsSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchJob_InstanceDetailsSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchJob_InstanceDetailsSummary) ProtoMessage() {}

func (x *PatchJob_InstanceDetailsSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchJob_InstanceDetailsSummary.ProtoReflect.Descriptor instead.
func (*PatchJob_InstanceDetailsSummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{7, 0}
}

func (x *PatchJob_InstanceDetailsSummary) GetPendingInstanceCount() int64 {
	if x != nil {
		return x.PendingInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetInactiveInstanceCount() int64 {
	if x != nil {
		return x.InactiveInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetNotifiedInstanceCount() int64 {
	if x != nil {
		return x.NotifiedInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetStartedInstanceCount() int64 {
	if x != nil {
		return x.StartedInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetDownloadingPatchesInstanceCount() int64 {
	if x != nil {
		return x.DownloadingPatchesInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetApplyingPatchesInstanceCount() int64 {
	if x != nil {
		return x.ApplyingPatchesInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetRebootingInstanceCount() int64 {
	if x != nil {
		return x.RebootingInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetSucceededInstanceCount() int64 {
	if x != nil {
		return x.SucceededInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetSucceededRebootRequiredInstanceCount() int64 {
	if x != nil {
		return x.SucceededRebootRequiredInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetFailedInstanceCount() int64 {
	if x != nil {
		return x.FailedInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetAckedInstanceCount() int64 {
	if x != nil {
		return x.AckedInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetTimedOutInstanceCount() int64 {
	if x != nil {
		return x.TimedOutInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetPrePatchStepInstanceCount() int64 {
	if x != nil {
		return x.PrePatchStepInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetPostPatchStepInstanceCount() int64 {
	if x != nil {
		return x.PostPatchStepInstanceCount
	}
	return 0
}

func (x *PatchJob_InstanceDetailsSummary) GetNoAgentDetectedInstanceCount() int64 {
	if x != nil {
		return x.NoAgentDetectedInstanceCount
	}
	return 0
}

// Targets a group of VM instances by using their [assigned
// labels](https://cloud.google.com/compute/docs/labeling-resources). Labels
// are key-value pairs. A `GroupLabel` is a combination of labels
// that is used to target VMs for a patch job.
//
// For example, a patch job can target VMs that have the following
// `GroupLabel`: `{"env":"test", "app":"web"}`. This means that the patch job
// is applied to VMs that have both the labels `env=test` and `app=web`.
type PatchInstanceFilter_GroupLabel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Compute Engine instance labels that must be present for a VM
	// instance to be targeted by this filter.
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PatchInstanceFilter_GroupLabel) Reset() {
	*x = PatchInstanceFilter_GroupLabel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchInstanceFilter_GroupLabel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchInstanceFilter_GroupLabel) ProtoMessage() {}

func (x *PatchInstanceFilter_GroupLabel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchInstanceFilter_GroupLabel.ProtoReflect.Descriptor instead.
func (*PatchInstanceFilter_GroupLabel) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP(), []int{19, 0}
}

func (x *PatchInstanceFilter_GroupLabel) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

var File_google_cloud_osconfig_v1_patch_jobs_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_v1_patch_jobs_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xa1, 0x03, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x0c, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x70, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72,
	0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79,
	0x52, 0x75, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x52, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x22, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xbd, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6e, 0x0a, 0x1a, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x17, 0x70, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x92, 0x02, 0x0a, 0x17, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c,
	0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xb7, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x82, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x41, 0x0a, 0x0a, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x09, 0x70, 0x61, 0x74, 0x63, 0x68, 0x4a,
	0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdd, 0x0f, 0x0a, 0x08,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x0f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x0c, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0b, 0x70, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x35, 0x0a,
	0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x18, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x52, 0x16, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72, 0x79,
	0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52,
	0x75, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x5a, 0x0a, 0x10, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0xc1,
	0x07, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x36, 0x0a, 0x17, 0x69, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x15, 0x69, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x34, 0x0a, 0x16, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x22, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x1f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x45, 0x0a, 0x1f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x61, 0x70, 0x70,
	0x6c, 0x79, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x62,
	0x6f, 0x6f, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x72, 0x65, 0x62,
	0x6f, 0x6f, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x56, 0x0a,
	0x28, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x62, 0x6f, 0x6f,
	0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x24, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x52, 0x65, 0x62, 0x6f, 0x6f, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x63, 0x6b,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x18, 0x74,
	0x69, 0x6d, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x74,
	0x69, 0x6d, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x1d, 0x70, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x70, 0x72, 0x65,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x65, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x1e, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a,
	0x70, 0x6f, 0x73, 0x74, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x65, 0x70, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x20, 0x6e, 0x6f,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x6e, 0x6f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0x95, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4c, 0x4f, 0x4f,
	0x4b, 0x55, 0x50, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e,
	0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44,
	0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x5f,
	0x57, 0x49, 0x54, 0x48, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x53, 0x10, 0x05, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x54,
	0x49, 0x4d, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x07, 0x3a, 0x4f, 0xea, 0x41, 0x4c, 0x0a,
	0x20, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x12, 0x28, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x7b, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x22, 0xfe, 0x04, 0x0a, 0x0b,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0d, 0x72,
	0x65, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x62, 0x6f, 0x6f, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x72, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a, 0x03, 0x61, 0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x03, 0x61, 0x70, 0x74, 0x12, 0x37, 0x0a,
	0x03, 0x79, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x59, 0x75, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x03, 0x79, 0x75, 0x6d, 0x12, 0x37, 0x0a, 0x03, 0x67, 0x6f, 0x6f, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x6f, 0x6f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x03, 0x67, 0x6f, 0x6f, 0x12,
	0x40, 0x0a, 0x06, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x79, 0x70, 0x70, 0x65,
	0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x06, 0x7a, 0x79, 0x70, 0x70, 0x65,
	0x72, 0x12, 0x56, 0x0a, 0x0e, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0d, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x08, 0x70, 0x72, 0x65,
	0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x52,
	0x07, 0x70, 0x72, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12, 0x3f, 0x0a, 0x09, 0x70, 0x6f, 0x73, 0x74,
	0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x52,
	0x08, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x65, 0x70, 0x22, 0x51, 0x0a, 0x0c, 0x52, 0x65, 0x62,
	0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x42,
	0x4f, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41,
	0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10, 0x03, 0x22, 0xce, 0x02, 0x0a,
	0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xc1, 0x02, 0x0a, 0x0a, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x41, 0x54, 0x43,
	0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0b,
	0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x44,
	0x4f, 0x57, 0x4e, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x41, 0x54, 0x43, 0x48,
	0x45, 0x53, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47,
	0x5f, 0x50, 0x41, 0x54, 0x43, 0x48, 0x45, 0x53, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45,
	0x42, 0x4f, 0x4f, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x08, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x45, 0x44, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x51,
	0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x0b, 0x12, 0x0d,
	0x0a, 0x09, 0x54, 0x49, 0x4d, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x0c, 0x12, 0x1a, 0x0a,
	0x16, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x52, 0x45, 0x5f, 0x50, 0x41, 0x54,
	0x43, 0x48, 0x5f, 0x53, 0x54, 0x45, 0x50, 0x10, 0x0d, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x53, 0x54, 0x5f, 0x50, 0x41, 0x54, 0x43, 0x48, 0x5f,
	0x53, 0x54, 0x45, 0x50, 0x10, 0x0e, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x4f, 0x5f, 0x41, 0x47, 0x45,
	0x4e, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x0f, 0x22, 0x55, 0x0a,
	0x15, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x0b, 0x41, 0x70, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73,
	0x12, 0x2d, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x22,
	0x33, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x44, 0x49, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x50, 0x47, 0x52, 0x41,
	0x44, 0x45, 0x10, 0x02, 0x22, 0x8e, 0x01, 0x0a, 0x0b, 0x59, 0x75, 0x6d, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x18, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x22, 0x0d, 0x0a, 0x0b, 0x47, 0x6f, 0x6f, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x22, 0xdf, 0x01, 0x0a, 0x0e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x69, 0x74, 0x68, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x77, 0x69, 0x74, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x1f, 0x0a, 0x0b,
	0x77, 0x69, 0x74, 0x68, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x77, 0x69, 0x74, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a,
	0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x1e, 0x0a,
	0x0a, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1a, 0x0a,
	0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x22, 0x82, 0x03, 0x0a, 0x15, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x68, 0x0a, 0x0f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x0e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49,
	0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x49, 0x54, 0x49, 0x43,
	0x41, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59,
	0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x52, 0x49, 0x56, 0x45, 0x52, 0x10, 0x04, 0x12, 0x10,
	0x0a, 0x0c, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x10, 0x05,
	0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x50, 0x41, 0x43, 0x4b,
	0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x4f, 0x4f, 0x4c, 0x10, 0x07, 0x12, 0x11, 0x0a, 0x0d,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x55, 0x50, 0x10, 0x08, 0x12,
	0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x09, 0x22, 0xcc, 0x01, 0x0a, 0x08,
	0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x12, 0x5d, 0x0a, 0x16, 0x6c, 0x69, 0x6e, 0x75,
	0x78, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x13, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65,
	0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x18, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x15, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x45, 0x78, 0x65, 0x63,
	0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd8, 0x02, 0x0a, 0x0e, 0x45,
	0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a,
	0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x44,
	0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63,
	0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x05, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65,
	0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72,
	0x22, 0x45, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x12,
	0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x57, 0x45, 0x52,
	0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x77, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x30, 0x0a, 0x11,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x96,
	0x03, 0x0a, 0x13, 0x50, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x6c, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x12, 0x5b, 0x0a, 0x0c, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x1a,
	0xa5, 0x01, 0x0a, 0x0a, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x5c,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0xbf, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a,
	0x6f, 0x62, 0x73, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescData = file_google_cloud_osconfig_v1_patch_jobs_proto_rawDesc
)

func file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescData)
	})
	return file_google_cloud_osconfig_v1_patch_jobs_proto_rawDescData
}

var file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_osconfig_v1_patch_jobs_proto_goTypes = []interface{}{
	(PatchJob_State)(0),                         // 0: google.cloud.osconfig.v1.PatchJob.State
	(PatchConfig_RebootConfig)(0),               // 1: google.cloud.osconfig.v1.PatchConfig.RebootConfig
	(Instance_PatchState)(0),                    // 2: google.cloud.osconfig.v1.Instance.PatchState
	(AptSettings_Type)(0),                       // 3: google.cloud.osconfig.v1.AptSettings.Type
	(WindowsUpdateSettings_Classification)(0),   // 4: google.cloud.osconfig.v1.WindowsUpdateSettings.Classification
	(ExecStepConfig_Interpreter)(0),             // 5: google.cloud.osconfig.v1.ExecStepConfig.Interpreter
	(*ExecutePatchJobRequest)(nil),              // 6: google.cloud.osconfig.v1.ExecutePatchJobRequest
	(*GetPatchJobRequest)(nil),                  // 7: google.cloud.osconfig.v1.GetPatchJobRequest
	(*ListPatchJobInstanceDetailsRequest)(nil),  // 8: google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest
	(*ListPatchJobInstanceDetailsResponse)(nil), // 9: google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse
	(*PatchJobInstanceDetails)(nil),             // 10: google.cloud.osconfig.v1.PatchJobInstanceDetails
	(*ListPatchJobsRequest)(nil),                // 11: google.cloud.osconfig.v1.ListPatchJobsRequest
	(*ListPatchJobsResponse)(nil),               // 12: google.cloud.osconfig.v1.ListPatchJobsResponse
	(*PatchJob)(nil),                            // 13: google.cloud.osconfig.v1.PatchJob
	(*PatchConfig)(nil),                         // 14: google.cloud.osconfig.v1.PatchConfig
	(*Instance)(nil),                            // 15: google.cloud.osconfig.v1.Instance
	(*CancelPatchJobRequest)(nil),               // 16: google.cloud.osconfig.v1.CancelPatchJobRequest
	(*AptSettings)(nil),                         // 17: google.cloud.osconfig.v1.AptSettings
	(*YumSettings)(nil),                         // 18: google.cloud.osconfig.v1.YumSettings
	(*GooSettings)(nil),                         // 19: google.cloud.osconfig.v1.GooSettings
	(*ZypperSettings)(nil),                      // 20: google.cloud.osconfig.v1.ZypperSettings
	(*WindowsUpdateSettings)(nil),               // 21: google.cloud.osconfig.v1.WindowsUpdateSettings
	(*ExecStep)(nil),                            // 22: google.cloud.osconfig.v1.ExecStep
	(*ExecStepConfig)(nil),                      // 23: google.cloud.osconfig.v1.ExecStepConfig
	(*GcsObject)(nil),                           // 24: google.cloud.osconfig.v1.GcsObject
	(*PatchInstanceFilter)(nil),                 // 25: google.cloud.osconfig.v1.PatchInstanceFilter
	(*PatchJob_InstanceDetailsSummary)(nil),     // 26: google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary
	(*PatchInstanceFilter_GroupLabel)(nil),      // 27: google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel
	nil,                                         // 28: google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel.LabelsEntry
	(*duration.Duration)(nil),                   // 29: google.protobuf.Duration
	(*timestamp.Timestamp)(nil),                 // 30: google.protobuf.Timestamp
}
var file_google_cloud_osconfig_v1_patch_jobs_proto_depIdxs = []int32{
	25, // 0: google.cloud.osconfig.v1.ExecutePatchJobRequest.instance_filter:type_name -> google.cloud.osconfig.v1.PatchInstanceFilter
	14, // 1: google.cloud.osconfig.v1.ExecutePatchJobRequest.patch_config:type_name -> google.cloud.osconfig.v1.PatchConfig
	29, // 2: google.cloud.osconfig.v1.ExecutePatchJobRequest.duration:type_name -> google.protobuf.Duration
	10, // 3: google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse.patch_job_instance_details:type_name -> google.cloud.osconfig.v1.PatchJobInstanceDetails
	2,  // 4: google.cloud.osconfig.v1.PatchJobInstanceDetails.state:type_name -> google.cloud.osconfig.v1.Instance.PatchState
	13, // 5: google.cloud.osconfig.v1.ListPatchJobsResponse.patch_jobs:type_name -> google.cloud.osconfig.v1.PatchJob
	30, // 6: google.cloud.osconfig.v1.PatchJob.create_time:type_name -> google.protobuf.Timestamp
	30, // 7: google.cloud.osconfig.v1.PatchJob.update_time:type_name -> google.protobuf.Timestamp
	0,  // 8: google.cloud.osconfig.v1.PatchJob.state:type_name -> google.cloud.osconfig.v1.PatchJob.State
	25, // 9: google.cloud.osconfig.v1.PatchJob.instance_filter:type_name -> google.cloud.osconfig.v1.PatchInstanceFilter
	14, // 10: google.cloud.osconfig.v1.PatchJob.patch_config:type_name -> google.cloud.osconfig.v1.PatchConfig
	29, // 11: google.cloud.osconfig.v1.PatchJob.duration:type_name -> google.protobuf.Duration
	26, // 12: google.cloud.osconfig.v1.PatchJob.instance_details_summary:type_name -> google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary
	1,  // 13: google.cloud.osconfig.v1.PatchConfig.reboot_config:type_name -> google.cloud.osconfig.v1.PatchConfig.RebootConfig
	17, // 14: google.cloud.osconfig.v1.PatchConfig.apt:type_name -> google.cloud.osconfig.v1.AptSettings
	18, // 15: google.cloud.osconfig.v1.PatchConfig.yum:type_name -> google.cloud.osconfig.v1.YumSettings
	19, // 16: google.cloud.osconfig.v1.PatchConfig.goo:type_name -> google.cloud.osconfig.v1.GooSettings
	20, // 17: google.cloud.osconfig.v1.PatchConfig.zypper:type_name -> google.cloud.osconfig.v1.ZypperSettings
	21, // 18: google.cloud.osconfig.v1.PatchConfig.windows_update:type_name -> google.cloud.osconfig.v1.WindowsUpdateSettings
	22, // 19: google.cloud.osconfig.v1.PatchConfig.pre_step:type_name -> google.cloud.osconfig.v1.ExecStep
	22, // 20: google.cloud.osconfig.v1.PatchConfig.post_step:type_name -> google.cloud.osconfig.v1.ExecStep
	3,  // 21: google.cloud.osconfig.v1.AptSettings.type:type_name -> google.cloud.osconfig.v1.AptSettings.Type
	4,  // 22: google.cloud.osconfig.v1.WindowsUpdateSettings.classifications:type_name -> google.cloud.osconfig.v1.WindowsUpdateSettings.Classification
	23, // 23: google.cloud.osconfig.v1.ExecStep.linux_exec_step_config:type_name -> google.cloud.osconfig.v1.ExecStepConfig
	23, // 24: google.cloud.osconfig.v1.ExecStep.windows_exec_step_config:type_name -> google.cloud.osconfig.v1.ExecStepConfig
	24, // 25: google.cloud.osconfig.v1.ExecStepConfig.gcs_object:type_name -> google.cloud.osconfig.v1.GcsObject
	5,  // 26: google.cloud.osconfig.v1.ExecStepConfig.interpreter:type_name -> google.cloud.osconfig.v1.ExecStepConfig.Interpreter
	27, // 27: google.cloud.osconfig.v1.PatchInstanceFilter.group_labels:type_name -> google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel
	28, // 28: google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel.labels:type_name -> google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel.LabelsEntry
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_v1_patch_jobs_proto_init() }
func file_google_cloud_osconfig_v1_patch_jobs_proto_init() {
	if File_google_cloud_osconfig_v1_patch_jobs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutePatchJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPatchJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPatchJobInstanceDetailsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPatchJobInstanceDetailsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchJobInstanceDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPatchJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPatchJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelPatchJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AptSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*YumSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GooSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ZypperSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsUpdateSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecStepConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsObject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchInstanceFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchJob_InstanceDetailsSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchInstanceFilter_GroupLabel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*ExecStepConfig_LocalPath)(nil),
		(*ExecStepConfig_GcsObject)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_v1_patch_jobs_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_v1_patch_jobs_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_v1_patch_jobs_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_v1_patch_jobs_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_v1_patch_jobs_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_v1_patch_jobs_proto = out.File
	file_google_cloud_osconfig_v1_patch_jobs_proto_rawDesc = nil
	file_google_cloud_osconfig_v1_patch_jobs_proto_goTypes = nil
	file_google_cloud_osconfig_v1_patch_jobs_proto_depIdxs = nil
}
