package basic

import (
	"testing"
)

type shaDatum struct {
	password string
	hashed   string
}

var shaTestData = []shaDatum{
	shaDatum{"mickey5", "{SHA}D9rQ8iK6feNAniulHNKdr5V38ok="},
	shaDatum{"alexandrew", "{SHA}KS7VQqgAnMUfXgWmFCCa6DVhY+M="},
	shaDatum{"hawaiicats78", "{SHA}mzD9ouM0P06arY0Obdb2KojkFeY="},
	shaDatum{"DIENOW", "{SHA}2HrOk971ockoAr1Ct1o7GpvFLdU="},
	shaDatum{"e8f685", "{SHA}IyrjpSzIjrlLT7KjVh1q1LBDCFA="},
	shaDatum{"Rickygirl03", "{SHA}gh5ZdWJ6UypV+CRv8Kd0herEe8U="},
	shaDatum{"123vb123", "{SHA}19j8b+o4MIImvb7zkv4gncUWs1s="},
	shaDatum{"sheng060576", "{SHA}u5hjc4kFFwv2QrMa49uCmn7RmPQ="},
	shaDatum{"hansisme", "{SHA}Au92ail1kvpgW+HC4PiuJu1Yays="},
	shaDatum{"h4ck3rs311t3", "{SHA}KvvqIY6j/LU3D/orcNYioTE4yOQ="},
	shaDatum{"K90JyTGA", "{SHA}QftskBtqwp5hsovHb+dGB7azRsI="},
	shaDatum{"aspire5101", "{SHA}vjUxr9fJRAYTdO0lZb83C2z0FKo="},
	shaDatum{"553568", "{SHA}FTguhILOzfejAav4aWK2X4D51qE="},
	shaDatum{"SRI", "{SHA}7CPWhF7FKaS6fBC+zAuncRjVDOo="},
	shaDatum{"maxmus", "{SHA}tHLz2JrCsGMOAPUh38Td1yP65rI="},
	shaDatum{"a5xp9707", "{SHA}qTzg8xc+MFLHwsR9DFVuUTPiFA8="},
	shaDatum{"tomasrim", "{SHA}BxtDkfZMLEfKDlqluTcU/UOFknw="},
	shaDatum{"2a0mag", "{SHA}cnCoTKX3EK7nIA+zmxcu3ovItrM="},
	shaDatum{"wmsfht", "{SHA}pBahyhKlvfj+JoJNul/LNITFz+A="},
	shaDatum{"webmaster2364288", "{SHA}NQb47c348gpwiOL+NqztAYm6LVQ="},
	shaDatum{"121516m", "{SHA}Oy/RamubYWzVZ1IxxiezV5G8ODc="},
	shaDatum{"T69228803", "{SHA}gN1LmPBMrRxZkzhipSu/vEKgqnY="},
	shaDatum{"qq820221", "{SHA}zMx1exH6oGOtF78Y8ZY7KPp2E5k="},
	shaDatum{"chenfy", "{SHA}5wQp5hYE/N3i/i6Yjz97fBQwh/s="},
	shaDatum{"www.debure.net", "{SHA}quy6WOPSGssG33/XYI1GjM1EcSw="},
	shaDatum{"1333e763", "{SHA}rmbzU+tedWkSg4z19JgtmpXoO60="},
	shaDatum{"burberries", "{SHA}lCe4FgTHpkpOhbCp0K5JqA5Ze9Q="},
	shaDatum{"chanmee14", "{SHA}AJnAjBWd4U8wze/raohAgH69VJk="},
	shaDatum{"65432106543210", "{SHA}CesAlg5KhkapACkKNGlfyDZu1RA="},
	shaDatum{"powernet", "{SHA}K3p3TiyMMAcQ5vVa+dGNV3x4dXs="},
	shaDatum{"a2d8i6a7", "{SHA}w5xupnv3GzEjrZeRTaN/BAIwZG0="},
	shaDatum{"gvs9ptc", "{SHA}5i89qVd8KDVGIj/6WCs42qiLz78="},
	shaDatum{"Pookie", "{SHA}dyfp5ehLdcgD8DV5OTPFMOgapMw="},
	shaDatum{"lorissss", "{SHA}nPBPyIWbALLxg9JZQfsMjS4RcwU="},
	shaDatum{"ess", "{SHA}Uk8l/rcR+Og3uJP/+q604N8MY40="},
	shaDatum{"sparra", "{SHA}hIoJ2Qv4wRE3IOC0T+2PhtuhIRs="},
	shaDatum{"allysson", "{SHA}zoSpRZj3pbSShQ9O/SQs+72Let8="},
	shaDatum{"99128008", "{SHA}6LIl/XA9I2XAqwjj2oyYbAGtbOE="},
	shaDatum{"evisanne", "{SHA}+04wmC0awrfmGiRG+HJXjzB3ksw="},
	shaDatum{"qfxg7x9l", "{SHA}8ppTyzpxZSWxqsnvxLtFJrvJV0E="},
	shaDatum{"03415", "{SHA}7D+UYPYha3+V5/PRn2lmCoLkE3E="},
	shaDatum{"87832309", "{SHA}DdMdedbyWGN2wXXkFEiaq0aH9r4="},
	shaDatum{"816283", "{SHA}apgv+JsqqKiGnwxX93atjb/XRDU="},
	shaDatum{"banach12", "{SHA}7k3SGIwIJzTmBgFXSlJuO7OvLx8="},
	shaDatum{"sjdszpsc", "{SHA}jTKQDFGg8jCZfA7Z7NTvF9ayFNQ="},
	shaDatum{"changsing", "{SHA}9Ugo2jB2WaxPh24gPzBGY1zk8XA="},
	shaDatum{"56339388", "{SHA}VziiTWLQk/9DswnexDFgWnA0i7Q="},
	shaDatum{"52114157", "{SHA}4DANwobCvUtq/rIntyXbGBRx1Ag="},
	shaDatum{"jinebimb", "{SHA}3Hrb7SJv64iKtC6+p/hkSwt7DqI="},
	shaDatum{"erol43", "{SHA}mhvtao9e4qlisxYyuFvpiDgk9AA="},
	shaDatum{"2yagos", "{SHA}gOUVpYSGfZS2G1e1ETbr9xh3s2w="},
	shaDatum{"habparty!", "{SHA}uwszyh+dmQGG7TTF+og53Ktkoxs="},
	shaDatum{"tangjianhui", "{SHA}aARgf7klVi/pz8VN86UyQTGzz1Q="},
	shaDatum{"serandah", "{SHA}zsl2jAqcqruDzXNA8N0mSLUZbzY="},
	shaDatum{"mirrages", "{SHA}UTUesDbSS6/GgPE9iZf3lrCWZTQ="},
	shaDatum{"mantgaxxl", "{SHA}l7my97BzljjfxmBiJckh4YSyb98="},
	shaDatum{"45738901", "{SHA}BvqybCxPG+FdshJEASmykXCKFJs="},
	shaDatum{"g523minna", "{SHA}8vtQDuXJUEzst96ogzkYvG8uxng="},
	shaDatum{"j202020", "{SHA}Kdw33gVp/H9JnSZLlWsnPsima8k="},
	shaDatum{"g@mmaecho", "{SHA}pngHweDVwzvWLbkxKI0jpOFMTM8="},
	shaDatum{"042380", "{SHA}BVd3k63K6BSYJK1B/hjI8yNXfN0="},
	shaDatum{"ASRuin", "{SHA}smmoa8r9gdt2lp7HcRV2K5/IIIc="},
	shaDatum{"061990", "{SHA}mQqcr8Htt8OdiJfi6ZATYKrThEY="},
	shaDatum{"ysoline", "{SHA}+r2NvWFQ5X+4vorvec9K2mFDuOE="},
	shaDatum{"liuzhouzhou", "{SHA}sEmnRhZegMdBDNnYnyVB47TeLdg="},
	shaDatum{"b0000000wind", "{SHA}aSdcYgX9Dm3KW/Za/tlT57vxgEs="},
	shaDatum{"7913456852", "{SHA}Mw6kTqFaODDOJj5VpTT2ch/YmeE="},
	shaDatum{"9008", "{SHA}VUcPEIUzSnM4hAcg6rxZjmLVDJ0="},
	shaDatum{"waitlin11", "{SHA}ZLBhQrXPeeuv1cCPi+7jJPxgXVI="},
	shaDatum{"8fdakar", "{SHA}n3eCpjIH9zhOq8ZPlEXJu6p7z+4="},
	shaDatum{"eisball", "{SHA}rV5kTR4QT6OUb5x34+U4V7KCLaY="},
	shaDatum{"jenna17", "{SHA}7p5fBYB+sDLAAUlXN7mRGpplD68="},
	shaDatum{"belkadonam", "{SHA}cTgM/9Qsi2NMwHIVfkRcURDXsdc="},
	shaDatum{"tfyuj9JW", "{SHA}yxMuwJUB/2qDA4nryzDaWwDTwkw="},
	shaDatum{"nihaijidema", "{SHA}eRz741UJnWDv3as1Zr2hXD+V5NY="},
	shaDatum{"talapia", "{SHA}cgoLdQ4IZQJsWhuAk+JCTQ8t9ro="},
	shaDatum{"7376220", "{SHA}fySbHcTbxJwfik52qAUS8rI+hzo="},
	shaDatum{"c7m8e1xsc3", "{SHA}lzR3In34RL83gu8qY87y0YHheew="},
	shaDatum{"84129793", "{SHA}15alyIIv299z3WG9HSMyypwPHrk="},
	shaDatum{"test1000", "{SHA}d6DZQ826zlJxap75+uEuReJ4jTk="},
	shaDatum{"ecmanhatten", "{SHA}7KJnN2t/mNwfOL+l3iWaxOhxoTM="},
	shaDatum{"EvanYo3327", "{SHA}vM6SgURZ4FWN09Qkhg9GKfYNlvI="},
	shaDatum{"269john139", "{SHA}Opk05mxS7TatlO37aS/U9IIVQ8g="},
	shaDatum{"3348159zw", "{SHA}C9q9Bn45z0QrZmQ39373SmzvDIU="},
	shaDatum{"lu184020", "{SHA}kVVGcThWup+til7v26KfKky9tF0="},
	shaDatum{"aszasw", "{SHA}8vG8fcwUCtnsSxWNTQOZyjmMN9U="},
	shaDatum{"33059049", "{SHA}rTkBT+vWAX8AkrMCneVIoGWMPIs="},
	shaDatum{"li3255265", "{SHA}4z+IIfZ6CC3UooUH+pntq40RGLU="},
	shaDatum{"kerrihayes", "{SHA}97ep9vYDA8k3ULenovM1JUP/ZuM="},
	shaDatum{"0167681809", "{SHA}4LkUGAH8SUWCmhpgSR+UoVEuoIU="},
	shaDatum{"stefano123", "{SHA}VMb2w8BIouL+pnejIpju4YvSFrA="},
	shaDatum{"15054652730", "{SHA}TDOwuWHnpr8IWec4G4BV0C1dugY="},
	shaDatum{"natdvd213", "{SHA}YU7zF05TgscOFcJyYpoQqYEsYZU="},
	shaDatum{"680929", "{SHA}0q/yO/YHEg+nTHaZj9wUMpYXc8U="},
	shaDatum{"steelpad8", "{SHA}XRyWxrZ4CYOdZetXUtoBNOYBgkA="},
	shaDatum{"374710", "{SHA}B9utQxyZ22KOIV5ucDFQOQBHOmI="},
	shaDatum{"394114", "{SHA}pBSxqpqhhW+Gwpq+mPNsstCr8tM="},
	shaDatum{"24347", "{SHA}lLeRG7AY/3SvGfvIWXrJLuAFLHo="},
	shaDatum{"krait93", "{SHA}QzZbE1LP+9XcLOc+2FxJuydCQZY="},
	shaDatum{"5164794", "{SHA}Ycbe25pEYtUEXhwcEhb4KQjdJmU="},
	shaDatum{"rswCyJE5", "{SHA}bIPx+G5TLj+NPl0MfyVy85moTJ8="},
	shaDatum{"31480019", "{SHA}ooI9TrVVE7LkLKm5UWwTZT5NDW4="},
	shaDatum{"19830907ok", "{SHA}bEIqh9ertcOn4weApT0AoOM04oU="},
	shaDatum{"zlsmhzlsmh", "{SHA}o51ovielNeyLtb8WuWL0r4PNXus="},
	shaDatum{"Zengatsu", "{SHA}kJDexedKxfHbXeo9MDBUZgagMJA="},
	shaDatum{"0127603331", "{SHA}Q5t2BVGrnc6e0WXfX3dmgPeFdw8="},
	shaDatum{"axelle77", "{SHA}2gUrA8RSDeAsBqTLEjZdaMn+jgo="},
	shaDatum{"password2147", "{SHA}7/hIGwVORnrIkQ45Kam+1bQAvzg="},
	shaDatum{"olixkl8b", "{SHA}Ys9f3svSIg9qsti6VK/KO73Whyw="},
	shaDatum{"maiwen", "{SHA}wFrYvAKCXwBKqeLvEN/vpLPDqiY="},
	shaDatum{"198613", "{SHA}jCtBfLQYgycvbgwtlsTk0RaBcyk="},
	shaDatum{"s17kr8wu", "{SHA}1ndFd2yaVGQ++IN3o4s7nhmJd6c="},
	shaDatum{"biker02", "{SHA}3xG++i1ZRHjEAMWIwuLa/lln4Os="},
	shaDatum{"m1399", "{SHA}lFkJRnfrNTNxWWwLVuS4TDdDT2g="},
	shaDatum{"a2dc6a", "{SHA}xuNHuDtaTcimJJfoic1iM5V3+74="},
	shaDatum{"zhd8902960", "{SHA}OZ1xZJTVdEVVKSOYEUWsJInUxoY="},
	shaDatum{"parasuta", "{SHA}LqofIkTgPad+sr0Qfmh5xmd7F7k="},
	shaDatum{"the1secret", "{SHA}tzixFK8WpqP0bM0qS5sLHEurrm8="},
	shaDatum{"teddy14", "{SHA}H3PBIct3rsU9JIPys8flehjPd3A="},
	shaDatum{"4516388amt", "{SHA}HINCI2ECClS+2vjbEyE/KBDrz08="},
	shaDatum{"245520", "{SHA}T2K08XkQmxOIIFMxN7QN/dHtaXk="},
	shaDatum{"D34dw00d", "{SHA}mMOZxFazBwasFq0MdAVvMQw5b30="},
	shaDatum{"officiel", "{SHA}BrQDy1wpNzHm2EYj20X3PWbtGIc="},
	shaDatum{"36653665", "{SHA}POdeGoaJ4u9dDL7+1aSpKG7u7Jo="},
	shaDatum{"hipol", "{SHA}J+YDaKhmEbjYz71UaVshKoCxg7c="},
	shaDatum{"Nylon0", "{SHA}g9Gphl4ckCSIFal2qP1G+WyIWIs="},
	shaDatum{"caitlyne6", "{SHA}swnIE5GKm3qcHsCdYAVlR9vfldM="},
	shaDatum{"dogzilla", "{SHA}cu8KAzVlpHUeCIDL3dDmhoZwu9k="},
	shaDatum{"lemegaboss", "{SHA}oDyWybc7jVPlmqA+e+F4t/thfRA="},
	shaDatum{"c0valerius", "{SHA}8Y2mGtCTaGznCWYhA/K+XrejBB4="},
	shaDatum{"liseczek44", "{SHA}digyAvFugxt+pDECZ/1XMyHysGo="},
	shaDatum{"saulosi", "{SHA}huAd/hD7INmNYaTrOKbS4auA4Yk="},
	shaDatum{"53522", "{SHA}JK5NmoqlEpzEtwI8cyILiMh710w="},
	shaDatum{"ajgebam", "{SHA}t/RpkDJt44MYi97pB25RABGCTdw="},
	shaDatum{"freshplayer", "{SHA}FW+1cwXfHQtLjBjt9EkBNwnuHnY="},
	shaDatum{"logistica1", "{SHA}jTj0t+mHSGoxWFexu7ac+v8nHCQ="},
	shaDatum{"12calo66", "{SHA}cKdPr0oYieZ1qSvGpMk7G6hB7mw="},
	shaDatum{"kenno", "{SHA}7rCX8u5lLwCcAzDReeSjlU/QkgI="},
	shaDatum{"34639399", "{SHA}r8kaguSOy20qHsPRkQ2uMzKasM8="},
	shaDatum{"0408636405", "{SHA}V7Hjc5P/zB+sxHcqKPkgyodAFT4="},
	shaDatum{"weezer12", "{SHA}YR60ptREeIpQv0B4cho/t2kzODw="},
	shaDatum{"9888735777", "{SHA}zwfYrgeJ508R2yvS/SdyZPNUuw0="},
	shaDatum{"7771877", "{SHA}pKvhH74q06+iWSbsIg9jOqLIOuw="},
	shaDatum{"6620852", "{SHA}LYBr5lIErSckQ/wKA3+YEZin728="},
	shaDatum{"98billiards", "{SHA}eXKk+N0xbstCZ6FV28J/XtVSYiY="},
	shaDatum{"angelik", "{SHA}k80oUNvldNqQwDvS7n9/U7uqyAA="},
	shaDatum{"86815057", "{SHA}nOQ2Wjlc5BGlvX5BfN+RMbH+mKg="},
	shaDatum{"p16alfalfa", "{SHA}O6wvUOWKPtROfqtXZ4TMjlJ/Eqw="},
	shaDatum{"7236118", "{SHA}G1oAkkte9vKp330iZKVnwoyV/FE="},
	shaDatum{"glock17l", "{SHA}6Fys40HEBJYb58Xk4MEa3dYmfh0="},
	shaDatum{"sigmundm", "{SHA}V0QFZ76ISexnBTXJNn4egImklsI="},
	shaDatum{"ltbgeqsd", "{SHA}O5XnrX44sxaey9uUvGLkJQXthkw="},
	shaDatum{"wqnd8k2m", "{SHA}uYqLu0+hCAVauHxHhHj9S8K6dLQ="},
	shaDatum{"yangjunjie", "{SHA}bNXP45UPcI6hnkXMm9XNE4LncRc="},
	shaDatum{"manjinder", "{SHA}u4yMsvZEFcal38qQSk6pK/YeljY="},
	shaDatum{"nick2000", "{SHA}5xFv7yRZIk605O6D1cn52caIorY="},
	shaDatum{"193416", "{SHA}eMiZn8p3ZPwXjrzScxmVZDo5W6s="},
	shaDatum{"pang168", "{SHA}kjiXjei7Tjszq9RunSYjJ++OUHM="},
	shaDatum{"454016", "{SHA}TPcur6LmXg4W+FcHKhC2JVIDnwI="},
	shaDatum{"phair08", "{SHA}2EckYONFyUcDEqgkPhbfah9cHK8="},
	shaDatum{"10252007cw", "{SHA}/3sW+7ineIj1jOU0Dby9nP3ZspA="},
	shaDatum{"zhuzhuzhu", "{SHA}9mONNF7CArnydjmwkhfQebkGaOo="},
	shaDatum{"metafunds", "{SHA}rGImsJEm0Pd8fbE40OBmP6VGfIY="},
	shaDatum{"smash", "{SHA}Mf6CeupM9fas594sId4LX2t4OFg="},
	shaDatum{"76387638", "{SHA}HxRugr3cGBjQB75CJ9urfWG9YSI="},
	shaDatum{"S226811954", "{SHA}Nh+ikcGOUUgInrJh0iHlVlBmsrw="},
	shaDatum{"mintymoo00", "{SHA}3BrwZ+qGvcyFB/Lc/XDfOFWwxXQ="},
	shaDatum{"seven711", "{SHA}8mvvCcUzMnsapzC953/XCxfOT+8="},
	shaDatum{"924414", "{SHA}3X/lD6ATcOaRHopH+6m27+LVeIM="},
	shaDatum{"changchengxu", "{SHA}Ttiw09bDmyeY/YhY0H/YX6MrHWY="},
	shaDatum{"alaska58", "{SHA}wpd/t9fl65nDq3cSCmRYwv9v65E="},
	shaDatum{"7678208", "{SHA}pltR0K3LNrS/qOcwZjzTlXpmw+U="},
	shaDatum{"szazsoo73", "{SHA}mU+OEwW2NBcebLfRPZ9C/Ki0vCI="},
	shaDatum{"3830371", "{SHA}sOfYGqpAMRqXD4e69F6oH3IrqRc="},
	shaDatum{"0qdzx66b", "{SHA}IjbOYS0WcCo0Op0Sz+ETYSVmHNA="},
	shaDatum{"09124248099", "{SHA}e61WLuSD9xNufpbU1Y8wKlgupXM="},
	shaDatum{"bachrain", "{SHA}3Z41BvXKnswJCMrPj94Xj3Lmd0s="},
	shaDatum{"sJsSdFBY", "{SHA}p96d7T+S9V6V8NuYLF679N35qHA="},
	shaDatum{"676215000", "{SHA}yqC6+2MiJondbEaBtxMBn0X81Zw="},
	shaDatum{"nimamapwoaini", "{SHA}cC4wcJtLGRSHKlIqwkr72t9/b9w="},
	shaDatum{"nitsuj", "{SHA}hgNZhLC7ZcfxDef0KFz/xEabK+E="},
	shaDatum{"cukierek2003", "{SHA}ptbHX+v+J4WVRvM9a2tlWTOIjaQ="},
	shaDatum{"seeder", "{SHA}ls+1/MdSymeKHyVoU6OJ2n9VF2s="},
	shaDatum{"00167148786", "{SHA}oRqSqk2/YvT0NNWY9M9ejSNRWms="},
	shaDatum{"ashok198", "{SHA}mFHUN4xN0yWhXLeHSeRxPFXNIUA="},
	shaDatum{"kt2116", "{SHA}W0GRYxTwoVnywElvbpwdNR0wEmk="},
	shaDatum{"another82", "{SHA}CVVbc3vnDGApFxvmTX+/4WUErnE="},
	shaDatum{"75995794", "{SHA}pKxQI+Q6WmVal5D8XMAy9c3jEyM="},
	shaDatum{"19901130", "{SHA}C91rFij4vkgcUZisF7TTcpMUFKA="},
	shaDatum{"gijs010389", "{SHA}nyzMGhYQfLMBCG7rBtXnbj0bF0Y="},
	shaDatum{"26263199", "{SHA}hw69n/v0JJf7Z1UK0hn6NcQOiMY="},
	shaDatum{"hi1j42x8", "{SHA}iTz0n/olV3SiPW9zQX2v2/sYZHE="},
	shaDatum{"6922235", "{SHA}NM/XeJbQkI57FPhUn0pU4pV6tYc="},
	shaDatum{"67749330", "{SHA}ws12wS7j4dCN+IItHQi8SZS00kc="},
	shaDatum{"ccpatrik", "{SHA}HhYw12y7WG8xahUNKf4MHlUPitA="},
	shaDatum{"summer3011", "{SHA}KrCi609b3nk3uKVCgw76/cbsAZc="},
	shaDatum{"331516", "{SHA}uSyZbnpZu1t1TsvoUyp4TsQvePs="},
	shaDatum{"135745", "{SHA}oLBO8TyN9/yjytrlYF6NW0o6He0="},
	shaDatum{"603762004", "{SHA}axYN5gmBWHFLDMoMf4Oj/t4ND9I="},
	shaDatum{"29011985", "{SHA}KdFYg6fHUtb8tvbRWak+g+kyk/A="},
}

func Test_Sha(t *testing.T) {
	for _, v := range shaTestData {
		testParserGood(t, "sha", AcceptSha, RejectSha, v.hashed, v.password)
	}
	testParserBad(t, "sha", AcceptSha, RejectSha, "{SHA}Ys23Ag/5IOWqZCw9dHwH00=")
	testParserBad(t, "sha", AcceptSha, RejectSha, "{SHA}plaintext")
	testParserNot(t, "sha", AcceptSha, RejectSha, "plaintext")
}
