// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptDirectConnectGatewayAssociationProposal = "AcceptDirectConnectGatewayAssociationProposal"

// AcceptDirectConnectGatewayAssociationProposalRequest generates a "aws/request.Request" representing the
// client's request for the AcceptDirectConnectGatewayAssociationProposal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptDirectConnectGatewayAssociationProposal for more information on using the AcceptDirectConnectGatewayAssociationProposal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptDirectConnectGatewayAssociationProposalRequest method.
//    req, resp := client.AcceptDirectConnectGatewayAssociationProposalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AcceptDirectConnectGatewayAssociationProposal
func (c *DirectConnect) AcceptDirectConnectGatewayAssociationProposalRequest(input *AcceptDirectConnectGatewayAssociationProposalInput) (req *request.Request, output *AcceptDirectConnectGatewayAssociationProposalOutput) {
	op := &request.Operation{
		Name:       opAcceptDirectConnectGatewayAssociationProposal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptDirectConnectGatewayAssociationProposalInput{}
	}

	output = &AcceptDirectConnectGatewayAssociationProposalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptDirectConnectGatewayAssociationProposal API operation for AWS Direct Connect.
//
// Accepts a proposal request to attach a virtual private gateway or transit
// gateway to a Direct Connect gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AcceptDirectConnectGatewayAssociationProposal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AcceptDirectConnectGatewayAssociationProposal
func (c *DirectConnect) AcceptDirectConnectGatewayAssociationProposal(input *AcceptDirectConnectGatewayAssociationProposalInput) (*AcceptDirectConnectGatewayAssociationProposalOutput, error) {
	req, out := c.AcceptDirectConnectGatewayAssociationProposalRequest(input)
	return out, req.Send()
}

// AcceptDirectConnectGatewayAssociationProposalWithContext is the same as AcceptDirectConnectGatewayAssociationProposal with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptDirectConnectGatewayAssociationProposal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AcceptDirectConnectGatewayAssociationProposalWithContext(ctx aws.Context, input *AcceptDirectConnectGatewayAssociationProposalInput, opts ...request.Option) (*AcceptDirectConnectGatewayAssociationProposalOutput, error) {
	req, out := c.AcceptDirectConnectGatewayAssociationProposalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateConnectionOnInterconnect = "AllocateConnectionOnInterconnect"

// AllocateConnectionOnInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the AllocateConnectionOnInterconnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateConnectionOnInterconnect for more information on using the AllocateConnectionOnInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateConnectionOnInterconnectRequest method.
//    req, resp := client.AllocateConnectionOnInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnect
//
// Deprecated: AllocateConnectionOnInterconnect has been deprecated
func (c *DirectConnect) AllocateConnectionOnInterconnectRequest(input *AllocateConnectionOnInterconnectInput) (req *request.Request, output *Connection) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AllocateConnectionOnInterconnect, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAllocateConnectionOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateConnectionOnInterconnectInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateConnectionOnInterconnect API operation for AWS Direct Connect.
//
// Deprecated. Use AllocateHostedConnection instead.
//
// Creates a hosted connection on an interconnect.
//
// Allocates a VLAN number and a specified amount of bandwidth for use by a
// hosted connection on the specified interconnect.
//
// Intended for use by AWS Direct Connect Partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocateConnectionOnInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnect
//
// Deprecated: AllocateConnectionOnInterconnect has been deprecated
func (c *DirectConnect) AllocateConnectionOnInterconnect(input *AllocateConnectionOnInterconnectInput) (*Connection, error) {
	req, out := c.AllocateConnectionOnInterconnectRequest(input)
	return out, req.Send()
}

// AllocateConnectionOnInterconnectWithContext is the same as AllocateConnectionOnInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateConnectionOnInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: AllocateConnectionOnInterconnectWithContext has been deprecated
func (c *DirectConnect) AllocateConnectionOnInterconnectWithContext(ctx aws.Context, input *AllocateConnectionOnInterconnectInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AllocateConnectionOnInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateHostedConnection = "AllocateHostedConnection"

// AllocateHostedConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AllocateHostedConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateHostedConnection for more information on using the AllocateHostedConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateHostedConnectionRequest method.
//    req, resp := client.AllocateHostedConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection
func (c *DirectConnect) AllocateHostedConnectionRequest(input *AllocateHostedConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAllocateHostedConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateHostedConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateHostedConnection API operation for AWS Direct Connect.
//
// Creates a hosted connection on the specified interconnect or a link aggregation
// group (LAG) of interconnects.
//
// Allocates a VLAN number and a specified amount of capacity (bandwidth) for
// use by a hosted connection on the specified interconnect or LAG of interconnects.
// AWS polices the hosted connection for the specified capacity and the AWS
// Direct Connect Partner must also police the hosted connection for the specified
// capacity.
//
// Intended for use by AWS Direct Connect Partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocateHostedConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection
func (c *DirectConnect) AllocateHostedConnection(input *AllocateHostedConnectionInput) (*Connection, error) {
	req, out := c.AllocateHostedConnectionRequest(input)
	return out, req.Send()
}

// AllocateHostedConnectionWithContext is the same as AllocateHostedConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateHostedConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocateHostedConnectionWithContext(ctx aws.Context, input *AllocateHostedConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AllocateHostedConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocatePrivateVirtualInterface = "AllocatePrivateVirtualInterface"

// AllocatePrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AllocatePrivateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocatePrivateVirtualInterface for more information on using the AllocatePrivateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocatePrivateVirtualInterfaceRequest method.
//    req, resp := client.AllocatePrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface
func (c *DirectConnect) AllocatePrivateVirtualInterfaceRequest(input *AllocatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePrivateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AllocatePrivateVirtualInterface API operation for AWS Direct Connect.
//
// Provisions a private virtual interface to be owned by the specified AWS account.
//
// Virtual interfaces created using this action must be confirmed by the owner
// using ConfirmPrivateVirtualInterface. Until then, the virtual interface is
// in the Confirming state and is not available to handle traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocatePrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface
func (c *DirectConnect) AllocatePrivateVirtualInterface(input *AllocatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePrivateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// AllocatePrivateVirtualInterfaceWithContext is the same as AllocatePrivateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AllocatePrivateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocatePrivateVirtualInterfaceWithContext(ctx aws.Context, input *AllocatePrivateVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.AllocatePrivateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocatePublicVirtualInterface = "AllocatePublicVirtualInterface"

// AllocatePublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AllocatePublicVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocatePublicVirtualInterface for more information on using the AllocatePublicVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocatePublicVirtualInterfaceRequest method.
//    req, resp := client.AllocatePublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface
func (c *DirectConnect) AllocatePublicVirtualInterfaceRequest(input *AllocatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePublicVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AllocatePublicVirtualInterface API operation for AWS Direct Connect.
//
// Provisions a public virtual interface to be owned by the specified AWS account.
//
// The owner of a connection calls this function to provision a public virtual
// interface to be owned by the specified AWS account.
//
// Virtual interfaces created using this function must be confirmed by the owner
// using ConfirmPublicVirtualInterface. Until this step has been completed,
// the virtual interface is in the confirming state and is not available to
// handle traffic.
//
// When creating an IPv6 public virtual interface, omit the Amazon address and
// customer address. IPv6 addresses are automatically assigned from the Amazon
// pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocatePublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface
func (c *DirectConnect) AllocatePublicVirtualInterface(input *AllocatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePublicVirtualInterfaceRequest(input)
	return out, req.Send()
}

// AllocatePublicVirtualInterfaceWithContext is the same as AllocatePublicVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AllocatePublicVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocatePublicVirtualInterfaceWithContext(ctx aws.Context, input *AllocatePublicVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.AllocatePublicVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateTransitVirtualInterface = "AllocateTransitVirtualInterface"

// AllocateTransitVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AllocateTransitVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateTransitVirtualInterface for more information on using the AllocateTransitVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateTransitVirtualInterfaceRequest method.
//    req, resp := client.AllocateTransitVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateTransitVirtualInterface
func (c *DirectConnect) AllocateTransitVirtualInterfaceRequest(input *AllocateTransitVirtualInterfaceInput) (req *request.Request, output *AllocateTransitVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opAllocateTransitVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateTransitVirtualInterfaceInput{}
	}

	output = &AllocateTransitVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateTransitVirtualInterface API operation for AWS Direct Connect.
//
// Provisions a transit virtual interface to be owned by the specified AWS account.
// Use this type of interface to connect a transit gateway to your Direct Connect
// gateway.
//
// The owner of a connection provisions a transit virtual interface to be owned
// by the specified AWS account.
//
// After you create a transit virtual interface, it must be confirmed by the
// owner using ConfirmTransitVirtualInterface. Until this step has been completed,
// the transit virtual interface is in the requested state and is not available
// to handle traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocateTransitVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateTransitVirtualInterface
func (c *DirectConnect) AllocateTransitVirtualInterface(input *AllocateTransitVirtualInterfaceInput) (*AllocateTransitVirtualInterfaceOutput, error) {
	req, out := c.AllocateTransitVirtualInterfaceRequest(input)
	return out, req.Send()
}

// AllocateTransitVirtualInterfaceWithContext is the same as AllocateTransitVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateTransitVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AllocateTransitVirtualInterfaceWithContext(ctx aws.Context, input *AllocateTransitVirtualInterfaceInput, opts ...request.Option) (*AllocateTransitVirtualInterfaceOutput, error) {
	req, out := c.AllocateTransitVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateConnectionWithLag = "AssociateConnectionWithLag"

// AssociateConnectionWithLagRequest generates a "aws/request.Request" representing the
// client's request for the AssociateConnectionWithLag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateConnectionWithLag for more information on using the AssociateConnectionWithLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateConnectionWithLagRequest method.
//    req, resp := client.AssociateConnectionWithLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag
func (c *DirectConnect) AssociateConnectionWithLagRequest(input *AssociateConnectionWithLagInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAssociateConnectionWithLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateConnectionWithLagInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateConnectionWithLag API operation for AWS Direct Connect.
//
// Associates an existing connection with a link aggregation group (LAG). The
// connection is interrupted and re-established as a member of the LAG (connectivity
// to AWS is interrupted). The connection must be hosted on the same AWS Direct
// Connect endpoint as the LAG, and its bandwidth must match the bandwidth for
// the LAG. You can re-associate a connection that's currently associated with
// a different LAG; however, if removing the connection would cause the original
// LAG to fall below its setting for minimum number of operational connections,
// the request fails.
//
// Any virtual interfaces that are directly associated with the connection are
// automatically re-associated with the LAG. If the connection was originally
// associated with a different LAG, the virtual interfaces remain associated
// with the original LAG.
//
// For interconnects, any hosted connections are automatically re-associated
// with the LAG. If the interconnect was originally associated with a different
// LAG, the hosted connections remain associated with the original LAG.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AssociateConnectionWithLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag
func (c *DirectConnect) AssociateConnectionWithLag(input *AssociateConnectionWithLagInput) (*Connection, error) {
	req, out := c.AssociateConnectionWithLagRequest(input)
	return out, req.Send()
}

// AssociateConnectionWithLagWithContext is the same as AssociateConnectionWithLag with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateConnectionWithLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AssociateConnectionWithLagWithContext(ctx aws.Context, input *AssociateConnectionWithLagInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AssociateConnectionWithLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateHostedConnection = "AssociateHostedConnection"

// AssociateHostedConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AssociateHostedConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateHostedConnection for more information on using the AssociateHostedConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateHostedConnectionRequest method.
//    req, resp := client.AssociateHostedConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection
func (c *DirectConnect) AssociateHostedConnectionRequest(input *AssociateHostedConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAssociateHostedConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateHostedConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateHostedConnection API operation for AWS Direct Connect.
//
// Associates a hosted connection and its virtual interfaces with a link aggregation
// group (LAG) or interconnect. If the target interconnect or LAG has an existing
// hosted connection with a conflicting VLAN number or IP address, the operation
// fails. This action temporarily interrupts the hosted connection's connectivity
// to AWS as it is being migrated.
//
// Intended for use by AWS Direct Connect Partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AssociateHostedConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection
func (c *DirectConnect) AssociateHostedConnection(input *AssociateHostedConnectionInput) (*Connection, error) {
	req, out := c.AssociateHostedConnectionRequest(input)
	return out, req.Send()
}

// AssociateHostedConnectionWithContext is the same as AssociateHostedConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateHostedConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AssociateHostedConnectionWithContext(ctx aws.Context, input *AssociateHostedConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.AssociateHostedConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateVirtualInterface = "AssociateVirtualInterface"

// AssociateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateVirtualInterface for more information on using the AssociateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateVirtualInterfaceRequest method.
//    req, resp := client.AssociateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface
func (c *DirectConnect) AssociateVirtualInterfaceRequest(input *AssociateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAssociateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateVirtualInterface API operation for AWS Direct Connect.
//
// Associates a virtual interface with a specified link aggregation group (LAG)
// or connection. Connectivity to AWS is temporarily interrupted as the virtual
// interface is being migrated. If the target connection or LAG has an associated
// virtual interface with a conflicting VLAN number or a conflicting IP address,
// the operation fails.
//
// Virtual interfaces associated with a hosted connection cannot be associated
// with a LAG; hosted connections must be migrated along with their virtual
// interfaces using AssociateHostedConnection.
//
// To reassociate a virtual interface to a new connection or LAG, the requester
// must own either the virtual interface itself or the connection to which the
// virtual interface is currently associated. Additionally, the requester must
// own the connection or LAG for the association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AssociateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface
func (c *DirectConnect) AssociateVirtualInterface(input *AssociateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AssociateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// AssociateVirtualInterfaceWithContext is the same as AssociateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) AssociateVirtualInterfaceWithContext(ctx aws.Context, input *AssociateVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.AssociateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmConnection = "ConfirmConnection"

// ConfirmConnectionRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmConnection for more information on using the ConfirmConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmConnectionRequest method.
//    req, resp := client.ConfirmConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection
func (c *DirectConnect) ConfirmConnectionRequest(input *ConfirmConnectionInput) (req *request.Request, output *ConfirmConnectionOutput) {
	op := &request.Operation{
		Name:       opConfirmConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmConnectionInput{}
	}

	output = &ConfirmConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmConnection API operation for AWS Direct Connect.
//
// Confirms the creation of the specified hosted connection on an interconnect.
//
// Upon creation, the hosted connection is initially in the Ordering state,
// and remains in this state until the owner confirms creation of the hosted
// connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection
func (c *DirectConnect) ConfirmConnection(input *ConfirmConnectionInput) (*ConfirmConnectionOutput, error) {
	req, out := c.ConfirmConnectionRequest(input)
	return out, req.Send()
}

// ConfirmConnectionWithContext is the same as ConfirmConnection with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) ConfirmConnectionWithContext(ctx aws.Context, input *ConfirmConnectionInput, opts ...request.Option) (*ConfirmConnectionOutput, error) {
	req, out := c.ConfirmConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmPrivateVirtualInterface = "ConfirmPrivateVirtualInterface"

// ConfirmPrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmPrivateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmPrivateVirtualInterface for more information on using the ConfirmPrivateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmPrivateVirtualInterfaceRequest method.
//    req, resp := client.ConfirmPrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface
func (c *DirectConnect) ConfirmPrivateVirtualInterfaceRequest(input *ConfirmPrivateVirtualInterfaceInput) (req *request.Request, output *ConfirmPrivateVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPrivateVirtualInterfaceInput{}
	}

	output = &ConfirmPrivateVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmPrivateVirtualInterface API operation for AWS Direct Connect.
//
// Accepts ownership of a private virtual interface created by another AWS account.
//
// After the virtual interface owner makes this call, the virtual interface
// is created and attached to the specified virtual private gateway or Direct
// Connect gateway, and is made available to handle traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmPrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface
func (c *DirectConnect) ConfirmPrivateVirtualInterface(input *ConfirmPrivateVirtualInterfaceInput) (*ConfirmPrivateVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPrivateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// ConfirmPrivateVirtualInterfaceWithContext is the same as ConfirmPrivateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmPrivateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) ConfirmPrivateVirtualInterfaceWithContext(ctx aws.Context, input *ConfirmPrivateVirtualInterfaceInput, opts ...request.Option) (*ConfirmPrivateVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPrivateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmPublicVirtualInterface = "ConfirmPublicVirtualInterface"

// ConfirmPublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmPublicVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmPublicVirtualInterface for more information on using the ConfirmPublicVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmPublicVirtualInterfaceRequest method.
//    req, resp := client.ConfirmPublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface
func (c *DirectConnect) ConfirmPublicVirtualInterfaceRequest(input *ConfirmPublicVirtualInterfaceInput) (req *request.Request, output *ConfirmPublicVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPublicVirtualInterfaceInput{}
	}

	output = &ConfirmPublicVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmPublicVirtualInterface API operation for AWS Direct Connect.
//
// Accepts ownership of a public virtual interface created by another AWS account.
//
// After the virtual interface owner makes this call, the specified virtual
// interface is created and made available to handle traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmPublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface
func (c *DirectConnect) ConfirmPublicVirtualInterface(input *ConfirmPublicVirtualInterfaceInput) (*ConfirmPublicVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPublicVirtualInterfaceRequest(input)
	return out, req.Send()
}

// ConfirmPublicVirtualInterfaceWithContext is the same as ConfirmPublicVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmPublicVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) ConfirmPublicVirtualInterfaceWithContext(ctx aws.Context, input *ConfirmPublicVirtualInterfaceInput, opts ...request.Option) (*ConfirmPublicVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPublicVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmTransitVirtualInterface = "ConfirmTransitVirtualInterface"

// ConfirmTransitVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmTransitVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmTransitVirtualInterface for more information on using the ConfirmTransitVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmTransitVirtualInterfaceRequest method.
//    req, resp := client.ConfirmTransitVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmTransitVirtualInterface
func (c *DirectConnect) ConfirmTransitVirtualInterfaceRequest(input *ConfirmTransitVirtualInterfaceInput) (req *request.Request, output *ConfirmTransitVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmTransitVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmTransitVirtualInterfaceInput{}
	}

	output = &ConfirmTransitVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmTransitVirtualInterface API operation for AWS Direct Connect.
//
// Accepts ownership of a transit virtual interface created by another AWS account.
//
// After the owner of the transit virtual interface makes this call, the specified
// transit virtual interface is created and made available to handle traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmTransitVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmTransitVirtualInterface
func (c *DirectConnect) ConfirmTransitVirtualInterface(input *ConfirmTransitVirtualInterfaceInput) (*ConfirmTransitVirtualInterfaceOutput, error) {
	req, out := c.ConfirmTransitVirtualInterfaceRequest(input)
	return out, req.Send()
}

// ConfirmTransitVirtualInterfaceWithContext is the same as ConfirmTransitVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmTransitVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) ConfirmTransitVirtualInterfaceWithContext(ctx aws.Context, input *ConfirmTransitVirtualInterfaceInput, opts ...request.Option) (*ConfirmTransitVirtualInterfaceOutput, error) {
	req, out := c.ConfirmTransitVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBGPPeer = "CreateBGPPeer"

// CreateBGPPeerRequest generates a "aws/request.Request" representing the
// client's request for the CreateBGPPeer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBGPPeer for more information on using the CreateBGPPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBGPPeerRequest method.
//    req, resp := client.CreateBGPPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer
func (c *DirectConnect) CreateBGPPeerRequest(input *CreateBGPPeerInput) (req *request.Request, output *CreateBGPPeerOutput) {
	op := &request.Operation{
		Name:       opCreateBGPPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBGPPeerInput{}
	}

	output = &CreateBGPPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBGPPeer API operation for AWS Direct Connect.
//
// Creates a BGP peer on the specified virtual interface.
//
// You must create a BGP peer for the corresponding address family (IPv4/IPv6)
// in order to access AWS resources that also use that address family.
//
// If logical redundancy is not supported by the connection, interconnect, or
// LAG, the BGP peer cannot be in the same address family as an existing BGP
// peer on the virtual interface.
//
// When creating a IPv6 BGP peer, omit the Amazon address and customer address.
// IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses;
// you cannot specify custom IPv6 addresses.
//
// For a public virtual interface, the Autonomous System Number (ASN) must be
// private or already whitelisted for the virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateBGPPeer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer
func (c *DirectConnect) CreateBGPPeer(input *CreateBGPPeerInput) (*CreateBGPPeerOutput, error) {
	req, out := c.CreateBGPPeerRequest(input)
	return out, req.Send()
}

// CreateBGPPeerWithContext is the same as CreateBGPPeer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBGPPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateBGPPeerWithContext(ctx aws.Context, input *CreateBGPPeerInput, opts ...request.Option) (*CreateBGPPeerOutput, error) {
	req, out := c.CreateBGPPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnection for more information on using the CreateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectionRequest method.
//    req, resp := client.CreateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection
func (c *DirectConnect) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnection API operation for AWS Direct Connect.
//
// Creates a connection between a customer network and a specific AWS Direct
// Connect location.
//
// A connection links your internal network to an AWS Direct Connect location
// over a standard Ethernet fiber-optic cable. One end of the cable is connected
// to your router, the other to an AWS Direct Connect router.
//
// To find the locations for your Region, use DescribeLocations.
//
// You can automatically add the new connection to a link aggregation group
// (LAG) by specifying a LAG ID in the request. This ensures that the new connection
// is allocated on the same AWS Direct Connect endpoint that hosts the specified
// LAG. If there are no available ports on the endpoint, the request fails and
// no connection is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection
func (c *DirectConnect) CreateConnection(input *CreateConnectionInput) (*Connection, error) {
	req, out := c.CreateConnectionRequest(input)
	return out, req.Send()
}

// CreateConnectionWithContext is the same as CreateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateConnectionWithContext(ctx aws.Context, input *CreateConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.CreateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectConnectGateway = "CreateDirectConnectGateway"

// CreateDirectConnectGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectConnectGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectConnectGateway for more information on using the CreateDirectConnectGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectConnectGatewayRequest method.
//    req, resp := client.CreateDirectConnectGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway
func (c *DirectConnect) CreateDirectConnectGatewayRequest(input *CreateDirectConnectGatewayInput) (req *request.Request, output *CreateDirectConnectGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateDirectConnectGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectConnectGatewayInput{}
	}

	output = &CreateDirectConnectGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectConnectGateway API operation for AWS Direct Connect.
//
// Creates a Direct Connect gateway, which is an intermediate object that enables
// you to connect a set of virtual interfaces and virtual private gateways.
// A Direct Connect gateway is global and visible in any AWS Region after it
// is created. The virtual interfaces and virtual private gateways that are
// connected through a Direct Connect gateway can be in different AWS Regions.
// This enables you to connect to a VPC in any Region, regardless of the Region
// in which the virtual interfaces are located, and pass traffic between them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateDirectConnectGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway
func (c *DirectConnect) CreateDirectConnectGateway(input *CreateDirectConnectGatewayInput) (*CreateDirectConnectGatewayOutput, error) {
	req, out := c.CreateDirectConnectGatewayRequest(input)
	return out, req.Send()
}

// CreateDirectConnectGatewayWithContext is the same as CreateDirectConnectGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectConnectGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateDirectConnectGatewayWithContext(ctx aws.Context, input *CreateDirectConnectGatewayInput, opts ...request.Option) (*CreateDirectConnectGatewayOutput, error) {
	req, out := c.CreateDirectConnectGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectConnectGatewayAssociation = "CreateDirectConnectGatewayAssociation"

// CreateDirectConnectGatewayAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectConnectGatewayAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectConnectGatewayAssociation for more information on using the CreateDirectConnectGatewayAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectConnectGatewayAssociationRequest method.
//    req, resp := client.CreateDirectConnectGatewayAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation
func (c *DirectConnect) CreateDirectConnectGatewayAssociationRequest(input *CreateDirectConnectGatewayAssociationInput) (req *request.Request, output *CreateDirectConnectGatewayAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateDirectConnectGatewayAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectConnectGatewayAssociationInput{}
	}

	output = &CreateDirectConnectGatewayAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectConnectGatewayAssociation API operation for AWS Direct Connect.
//
// Creates an association between a Direct Connect gateway and a virtual private
// gateway. The virtual private gateway must be attached to a VPC and must not
// be associated with another Direct Connect gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateDirectConnectGatewayAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation
func (c *DirectConnect) CreateDirectConnectGatewayAssociation(input *CreateDirectConnectGatewayAssociationInput) (*CreateDirectConnectGatewayAssociationOutput, error) {
	req, out := c.CreateDirectConnectGatewayAssociationRequest(input)
	return out, req.Send()
}

// CreateDirectConnectGatewayAssociationWithContext is the same as CreateDirectConnectGatewayAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectConnectGatewayAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateDirectConnectGatewayAssociationWithContext(ctx aws.Context, input *CreateDirectConnectGatewayAssociationInput, opts ...request.Option) (*CreateDirectConnectGatewayAssociationOutput, error) {
	req, out := c.CreateDirectConnectGatewayAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectConnectGatewayAssociationProposal = "CreateDirectConnectGatewayAssociationProposal"

// CreateDirectConnectGatewayAssociationProposalRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectConnectGatewayAssociationProposal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectConnectGatewayAssociationProposal for more information on using the CreateDirectConnectGatewayAssociationProposal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectConnectGatewayAssociationProposalRequest method.
//    req, resp := client.CreateDirectConnectGatewayAssociationProposalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationProposal
func (c *DirectConnect) CreateDirectConnectGatewayAssociationProposalRequest(input *CreateDirectConnectGatewayAssociationProposalInput) (req *request.Request, output *CreateDirectConnectGatewayAssociationProposalOutput) {
	op := &request.Operation{
		Name:       opCreateDirectConnectGatewayAssociationProposal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectConnectGatewayAssociationProposalInput{}
	}

	output = &CreateDirectConnectGatewayAssociationProposalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectConnectGatewayAssociationProposal API operation for AWS Direct Connect.
//
// Creates a proposal to associate the specified virtual private gateway or
// transit gateway with the specified Direct Connect gateway.
//
// You can only associate a Direct Connect gateway and virtual private gateway
// or transit gateway when the account that owns the Direct Connect gateway
// and the account that owns the virtual private gateway or transit gateway
// have the same AWS Payer ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateDirectConnectGatewayAssociationProposal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationProposal
func (c *DirectConnect) CreateDirectConnectGatewayAssociationProposal(input *CreateDirectConnectGatewayAssociationProposalInput) (*CreateDirectConnectGatewayAssociationProposalOutput, error) {
	req, out := c.CreateDirectConnectGatewayAssociationProposalRequest(input)
	return out, req.Send()
}

// CreateDirectConnectGatewayAssociationProposalWithContext is the same as CreateDirectConnectGatewayAssociationProposal with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectConnectGatewayAssociationProposal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateDirectConnectGatewayAssociationProposalWithContext(ctx aws.Context, input *CreateDirectConnectGatewayAssociationProposalInput, opts ...request.Option) (*CreateDirectConnectGatewayAssociationProposalOutput, error) {
	req, out := c.CreateDirectConnectGatewayAssociationProposalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInterconnect = "CreateInterconnect"

// CreateInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the CreateInterconnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInterconnect for more information on using the CreateInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInterconnectRequest method.
//    req, resp := client.CreateInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect
func (c *DirectConnect) CreateInterconnectRequest(input *CreateInterconnectInput) (req *request.Request, output *Interconnect) {
	op := &request.Operation{
		Name:       opCreateInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInterconnectInput{}
	}

	output = &Interconnect{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInterconnect API operation for AWS Direct Connect.
//
// Creates an interconnect between an AWS Direct Connect Partner's network and
// a specific AWS Direct Connect location.
//
// An interconnect is a connection that is capable of hosting other connections.
// The AWS Direct Connect partner can use an interconnect to provide AWS Direct
// Connect hosted connections to customers through their own network services.
// Like a standard connection, an interconnect links the partner's network to
// an AWS Direct Connect location over a standard Ethernet fiber-optic cable.
// One end is connected to the partner's router, the other to an AWS Direct
// Connect router.
//
// You can automatically add the new interconnect to a link aggregation group
// (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect
// is allocated on the same AWS Direct Connect endpoint that hosts the specified
// LAG. If there are no available ports on the endpoint, the request fails and
// no interconnect is created.
//
// For each end customer, the AWS Direct Connect Partner provisions a connection
// on their interconnect by calling AllocateHostedConnection. The end customer
// can then connect to AWS resources by creating a virtual interface on their
// connection, using the VLAN assigned to them by the AWS Direct Connect Partner.
//
// Intended for use by AWS Direct Connect Partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect
func (c *DirectConnect) CreateInterconnect(input *CreateInterconnectInput) (*Interconnect, error) {
	req, out := c.CreateInterconnectRequest(input)
	return out, req.Send()
}

// CreateInterconnectWithContext is the same as CreateInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateInterconnectWithContext(ctx aws.Context, input *CreateInterconnectInput, opts ...request.Option) (*Interconnect, error) {
	req, out := c.CreateInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLag = "CreateLag"

// CreateLagRequest generates a "aws/request.Request" representing the
// client's request for the CreateLag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLag for more information on using the CreateLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLagRequest method.
//    req, resp := client.CreateLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag
func (c *DirectConnect) CreateLagRequest(input *CreateLagInput) (req *request.Request, output *Lag) {
	op := &request.Operation{
		Name:       opCreateLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLagInput{}
	}

	output = &Lag{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLag API operation for AWS Direct Connect.
//
// Creates a link aggregation group (LAG) with the specified number of bundled
// physical connections between the customer network and a specific AWS Direct
// Connect location. A LAG is a logical interface that uses the Link Aggregation
// Control Protocol (LACP) to aggregate multiple interfaces, enabling you to
// treat them as a single interface.
//
// All connections in a LAG must use the same bandwidth and must terminate at
// the same AWS Direct Connect endpoint.
//
// You can have up to 10 connections per LAG. Regardless of this limit, if you
// request more connections for the LAG than AWS Direct Connect can allocate
// on a single endpoint, no LAG is created.
//
// You can specify an existing physical connection or interconnect to include
// in the LAG (which counts towards the total number of connections). Doing
// so interrupts the current physical connection or hosted connections, and
// re-establishes them as a member of the LAG. The LAG will be created on the
// same AWS Direct Connect endpoint to which the connection terminates. Any
// virtual interfaces associated with the connection are automatically disassociated
// and re-associated with the LAG. The connection ID does not change.
//
// If the AWS account used to create a LAG is a registered AWS Direct Connect
// Partner, the LAG is automatically enabled to host sub-connections. For a
// LAG owned by a partner, any associated virtual interfaces cannot be directly
// configured.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag
func (c *DirectConnect) CreateLag(input *CreateLagInput) (*Lag, error) {
	req, out := c.CreateLagRequest(input)
	return out, req.Send()
}

// CreateLagWithContext is the same as CreateLag with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateLagWithContext(ctx aws.Context, input *CreateLagInput, opts ...request.Option) (*Lag, error) {
	req, out := c.CreateLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePrivateVirtualInterface = "CreatePrivateVirtualInterface"

// CreatePrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrivateVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePrivateVirtualInterface for more information on using the CreatePrivateVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePrivateVirtualInterfaceRequest method.
//    req, resp := client.CreatePrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface
func (c *DirectConnect) CreatePrivateVirtualInterfaceRequest(input *CreatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrivateVirtualInterface API operation for AWS Direct Connect.
//
// Creates a private virtual interface. A virtual interface is the VLAN that
// transports AWS Direct Connect traffic. A private virtual interface can be
// connected to either a Direct Connect gateway or a Virtual Private Gateway
// (VGW). Connecting the private virtual interface to a Direct Connect gateway
// enables the possibility for connecting to multiple VPCs, including VPCs in
// different AWS Regions. Connecting the private virtual interface to a VGW
// only provides access to a single VPC within the same Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreatePrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface
func (c *DirectConnect) CreatePrivateVirtualInterface(input *CreatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePrivateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// CreatePrivateVirtualInterfaceWithContext is the same as CreatePrivateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrivateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreatePrivateVirtualInterfaceWithContext(ctx aws.Context, input *CreatePrivateVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.CreatePrivateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublicVirtualInterface = "CreatePublicVirtualInterface"

// CreatePublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublicVirtualInterface for more information on using the CreatePublicVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePublicVirtualInterfaceRequest method.
//    req, resp := client.CreatePublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface
func (c *DirectConnect) CreatePublicVirtualInterfaceRequest(input *CreatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicVirtualInterface API operation for AWS Direct Connect.
//
// Creates a public virtual interface. A virtual interface is the VLAN that
// transports AWS Direct Connect traffic. A public virtual interface supports
// sending traffic to public services of AWS such as Amazon S3.
//
// When creating an IPv6 public virtual interface (addressFamily is ipv6), leave
// the customer and amazon address fields blank to use auto-assigned IPv6 space.
// Custom IPv6 addresses are not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreatePublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface
func (c *DirectConnect) CreatePublicVirtualInterface(input *CreatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePublicVirtualInterfaceRequest(input)
	return out, req.Send()
}

// CreatePublicVirtualInterfaceWithContext is the same as CreatePublicVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublicVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreatePublicVirtualInterfaceWithContext(ctx aws.Context, input *CreatePublicVirtualInterfaceInput, opts ...request.Option) (*VirtualInterface, error) {
	req, out := c.CreatePublicVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitVirtualInterface = "CreateTransitVirtualInterface"

// CreateTransitVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitVirtualInterface for more information on using the CreateTransitVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransitVirtualInterfaceRequest method.
//    req, resp := client.CreateTransitVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterface
func (c *DirectConnect) CreateTransitVirtualInterfaceRequest(input *CreateTransitVirtualInterfaceInput) (req *request.Request, output *CreateTransitVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opCreateTransitVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitVirtualInterfaceInput{}
	}

	output = &CreateTransitVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitVirtualInterface API operation for AWS Direct Connect.
//
// Creates a transit virtual interface. A transit virtual interface should be
// used to access one or more transit gateways associated with Direct Connect
// gateways. A transit virtual interface enables the connection of multiple
// VPCs attached to a transit gateway to a Direct Connect gateway.
//
// If you associate your transit gateway with one or more Direct Connect gateways,
// the Autonomous System Number (ASN) used by the transit gateway and the Direct
// Connect gateway must be different. For example, if you use the default ASN
// 64512 for both your the transit gateway and Direct Connect gateway, the association
// request fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateTransitVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterface
func (c *DirectConnect) CreateTransitVirtualInterface(input *CreateTransitVirtualInterfaceInput) (*CreateTransitVirtualInterfaceOutput, error) {
	req, out := c.CreateTransitVirtualInterfaceRequest(input)
	return out, req.Send()
}

// CreateTransitVirtualInterfaceWithContext is the same as CreateTransitVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) CreateTransitVirtualInterfaceWithContext(ctx aws.Context, input *CreateTransitVirtualInterfaceInput, opts ...request.Option) (*CreateTransitVirtualInterfaceOutput, error) {
	req, out := c.CreateTransitVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBGPPeer = "DeleteBGPPeer"

// DeleteBGPPeerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBGPPeer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBGPPeer for more information on using the DeleteBGPPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBGPPeerRequest method.
//    req, resp := client.DeleteBGPPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer
func (c *DirectConnect) DeleteBGPPeerRequest(input *DeleteBGPPeerInput) (req *request.Request, output *DeleteBGPPeerOutput) {
	op := &request.Operation{
		Name:       opDeleteBGPPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBGPPeerInput{}
	}

	output = &DeleteBGPPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBGPPeer API operation for AWS Direct Connect.
//
// Deletes the specified BGP peer on the specified virtual interface with the
// specified customer address and ASN.
//
// You cannot delete the last BGP peer from a virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteBGPPeer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer
func (c *DirectConnect) DeleteBGPPeer(input *DeleteBGPPeerInput) (*DeleteBGPPeerOutput, error) {
	req, out := c.DeleteBGPPeerRequest(input)
	return out, req.Send()
}

// DeleteBGPPeerWithContext is the same as DeleteBGPPeer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBGPPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteBGPPeerWithContext(ctx aws.Context, input *DeleteBGPPeerInput, opts ...request.Option) (*DeleteBGPPeerOutput, error) {
	req, out := c.DeleteBGPPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectionRequest method.
//    req, resp := client.DeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection
func (c *DirectConnect) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for AWS Direct Connect.
//
// Deletes the specified connection.
//
// Deleting a connection only stops the AWS Direct Connect port hour and data
// transfer charges. If you are partnering with any third parties to connect
// with the AWS Direct Connect location, you must cancel your service with them
// separately.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection
func (c *DirectConnect) DeleteConnection(input *DeleteConnectionInput) (*Connection, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*Connection, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectConnectGateway = "DeleteDirectConnectGateway"

// DeleteDirectConnectGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectConnectGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectConnectGateway for more information on using the DeleteDirectConnectGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectConnectGatewayRequest method.
//    req, resp := client.DeleteDirectConnectGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway
func (c *DirectConnect) DeleteDirectConnectGatewayRequest(input *DeleteDirectConnectGatewayInput) (req *request.Request, output *DeleteDirectConnectGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectConnectGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectConnectGatewayInput{}
	}

	output = &DeleteDirectConnectGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectConnectGateway API operation for AWS Direct Connect.
//
// Deletes the specified Direct Connect gateway. You must first delete all virtual
// interfaces that are attached to the Direct Connect gateway and disassociate
// all virtual private gateways associated with the Direct Connect gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteDirectConnectGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway
func (c *DirectConnect) DeleteDirectConnectGateway(input *DeleteDirectConnectGatewayInput) (*DeleteDirectConnectGatewayOutput, error) {
	req, out := c.DeleteDirectConnectGatewayRequest(input)
	return out, req.Send()
}

// DeleteDirectConnectGatewayWithContext is the same as DeleteDirectConnectGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectConnectGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteDirectConnectGatewayWithContext(ctx aws.Context, input *DeleteDirectConnectGatewayInput, opts ...request.Option) (*DeleteDirectConnectGatewayOutput, error) {
	req, out := c.DeleteDirectConnectGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectConnectGatewayAssociation = "DeleteDirectConnectGatewayAssociation"

// DeleteDirectConnectGatewayAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectConnectGatewayAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectConnectGatewayAssociation for more information on using the DeleteDirectConnectGatewayAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectConnectGatewayAssociationRequest method.
//    req, resp := client.DeleteDirectConnectGatewayAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation
func (c *DirectConnect) DeleteDirectConnectGatewayAssociationRequest(input *DeleteDirectConnectGatewayAssociationInput) (req *request.Request, output *DeleteDirectConnectGatewayAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectConnectGatewayAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectConnectGatewayAssociationInput{}
	}

	output = &DeleteDirectConnectGatewayAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectConnectGatewayAssociation API operation for AWS Direct Connect.
//
// Deletes the association between the specified Direct Connect gateway and
// virtual private gateway.
//
// We recommend that you specify the associationID to delete the association.
// Alternatively, if you own virtual gateway and a Direct Connect gateway association,
// you can specify the virtualGatewayId and directConnectGatewayId to delete
// an association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteDirectConnectGatewayAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation
func (c *DirectConnect) DeleteDirectConnectGatewayAssociation(input *DeleteDirectConnectGatewayAssociationInput) (*DeleteDirectConnectGatewayAssociationOutput, error) {
	req, out := c.DeleteDirectConnectGatewayAssociationRequest(input)
	return out, req.Send()
}

// DeleteDirectConnectGatewayAssociationWithContext is the same as DeleteDirectConnectGatewayAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectConnectGatewayAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteDirectConnectGatewayAssociationWithContext(ctx aws.Context, input *DeleteDirectConnectGatewayAssociationInput, opts ...request.Option) (*DeleteDirectConnectGatewayAssociationOutput, error) {
	req, out := c.DeleteDirectConnectGatewayAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectConnectGatewayAssociationProposal = "DeleteDirectConnectGatewayAssociationProposal"

// DeleteDirectConnectGatewayAssociationProposalRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectConnectGatewayAssociationProposal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectConnectGatewayAssociationProposal for more information on using the DeleteDirectConnectGatewayAssociationProposal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectConnectGatewayAssociationProposalRequest method.
//    req, resp := client.DeleteDirectConnectGatewayAssociationProposalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationProposal
func (c *DirectConnect) DeleteDirectConnectGatewayAssociationProposalRequest(input *DeleteDirectConnectGatewayAssociationProposalInput) (req *request.Request, output *DeleteDirectConnectGatewayAssociationProposalOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectConnectGatewayAssociationProposal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectConnectGatewayAssociationProposalInput{}
	}

	output = &DeleteDirectConnectGatewayAssociationProposalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectConnectGatewayAssociationProposal API operation for AWS Direct Connect.
//
// Deletes the association proposal request between the specified Direct Connect
// gateway and virtual private gateway or transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteDirectConnectGatewayAssociationProposal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationProposal
func (c *DirectConnect) DeleteDirectConnectGatewayAssociationProposal(input *DeleteDirectConnectGatewayAssociationProposalInput) (*DeleteDirectConnectGatewayAssociationProposalOutput, error) {
	req, out := c.DeleteDirectConnectGatewayAssociationProposalRequest(input)
	return out, req.Send()
}

// DeleteDirectConnectGatewayAssociationProposalWithContext is the same as DeleteDirectConnectGatewayAssociationProposal with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectConnectGatewayAssociationProposal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteDirectConnectGatewayAssociationProposalWithContext(ctx aws.Context, input *DeleteDirectConnectGatewayAssociationProposalInput, opts ...request.Option) (*DeleteDirectConnectGatewayAssociationProposalOutput, error) {
	req, out := c.DeleteDirectConnectGatewayAssociationProposalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInterconnect = "DeleteInterconnect"

// DeleteInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInterconnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInterconnect for more information on using the DeleteInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInterconnectRequest method.
//    req, resp := client.DeleteInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect
func (c *DirectConnect) DeleteInterconnectRequest(input *DeleteInterconnectInput) (req *request.Request, output *DeleteInterconnectOutput) {
	op := &request.Operation{
		Name:       opDeleteInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInterconnectInput{}
	}

	output = &DeleteInterconnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInterconnect API operation for AWS Direct Connect.
//
// Deletes the specified interconnect.
//
// Intended for use by AWS Direct Connect Partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect
func (c *DirectConnect) DeleteInterconnect(input *DeleteInterconnectInput) (*DeleteInterconnectOutput, error) {
	req, out := c.DeleteInterconnectRequest(input)
	return out, req.Send()
}

// DeleteInterconnectWithContext is the same as DeleteInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteInterconnectWithContext(ctx aws.Context, input *DeleteInterconnectInput, opts ...request.Option) (*DeleteInterconnectOutput, error) {
	req, out := c.DeleteInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLag = "DeleteLag"

// DeleteLagRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLag for more information on using the DeleteLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLagRequest method.
//    req, resp := client.DeleteLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag
func (c *DirectConnect) DeleteLagRequest(input *DeleteLagInput) (req *request.Request, output *Lag) {
	op := &request.Operation{
		Name:       opDeleteLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLagInput{}
	}

	output = &Lag{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLag API operation for AWS Direct Connect.
//
// Deletes the specified link aggregation group (LAG). You cannot delete a LAG
// if it has active virtual interfaces or hosted connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag
func (c *DirectConnect) DeleteLag(input *DeleteLagInput) (*Lag, error) {
	req, out := c.DeleteLagRequest(input)
	return out, req.Send()
}

// DeleteLagWithContext is the same as DeleteLag with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteLagWithContext(ctx aws.Context, input *DeleteLagInput, opts ...request.Option) (*Lag, error) {
	req, out := c.DeleteLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualInterface = "DeleteVirtualInterface"

// DeleteVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualInterface for more information on using the DeleteVirtualInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVirtualInterfaceRequest method.
//    req, resp := client.DeleteVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface
func (c *DirectConnect) DeleteVirtualInterfaceRequest(input *DeleteVirtualInterfaceInput) (req *request.Request, output *DeleteVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVirtualInterfaceInput{}
	}

	output = &DeleteVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualInterface API operation for AWS Direct Connect.
//
// Deletes a virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface
func (c *DirectConnect) DeleteVirtualInterface(input *DeleteVirtualInterfaceInput) (*DeleteVirtualInterfaceOutput, error) {
	req, out := c.DeleteVirtualInterfaceRequest(input)
	return out, req.Send()
}

// DeleteVirtualInterfaceWithContext is the same as DeleteVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DeleteVirtualInterfaceWithContext(ctx aws.Context, input *DeleteVirtualInterfaceInput, opts ...request.Option) (*DeleteVirtualInterfaceOutput, error) {
	req, out := c.DeleteVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionLoa = "DescribeConnectionLoa"

// DescribeConnectionLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionLoa operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionLoa for more information on using the DescribeConnectionLoa
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionLoaRequest method.
//    req, resp := client.DescribeConnectionLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoa
//
// Deprecated: DescribeConnectionLoa has been deprecated
func (c *DirectConnect) DescribeConnectionLoaRequest(input *DescribeConnectionLoaInput) (req *request.Request, output *DescribeConnectionLoaOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeConnectionLoa, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeConnectionLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionLoaInput{}
	}

	output = &DescribeConnectionLoaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionLoa API operation for AWS Direct Connect.
//
// Deprecated. Use DescribeLoa instead.
//
// Gets the LOA-CFA for a connection.
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that your APN partner or service provider uses when establishing
// your cross connect to AWS at the colocation facility. For more information,
// see Requesting Cross Connects at AWS Direct Connect Locations (https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnectionLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoa
//
// Deprecated: DescribeConnectionLoa has been deprecated
func (c *DirectConnect) DescribeConnectionLoa(input *DescribeConnectionLoaInput) (*DescribeConnectionLoaOutput, error) {
	req, out := c.DescribeConnectionLoaRequest(input)
	return out, req.Send()
}

// DescribeConnectionLoaWithContext is the same as DescribeConnectionLoa with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionLoa for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: DescribeConnectionLoaWithContext has been deprecated
func (c *DirectConnect) DescribeConnectionLoaWithContext(ctx aws.Context, input *DescribeConnectionLoaInput, opts ...request.Option) (*DescribeConnectionLoaOutput, error) {
	req, out := c.DescribeConnectionLoaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnections for more information on using the DescribeConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionsRequest method.
//    req, resp := client.DescribeConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections
func (c *DirectConnect) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnections API operation for AWS Direct Connect.
//
// Displays the specified connection or all connections in this Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections
func (c *DirectConnect) DescribeConnections(input *DescribeConnectionsInput) (*Connections, error) {
	req, out := c.DescribeConnectionsRequest(input)
	return out, req.Send()
}

// DescribeConnectionsWithContext is the same as DescribeConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeConnectionsWithContext(ctx aws.Context, input *DescribeConnectionsInput, opts ...request.Option) (*Connections, error) {
	req, out := c.DescribeConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionsOnInterconnect = "DescribeConnectionsOnInterconnect"

// DescribeConnectionsOnInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionsOnInterconnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionsOnInterconnect for more information on using the DescribeConnectionsOnInterconnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionsOnInterconnectRequest method.
//    req, resp := client.DescribeConnectionsOnInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnect
//
// Deprecated: DescribeConnectionsOnInterconnect has been deprecated
func (c *DirectConnect) DescribeConnectionsOnInterconnectRequest(input *DescribeConnectionsOnInterconnectInput) (req *request.Request, output *Connections) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeConnectionsOnInterconnect, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeConnectionsOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsOnInterconnectInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionsOnInterconnect API operation for AWS Direct Connect.
//
// Deprecated. Use DescribeHostedConnections instead.
//
// Lists the connections that have been provisioned on the specified interconnect.
//
// Intended for use by AWS Direct Connect Partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnectionsOnInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnect
//
// Deprecated: DescribeConnectionsOnInterconnect has been deprecated
func (c *DirectConnect) DescribeConnectionsOnInterconnect(input *DescribeConnectionsOnInterconnectInput) (*Connections, error) {
	req, out := c.DescribeConnectionsOnInterconnectRequest(input)
	return out, req.Send()
}

// DescribeConnectionsOnInterconnectWithContext is the same as DescribeConnectionsOnInterconnect with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionsOnInterconnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: DescribeConnectionsOnInterconnectWithContext has been deprecated
func (c *DirectConnect) DescribeConnectionsOnInterconnectWithContext(ctx aws.Context, input *DescribeConnectionsOnInterconnectInput, opts ...request.Option) (*Connections, error) {
	req, out := c.DescribeConnectionsOnInterconnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectConnectGatewayAssociationProposals = "DescribeDirectConnectGatewayAssociationProposals"

// DescribeDirectConnectGatewayAssociationProposalsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectConnectGatewayAssociationProposals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectConnectGatewayAssociationProposals for more information on using the DescribeDirectConnectGatewayAssociationProposals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectConnectGatewayAssociationProposalsRequest method.
//    req, resp := client.DescribeDirectConnectGatewayAssociationProposalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationProposals
func (c *DirectConnect) DescribeDirectConnectGatewayAssociationProposalsRequest(input *DescribeDirectConnectGatewayAssociationProposalsInput) (req *request.Request, output *DescribeDirectConnectGatewayAssociationProposalsOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectConnectGatewayAssociationProposals,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewayAssociationProposalsInput{}
	}

	output = &DescribeDirectConnectGatewayAssociationProposalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectConnectGatewayAssociationProposals API operation for AWS Direct Connect.
//
// Describes one or more association proposals for connection between a virtual
// private gateway or transit gateway and a Direct Connect gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeDirectConnectGatewayAssociationProposals for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationProposals
func (c *DirectConnect) DescribeDirectConnectGatewayAssociationProposals(input *DescribeDirectConnectGatewayAssociationProposalsInput) (*DescribeDirectConnectGatewayAssociationProposalsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAssociationProposalsRequest(input)
	return out, req.Send()
}

// DescribeDirectConnectGatewayAssociationProposalsWithContext is the same as DescribeDirectConnectGatewayAssociationProposals with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectConnectGatewayAssociationProposals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeDirectConnectGatewayAssociationProposalsWithContext(ctx aws.Context, input *DescribeDirectConnectGatewayAssociationProposalsInput, opts ...request.Option) (*DescribeDirectConnectGatewayAssociationProposalsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAssociationProposalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectConnectGatewayAssociations = "DescribeDirectConnectGatewayAssociations"

// DescribeDirectConnectGatewayAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectConnectGatewayAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectConnectGatewayAssociations for more information on using the DescribeDirectConnectGatewayAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectConnectGatewayAssociationsRequest method.
//    req, resp := client.DescribeDirectConnectGatewayAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations
func (c *DirectConnect) DescribeDirectConnectGatewayAssociationsRequest(input *DescribeDirectConnectGatewayAssociationsInput) (req *request.Request, output *DescribeDirectConnectGatewayAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectConnectGatewayAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewayAssociationsInput{}
	}

	output = &DescribeDirectConnectGatewayAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectConnectGatewayAssociations API operation for AWS Direct Connect.
//
// Lists the associations between your Direct Connect gateways and virtual private
// gateways. You must specify a Direct Connect gateway, a virtual private gateway,
// or both. If you specify a Direct Connect gateway, the response contains all
// virtual private gateways associated with the Direct Connect gateway. If you
// specify a virtual private gateway, the response contains all Direct Connect
// gateways associated with the virtual private gateway. If you specify both,
// the response contains the association between the Direct Connect gateway
// and the virtual private gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeDirectConnectGatewayAssociations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations
func (c *DirectConnect) DescribeDirectConnectGatewayAssociations(input *DescribeDirectConnectGatewayAssociationsInput) (*DescribeDirectConnectGatewayAssociationsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAssociationsRequest(input)
	return out, req.Send()
}

// DescribeDirectConnectGatewayAssociationsWithContext is the same as DescribeDirectConnectGatewayAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectConnectGatewayAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeDirectConnectGatewayAssociationsWithContext(ctx aws.Context, input *DescribeDirectConnectGatewayAssociationsInput, opts ...request.Option) (*DescribeDirectConnectGatewayAssociationsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectConnectGatewayAttachments = "DescribeDirectConnectGatewayAttachments"

// DescribeDirectConnectGatewayAttachmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectConnectGatewayAttachments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectConnectGatewayAttachments for more information on using the DescribeDirectConnectGatewayAttachments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectConnectGatewayAttachmentsRequest method.
//    req, resp := client.DescribeDirectConnectGatewayAttachmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments
func (c *DirectConnect) DescribeDirectConnectGatewayAttachmentsRequest(input *DescribeDirectConnectGatewayAttachmentsInput) (req *request.Request, output *DescribeDirectConnectGatewayAttachmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectConnectGatewayAttachments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewayAttachmentsInput{}
	}

	output = &DescribeDirectConnectGatewayAttachmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectConnectGatewayAttachments API operation for AWS Direct Connect.
//
// Lists the attachments between your Direct Connect gateways and virtual interfaces.
// You must specify a Direct Connect gateway, a virtual interface, or both.
// If you specify a Direct Connect gateway, the response contains all virtual
// interfaces attached to the Direct Connect gateway. If you specify a virtual
// interface, the response contains all Direct Connect gateways attached to
// the virtual interface. If you specify both, the response contains the attachment
// between the Direct Connect gateway and the virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeDirectConnectGatewayAttachments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments
func (c *DirectConnect) DescribeDirectConnectGatewayAttachments(input *DescribeDirectConnectGatewayAttachmentsInput) (*DescribeDirectConnectGatewayAttachmentsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAttachmentsRequest(input)
	return out, req.Send()
}

// DescribeDirectConnectGatewayAttachmentsWithContext is the same as DescribeDirectConnectGatewayAttachments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectConnectGatewayAttachments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeDirectConnectGatewayAttachmentsWithContext(ctx aws.Context, input *DescribeDirectConnectGatewayAttachmentsInput, opts ...request.Option) (*DescribeDirectConnectGatewayAttachmentsOutput, error) {
	req, out := c.DescribeDirectConnectGatewayAttachmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectConnectGateways = "DescribeDirectConnectGateways"

// DescribeDirectConnectGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectConnectGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectConnectGateways for more information on using the DescribeDirectConnectGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectConnectGatewaysRequest method.
//    req, resp := client.DescribeDirectConnectGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways
func (c *DirectConnect) DescribeDirectConnectGatewaysRequest(input *DescribeDirectConnectGatewaysInput) (req *request.Request, output *DescribeDirectConnectGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectConnectGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewaysInput{}
	}

	output = &DescribeDirectConnectGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectConnectGateways API operation for AWS Direct Connect.
//
// Lists all your Direct Connect gateways or only the specified Direct Connect
// gateway. Deleted Direct Connect gateways are not returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeDirectConnectGateways for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways
func (c *DirectConnect) DescribeDirectConnectGateways(input *DescribeDirectConnectGatewaysInput) (*DescribeDirectConnectGatewaysOutput, error) {
	req, out := c.DescribeDirectConnectGatewaysRequest(input)
	return out, req.Send()
}

// DescribeDirectConnectGatewaysWithContext is the same as DescribeDirectConnectGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectConnectGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeDirectConnectGatewaysWithContext(ctx aws.Context, input *DescribeDirectConnectGatewaysInput, opts ...request.Option) (*DescribeDirectConnectGatewaysOutput, error) {
	req, out := c.DescribeDirectConnectGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHostedConnections = "DescribeHostedConnections"

// DescribeHostedConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostedConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHostedConnections for more information on using the DescribeHostedConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHostedConnectionsRequest method.
//    req, resp := client.DescribeHostedConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections
func (c *DirectConnect) DescribeHostedConnectionsRequest(input *DescribeHostedConnectionsInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeHostedConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHostedConnectionsInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostedConnections API operation for AWS Direct Connect.
//
// Lists the hosted connections that have been provisioned on the specified
// interconnect or link aggregation group (LAG).
//
// Intended for use by AWS Direct Connect Partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeHostedConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections
func (c *DirectConnect) DescribeHostedConnections(input *DescribeHostedConnectionsInput) (*Connections, error) {
	req, out := c.DescribeHostedConnectionsRequest(input)
	return out, req.Send()
}

// DescribeHostedConnectionsWithContext is the same as DescribeHostedConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHostedConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeHostedConnectionsWithContext(ctx aws.Context, input *DescribeHostedConnectionsInput, opts ...request.Option) (*Connections, error) {
	req, out := c.DescribeHostedConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInterconnectLoa = "DescribeInterconnectLoa"

// DescribeInterconnectLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInterconnectLoa operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInterconnectLoa for more information on using the DescribeInterconnectLoa
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInterconnectLoaRequest method.
//    req, resp := client.DescribeInterconnectLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoa
//
// Deprecated: DescribeInterconnectLoa has been deprecated
func (c *DirectConnect) DescribeInterconnectLoaRequest(input *DescribeInterconnectLoaInput) (req *request.Request, output *DescribeInterconnectLoaOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeInterconnectLoa, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeInterconnectLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectLoaInput{}
	}

	output = &DescribeInterconnectLoaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInterconnectLoa API operation for AWS Direct Connect.
//
// Deprecated. Use DescribeLoa instead.
//
// Gets the LOA-CFA for the specified interconnect.
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that is used when establishing your cross connect to AWS at the
// colocation facility. For more information, see Requesting Cross Connects
// at AWS Direct Connect Locations (https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeInterconnectLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoa
//
// Deprecated: DescribeInterconnectLoa has been deprecated
func (c *DirectConnect) DescribeInterconnectLoa(input *DescribeInterconnectLoaInput) (*DescribeInterconnectLoaOutput, error) {
	req, out := c.DescribeInterconnectLoaRequest(input)
	return out, req.Send()
}

// DescribeInterconnectLoaWithContext is the same as DescribeInterconnectLoa with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInterconnectLoa for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: DescribeInterconnectLoaWithContext has been deprecated
func (c *DirectConnect) DescribeInterconnectLoaWithContext(ctx aws.Context, input *DescribeInterconnectLoaInput, opts ...request.Option) (*DescribeInterconnectLoaOutput, error) {
	req, out := c.DescribeInterconnectLoaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInterconnects = "DescribeInterconnects"

// DescribeInterconnectsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInterconnects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInterconnects for more information on using the DescribeInterconnects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInterconnectsRequest method.
//    req, resp := client.DescribeInterconnectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects
func (c *DirectConnect) DescribeInterconnectsRequest(input *DescribeInterconnectsInput) (req *request.Request, output *DescribeInterconnectsOutput) {
	op := &request.Operation{
		Name:       opDescribeInterconnects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectsInput{}
	}

	output = &DescribeInterconnectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInterconnects API operation for AWS Direct Connect.
//
// Lists the interconnects owned by the AWS account or only the specified interconnect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeInterconnects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects
func (c *DirectConnect) DescribeInterconnects(input *DescribeInterconnectsInput) (*DescribeInterconnectsOutput, error) {
	req, out := c.DescribeInterconnectsRequest(input)
	return out, req.Send()
}

// DescribeInterconnectsWithContext is the same as DescribeInterconnects with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInterconnects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeInterconnectsWithContext(ctx aws.Context, input *DescribeInterconnectsInput, opts ...request.Option) (*DescribeInterconnectsOutput, error) {
	req, out := c.DescribeInterconnectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLags = "DescribeLags"

// DescribeLagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLags for more information on using the DescribeLags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLagsRequest method.
//    req, resp := client.DescribeLagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags
func (c *DirectConnect) DescribeLagsRequest(input *DescribeLagsInput) (req *request.Request, output *DescribeLagsOutput) {
	op := &request.Operation{
		Name:       opDescribeLags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLagsInput{}
	}

	output = &DescribeLagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLags API operation for AWS Direct Connect.
//
// Describes all your link aggregation groups (LAG) or the specified LAG.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeLags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags
func (c *DirectConnect) DescribeLags(input *DescribeLagsInput) (*DescribeLagsOutput, error) {
	req, out := c.DescribeLagsRequest(input)
	return out, req.Send()
}

// DescribeLagsWithContext is the same as DescribeLags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeLagsWithContext(ctx aws.Context, input *DescribeLagsInput, opts ...request.Option) (*DescribeLagsOutput, error) {
	req, out := c.DescribeLagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoa = "DescribeLoa"

// DescribeLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoa operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoa for more information on using the DescribeLoa
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoaRequest method.
//    req, resp := client.DescribeLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa
func (c *DirectConnect) DescribeLoaRequest(input *DescribeLoaInput) (req *request.Request, output *Loa) {
	op := &request.Operation{
		Name:       opDescribeLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoaInput{}
	}

	output = &Loa{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoa API operation for AWS Direct Connect.
//
// Gets the LOA-CFA for a connection, interconnect, or link aggregation group
// (LAG).
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that is used when establishing your cross connect to AWS at the
// colocation facility. For more information, see Requesting Cross Connects
// at AWS Direct Connect Locations (https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa
func (c *DirectConnect) DescribeLoa(input *DescribeLoaInput) (*Loa, error) {
	req, out := c.DescribeLoaRequest(input)
	return out, req.Send()
}

// DescribeLoaWithContext is the same as DescribeLoa with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoa for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeLoaWithContext(ctx aws.Context, input *DescribeLoaInput, opts ...request.Option) (*Loa, error) {
	req, out := c.DescribeLoaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocations = "DescribeLocations"

// DescribeLocationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocations for more information on using the DescribeLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationsRequest method.
//    req, resp := client.DescribeLocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations
func (c *DirectConnect) DescribeLocationsRequest(input *DescribeLocationsInput) (req *request.Request, output *DescribeLocationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationsInput{}
	}

	output = &DescribeLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocations API operation for AWS Direct Connect.
//
// Lists the AWS Direct Connect locations in the current AWS Region. These are
// the locations that can be selected when calling CreateConnection or CreateInterconnect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeLocations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations
func (c *DirectConnect) DescribeLocations(input *DescribeLocationsInput) (*DescribeLocationsOutput, error) {
	req, out := c.DescribeLocationsRequest(input)
	return out, req.Send()
}

// DescribeLocationsWithContext is the same as DescribeLocations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeLocationsWithContext(ctx aws.Context, input *DescribeLocationsInput, opts ...request.Option) (*DescribeLocationsOutput, error) {
	req, out := c.DescribeLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags
func (c *DirectConnect) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for AWS Direct Connect.
//
// Describes the tags associated with the specified AWS Direct Connect resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags
func (c *DirectConnect) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualGateways = "DescribeVirtualGateways"

// DescribeVirtualGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualGateways for more information on using the DescribeVirtualGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualGatewaysRequest method.
//    req, resp := client.DescribeVirtualGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways
func (c *DirectConnect) DescribeVirtualGatewaysRequest(input *DescribeVirtualGatewaysInput) (req *request.Request, output *DescribeVirtualGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualGatewaysInput{}
	}

	output = &DescribeVirtualGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualGateways API operation for AWS Direct Connect.
//
// Lists the virtual private gateways owned by the AWS account.
//
// You can create one or more AWS Direct Connect private virtual interfaces
// linked to a virtual private gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeVirtualGateways for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways
func (c *DirectConnect) DescribeVirtualGateways(input *DescribeVirtualGatewaysInput) (*DescribeVirtualGatewaysOutput, error) {
	req, out := c.DescribeVirtualGatewaysRequest(input)
	return out, req.Send()
}

// DescribeVirtualGatewaysWithContext is the same as DescribeVirtualGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeVirtualGatewaysWithContext(ctx aws.Context, input *DescribeVirtualGatewaysInput, opts ...request.Option) (*DescribeVirtualGatewaysOutput, error) {
	req, out := c.DescribeVirtualGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualInterfaces = "DescribeVirtualInterfaces"

// DescribeVirtualInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualInterfaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualInterfaces for more information on using the DescribeVirtualInterfaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualInterfacesRequest method.
//    req, resp := client.DescribeVirtualInterfacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces
func (c *DirectConnect) DescribeVirtualInterfacesRequest(input *DescribeVirtualInterfacesInput) (req *request.Request, output *DescribeVirtualInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualInterfacesInput{}
	}

	output = &DescribeVirtualInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualInterfaces API operation for AWS Direct Connect.
//
// Displays all virtual interfaces for an AWS account. Virtual interfaces deleted
// fewer than 15 minutes before you make the request are also returned. If you
// specify a connection ID, only the virtual interfaces associated with the
// connection are returned. If you specify a virtual interface ID, then only
// a single virtual interface is returned.
//
// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
// location and the customer network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeVirtualInterfaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces
func (c *DirectConnect) DescribeVirtualInterfaces(input *DescribeVirtualInterfacesInput) (*DescribeVirtualInterfacesOutput, error) {
	req, out := c.DescribeVirtualInterfacesRequest(input)
	return out, req.Send()
}

// DescribeVirtualInterfacesWithContext is the same as DescribeVirtualInterfaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualInterfaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DescribeVirtualInterfacesWithContext(ctx aws.Context, input *DescribeVirtualInterfacesInput, opts ...request.Option) (*DescribeVirtualInterfacesOutput, error) {
	req, out := c.DescribeVirtualInterfacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConnectionFromLag = "DisassociateConnectionFromLag"

// DisassociateConnectionFromLagRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConnectionFromLag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateConnectionFromLag for more information on using the DisassociateConnectionFromLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateConnectionFromLagRequest method.
//    req, resp := client.DisassociateConnectionFromLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag
func (c *DirectConnect) DisassociateConnectionFromLagRequest(input *DisassociateConnectionFromLagInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opDisassociateConnectionFromLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectionFromLagInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateConnectionFromLag API operation for AWS Direct Connect.
//
// Disassociates a connection from a link aggregation group (LAG). The connection
// is interrupted and re-established as a standalone connection (the connection
// is not deleted; to delete the connection, use the DeleteConnection request).
// If the LAG has associated virtual interfaces or hosted connections, they
// remain associated with the LAG. A disassociated connection owned by an AWS
// Direct Connect Partner is automatically converted to an interconnect.
//
// If disassociating the connection would cause the LAG to fall below its setting
// for minimum number of operational connections, the request fails, except
// when it's the last member of the LAG. If all connections are disassociated,
// the LAG continues to exist as an empty LAG with no physical connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DisassociateConnectionFromLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag
func (c *DirectConnect) DisassociateConnectionFromLag(input *DisassociateConnectionFromLagInput) (*Connection, error) {
	req, out := c.DisassociateConnectionFromLagRequest(input)
	return out, req.Send()
}

// DisassociateConnectionFromLagWithContext is the same as DisassociateConnectionFromLag with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConnectionFromLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) DisassociateConnectionFromLagWithContext(ctx aws.Context, input *DisassociateConnectionFromLagInput, opts ...request.Option) (*Connection, error) {
	req, out := c.DisassociateConnectionFromLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource
func (c *DirectConnect) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Direct Connect.
//
// Adds the specified tags to the specified AWS Direct Connect resource. Each
// resource can have a maximum of 50 tags.
//
// Each tag consists of a key and an optional value. If a tag with the same
// key is already associated with the resource, this action updates its value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned.
//
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource
func (c *DirectConnect) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource
func (c *DirectConnect) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Direct Connect.
//
// Removes one or more tags from the specified AWS Direct Connect resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource
func (c *DirectConnect) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDirectConnectGatewayAssociation = "UpdateDirectConnectGatewayAssociation"

// UpdateDirectConnectGatewayAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDirectConnectGatewayAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDirectConnectGatewayAssociation for more information on using the UpdateDirectConnectGatewayAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDirectConnectGatewayAssociationRequest method.
//    req, resp := client.UpdateDirectConnectGatewayAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGatewayAssociation
func (c *DirectConnect) UpdateDirectConnectGatewayAssociationRequest(input *UpdateDirectConnectGatewayAssociationInput) (req *request.Request, output *UpdateDirectConnectGatewayAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateDirectConnectGatewayAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDirectConnectGatewayAssociationInput{}
	}

	output = &UpdateDirectConnectGatewayAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDirectConnectGatewayAssociation API operation for AWS Direct Connect.
//
// Updates the specified attributes of the Direct Connect gateway association.
//
// Add or remove prefixes from the association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation UpdateDirectConnectGatewayAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGatewayAssociation
func (c *DirectConnect) UpdateDirectConnectGatewayAssociation(input *UpdateDirectConnectGatewayAssociationInput) (*UpdateDirectConnectGatewayAssociationOutput, error) {
	req, out := c.UpdateDirectConnectGatewayAssociationRequest(input)
	return out, req.Send()
}

// UpdateDirectConnectGatewayAssociationWithContext is the same as UpdateDirectConnectGatewayAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDirectConnectGatewayAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) UpdateDirectConnectGatewayAssociationWithContext(ctx aws.Context, input *UpdateDirectConnectGatewayAssociationInput, opts ...request.Option) (*UpdateDirectConnectGatewayAssociationOutput, error) {
	req, out := c.UpdateDirectConnectGatewayAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLag = "UpdateLag"

// UpdateLagRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLag for more information on using the UpdateLag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLagRequest method.
//    req, resp := client.UpdateLagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag
func (c *DirectConnect) UpdateLagRequest(input *UpdateLagInput) (req *request.Request, output *Lag) {
	op := &request.Operation{
		Name:       opUpdateLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLagInput{}
	}

	output = &Lag{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLag API operation for AWS Direct Connect.
//
// Updates the attributes of the specified link aggregation group (LAG).
//
// You can update the following attributes:
//
//    * The name of the LAG.
//
//    * The value for the minimum number of connections that must be operational
//    for the LAG itself to be operational.
//
// When you create a LAG, the default value for the minimum number of operational
// connections is zero (0). If you update this value and the number of operational
// connections falls below the specified value, the LAG automatically goes down
// to avoid over-utilization of the remaining connections. Adjust this value
// with care, as it could force the LAG down if it is set higher than the current
// number of operational connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation UpdateLag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag
func (c *DirectConnect) UpdateLag(input *UpdateLagInput) (*Lag, error) {
	req, out := c.UpdateLagRequest(input)
	return out, req.Send()
}

// UpdateLagWithContext is the same as UpdateLag with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) UpdateLagWithContext(ctx aws.Context, input *UpdateLagInput, opts ...request.Option) (*Lag, error) {
	req, out := c.UpdateLagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualInterfaceAttributes = "UpdateVirtualInterfaceAttributes"

// UpdateVirtualInterfaceAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualInterfaceAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualInterfaceAttributes for more information on using the UpdateVirtualInterfaceAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVirtualInterfaceAttributesRequest method.
//    req, resp := client.UpdateVirtualInterfaceAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateVirtualInterfaceAttributes
func (c *DirectConnect) UpdateVirtualInterfaceAttributesRequest(input *UpdateVirtualInterfaceAttributesInput) (req *request.Request, output *UpdateVirtualInterfaceAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualInterfaceAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVirtualInterfaceAttributesInput{}
	}

	output = &UpdateVirtualInterfaceAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualInterfaceAttributes API operation for AWS Direct Connect.
//
// Updates the specified attributes of the specified virtual private interface.
//
// Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an
// update to the underlying physical connection if it wasn't updated to support
// jumbo frames. Updating the connection disrupts network connectivity for all
// virtual interfaces associated with the connection for up to 30 seconds. To
// check whether your connection supports jumbo frames, call DescribeConnections.
// To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation UpdateVirtualInterfaceAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "DirectConnectServerException"
//   A server-side error occurred.
//
//   * ErrCodeClientException "DirectConnectClientException"
//   One or more parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateVirtualInterfaceAttributes
func (c *DirectConnect) UpdateVirtualInterfaceAttributes(input *UpdateVirtualInterfaceAttributesInput) (*UpdateVirtualInterfaceAttributesOutput, error) {
	req, out := c.UpdateVirtualInterfaceAttributesRequest(input)
	return out, req.Send()
}

// UpdateVirtualInterfaceAttributesWithContext is the same as UpdateVirtualInterfaceAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualInterfaceAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectConnect) UpdateVirtualInterfaceAttributesWithContext(ctx aws.Context, input *UpdateVirtualInterfaceAttributesInput, opts ...request.Option) (*UpdateVirtualInterfaceAttributesOutput, error) {
	req, out := c.UpdateVirtualInterfaceAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptDirectConnectGatewayAssociationProposalInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that owns the virtual private gateway or transit
	// gateway.
	//
	// AssociatedGatewayOwnerAccount is a required field
	AssociatedGatewayOwnerAccount *string `locationName:"associatedGatewayOwnerAccount" type:"string" required:"true"`

	// The ID of the Direct Connect gateway.
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`

	// Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
	//
	// For information about how to set the prefixes, see Allowed Prefixes (https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes)
	// in the AWS Direct Connect User Guide.
	OverrideAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"overrideAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the request proposal.
	//
	// ProposalId is a required field
	ProposalId *string `locationName:"proposalId" type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptDirectConnectGatewayAssociationProposalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptDirectConnectGatewayAssociationProposalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptDirectConnectGatewayAssociationProposalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptDirectConnectGatewayAssociationProposalInput"}
	if s.AssociatedGatewayOwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociatedGatewayOwnerAccount"))
	}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}
	if s.ProposalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposalId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedGatewayOwnerAccount sets the AssociatedGatewayOwnerAccount field's value.
func (s *AcceptDirectConnectGatewayAssociationProposalInput) SetAssociatedGatewayOwnerAccount(v string) *AcceptDirectConnectGatewayAssociationProposalInput {
	s.AssociatedGatewayOwnerAccount = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *AcceptDirectConnectGatewayAssociationProposalInput) SetDirectConnectGatewayId(v string) *AcceptDirectConnectGatewayAssociationProposalInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetOverrideAllowedPrefixesToDirectConnectGateway sets the OverrideAllowedPrefixesToDirectConnectGateway field's value.
func (s *AcceptDirectConnectGatewayAssociationProposalInput) SetOverrideAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *AcceptDirectConnectGatewayAssociationProposalInput {
	s.OverrideAllowedPrefixesToDirectConnectGateway = v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *AcceptDirectConnectGatewayAssociationProposalInput) SetProposalId(v string) *AcceptDirectConnectGatewayAssociationProposalInput {
	s.ProposalId = &v
	return s
}

type AcceptDirectConnectGatewayAssociationProposalOutput struct {
	_ struct{} `type:"structure"`

	// Information about an association between a Direct Connect gateway and a virtual
	// private gateway or transit gateway.
	DirectConnectGatewayAssociation *GatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s AcceptDirectConnectGatewayAssociationProposalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptDirectConnectGatewayAssociationProposalOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociation sets the DirectConnectGatewayAssociation field's value.
func (s *AcceptDirectConnectGatewayAssociationProposalOutput) SetDirectConnectGatewayAssociation(v *GatewayAssociation) *AcceptDirectConnectGatewayAssociationProposalOutput {
	s.DirectConnectGatewayAssociation = v
	return s
}

type AllocateConnectionOnInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The bandwidth of the connection. The possible values are 50Mbps, 100Mbps,
	// 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note
	// that only those AWS Direct Connect Partners who have met specific requirements
	// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the provisioned connection.
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// The ID of the interconnect on which the connection will be provisioned.
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// The ID of the AWS account of the customer for whom the connection will be
	// provisioned.
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	// The dedicated VLAN provisioned to the connection.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateConnectionOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateConnectionOnInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateConnectionOnInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateConnectionOnInterconnectInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *AllocateConnectionOnInterconnectInput) SetBandwidth(v string) *AllocateConnectionOnInterconnectInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *AllocateConnectionOnInterconnectInput) SetConnectionName(v string) *AllocateConnectionOnInterconnectInput {
	s.ConnectionName = &v
	return s
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *AllocateConnectionOnInterconnectInput) SetInterconnectId(v string) *AllocateConnectionOnInterconnectInput {
	s.InterconnectId = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocateConnectionOnInterconnectInput) SetOwnerAccount(v string) *AllocateConnectionOnInterconnectInput {
	s.OwnerAccount = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *AllocateConnectionOnInterconnectInput) SetVlan(v int64) *AllocateConnectionOnInterconnectInput {
	s.Vlan = &v
	return s
}

type AllocateHostedConnectionInput struct {
	_ struct{} `type:"structure"`

	// The bandwidth of the connection. The possible values are 50Mbps, 100Mbps,
	// 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note
	// that only those AWS Direct Connect Partners who have met specific requirements
	// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The ID of the interconnect or LAG.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The name of the hosted connection.
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// The ID of the AWS account ID of the customer for the connection.
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	// The tags associated with the connection.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The dedicated VLAN provisioned to the hosted connection.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateHostedConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateHostedConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateHostedConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateHostedConnectionInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *AllocateHostedConnectionInput) SetBandwidth(v string) *AllocateHostedConnectionInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocateHostedConnectionInput) SetConnectionId(v string) *AllocateHostedConnectionInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *AllocateHostedConnectionInput) SetConnectionName(v string) *AllocateHostedConnectionInput {
	s.ConnectionName = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocateHostedConnectionInput) SetOwnerAccount(v string) *AllocateHostedConnectionInput {
	s.OwnerAccount = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AllocateHostedConnectionInput) SetTags(v []*Tag) *AllocateHostedConnectionInput {
	s.Tags = v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *AllocateHostedConnectionInput) SetVlan(v int64) *AllocateHostedConnectionInput {
	s.Vlan = &v
	return s
}

type AllocatePrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection on which the private virtual interface is provisioned.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Information about the private virtual interface.
	//
	// NewPrivateVirtualInterfaceAllocation is a required field
	NewPrivateVirtualInterfaceAllocation *NewPrivateVirtualInterfaceAllocation `locationName:"newPrivateVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The ID of the AWS account that owns the virtual private interface.
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocatePrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocatePrivateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPrivateVirtualInterfaceAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPrivateVirtualInterfaceAllocation"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.NewPrivateVirtualInterfaceAllocation != nil {
		if err := s.NewPrivateVirtualInterfaceAllocation.Validate(); err != nil {
			invalidParams.AddNested("NewPrivateVirtualInterfaceAllocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetConnectionId(v string) *AllocatePrivateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPrivateVirtualInterfaceAllocation sets the NewPrivateVirtualInterfaceAllocation field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetNewPrivateVirtualInterfaceAllocation(v *NewPrivateVirtualInterfaceAllocation) *AllocatePrivateVirtualInterfaceInput {
	s.NewPrivateVirtualInterfaceAllocation = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetOwnerAccount(v string) *AllocatePrivateVirtualInterfaceInput {
	s.OwnerAccount = &v
	return s
}

type AllocatePublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection on which the public virtual interface is provisioned.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Information about the public virtual interface.
	//
	// NewPublicVirtualInterfaceAllocation is a required field
	NewPublicVirtualInterfaceAllocation *NewPublicVirtualInterfaceAllocation `locationName:"newPublicVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The ID of the AWS account that owns the public virtual interface.
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocatePublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocatePublicVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPublicVirtualInterfaceAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPublicVirtualInterfaceAllocation"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.NewPublicVirtualInterfaceAllocation != nil {
		if err := s.NewPublicVirtualInterfaceAllocation.Validate(); err != nil {
			invalidParams.AddNested("NewPublicVirtualInterfaceAllocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetConnectionId(v string) *AllocatePublicVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPublicVirtualInterfaceAllocation sets the NewPublicVirtualInterfaceAllocation field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetNewPublicVirtualInterfaceAllocation(v *NewPublicVirtualInterfaceAllocation) *AllocatePublicVirtualInterfaceInput {
	s.NewPublicVirtualInterfaceAllocation = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetOwnerAccount(v string) *AllocatePublicVirtualInterfaceInput {
	s.OwnerAccount = &v
	return s
}

type AllocateTransitVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection on which the transit virtual interface is provisioned.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Information about the transit virtual interface.
	//
	// NewTransitVirtualInterfaceAllocation is a required field
	NewTransitVirtualInterfaceAllocation *NewTransitVirtualInterfaceAllocation `locationName:"newTransitVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The ID of the AWS account that owns the transit virtual interface.
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocateTransitVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateTransitVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateTransitVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateTransitVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewTransitVirtualInterfaceAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("NewTransitVirtualInterfaceAllocation"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.NewTransitVirtualInterfaceAllocation != nil {
		if err := s.NewTransitVirtualInterfaceAllocation.Validate(); err != nil {
			invalidParams.AddNested("NewTransitVirtualInterfaceAllocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocateTransitVirtualInterfaceInput) SetConnectionId(v string) *AllocateTransitVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewTransitVirtualInterfaceAllocation sets the NewTransitVirtualInterfaceAllocation field's value.
func (s *AllocateTransitVirtualInterfaceInput) SetNewTransitVirtualInterfaceAllocation(v *NewTransitVirtualInterfaceAllocation) *AllocateTransitVirtualInterfaceInput {
	s.NewTransitVirtualInterfaceAllocation = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocateTransitVirtualInterfaceInput) SetOwnerAccount(v string) *AllocateTransitVirtualInterfaceInput {
	s.OwnerAccount = &v
	return s
}

type AllocateTransitVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// Information about a virtual interface.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s AllocateTransitVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateTransitVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *AllocateTransitVirtualInterfaceOutput) SetVirtualInterface(v *VirtualInterface) *AllocateTransitVirtualInterfaceOutput {
	s.VirtualInterface = v
	return s
}

type AssociateConnectionWithLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the LAG with which to associate the connection.
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateConnectionWithLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateConnectionWithLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateConnectionWithLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateConnectionWithLagInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AssociateConnectionWithLagInput) SetConnectionId(v string) *AssociateConnectionWithLagInput {
	s.ConnectionId = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *AssociateConnectionWithLagInput) SetLagId(v string) *AssociateConnectionWithLagInput {
	s.LagId = &v
	return s
}

type AssociateHostedConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the interconnect or the LAG.
	//
	// ParentConnectionId is a required field
	ParentConnectionId *string `locationName:"parentConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateHostedConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateHostedConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateHostedConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateHostedConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ParentConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AssociateHostedConnectionInput) SetConnectionId(v string) *AssociateHostedConnectionInput {
	s.ConnectionId = &v
	return s
}

// SetParentConnectionId sets the ParentConnectionId field's value.
func (s *AssociateHostedConnectionInput) SetParentConnectionId(v string) *AssociateHostedConnectionInput {
	s.ParentConnectionId = &v
	return s
}

type AssociateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG or connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the virtual interface.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AssociateVirtualInterfaceInput) SetConnectionId(v string) *AssociateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *AssociateVirtualInterfaceInput) SetVirtualInterfaceId(v string) *AssociateVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// Information about the associated gateway.
type AssociatedGateway struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	Id *string `locationName:"id" type:"string"`

	// The ID of the AWS account that owns the associated virtual private gateway
	// or transit gateway.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The Region where the associated gateway is located.
	Region *string `locationName:"region" type:"string"`

	// The type of associated gateway.
	Type *string `locationName:"type" type:"string" enum:"GatewayType"`
}

// String returns the string representation
func (s AssociatedGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatedGateway) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AssociatedGateway) SetId(v string) *AssociatedGateway {
	s.Id = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AssociatedGateway) SetOwnerAccount(v string) *AssociatedGateway {
	s.OwnerAccount = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *AssociatedGateway) SetRegion(v string) *AssociatedGateway {
	s.Region = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssociatedGateway) SetType(v string) *AssociatedGateway {
	s.Type = &v
	return s
}

// Information about a BGP peer.
type BGPPeer struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The Direct Connect endpoint on which the BGP peer terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The ID of the BGP peer.
	BgpPeerId *string `locationName:"bgpPeerId" type:"string"`

	// The state of the BGP peer. The following are the possible values:
	//
	//    * verifying: The BGP peering addresses or ASN require validation before
	//    the BGP peer can be created. This state applies only to public virtual
	//    interfaces.
	//
	//    * pending: The BGP peer is created, and remains in this state until it
	//    is ready to be established.
	//
	//    * available: The BGP peer is ready to be established.
	//
	//    * deleting: The BGP peer is being deleted.
	//
	//    * deleted: The BGP peer is deleted and cannot be established.
	BgpPeerState *string `locationName:"bgpPeerState" type:"string" enum:"BGPPeerState"`

	// The status of the BGP peer. The following are the possible values:
	//
	//    * up: The BGP peer is established. This state does not indicate the state
	//    of the routing function. Ensure that you are receiving routes over the
	//    BGP session.
	//
	//    * down: The BGP peer is down.
	//
	//    * unknown: The BGP peer status is not available.
	BgpStatus *string `locationName:"bgpStatus" type:"string" enum:"BGPStatus"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s BGPPeer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BGPPeer) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *BGPPeer) SetAddressFamily(v string) *BGPPeer {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *BGPPeer) SetAmazonAddress(v string) *BGPPeer {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *BGPPeer) SetAsn(v int64) *BGPPeer {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *BGPPeer) SetAuthKey(v string) *BGPPeer {
	s.AuthKey = &v
	return s
}

// SetAwsDeviceV2 sets the AwsDeviceV2 field's value.
func (s *BGPPeer) SetAwsDeviceV2(v string) *BGPPeer {
	s.AwsDeviceV2 = &v
	return s
}

// SetBgpPeerId sets the BgpPeerId field's value.
func (s *BGPPeer) SetBgpPeerId(v string) *BGPPeer {
	s.BgpPeerId = &v
	return s
}

// SetBgpPeerState sets the BgpPeerState field's value.
func (s *BGPPeer) SetBgpPeerState(v string) *BGPPeer {
	s.BgpPeerState = &v
	return s
}

// SetBgpStatus sets the BgpStatus field's value.
func (s *BGPPeer) SetBgpStatus(v string) *BGPPeer {
	s.BgpStatus = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *BGPPeer) SetCustomerAddress(v string) *BGPPeer {
	s.CustomerAddress = &v
	return s
}

type ConfirmConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *ConfirmConnectionInput) SetConnectionId(v string) *ConfirmConnectionInput {
	s.ConnectionId = &v
	return s
}

type ConfirmConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The state of the connection. The following are the possible values:
	//
	//    * ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * pending: The connection has been approved and is being initialized.
	//
	//    * available: The network link is up and the connection is ready for use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The connection is being deleted.
	//
	//    * deleted: The connection has been deleted.
	//
	//    * rejected: A hosted connection in the ordering state enters the rejected
	//    state if it is deleted by the customer.
	//
	//    * unknown: The state of the connection is not available.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`
}

// String returns the string representation
func (s ConfirmConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *ConfirmConnectionOutput) SetConnectionState(v string) *ConfirmConnectionOutput {
	s.ConnectionState = &v
	return s
}

type ConfirmPrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the virtual interface.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmPrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmPrivateVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetDirectConnectGatewayId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetVirtualGatewayId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetVirtualInterfaceId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

type ConfirmPrivateVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The state of the virtual interface. The following are the possible values:
	//
	//    * confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * available: A virtual interface that is able to forward traffic.
	//
	//    * down: A virtual interface that is BGP down.
	//
	//    * deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * deleted: A virtual interface that cannot forward traffic.
	//
	//    * rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the Confirming state is deleted by
	//    the virtual interface owner, the virtual interface enters the Rejected
	//    state.
	//
	//    * unknown: The state of the virtual interface is not available.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *ConfirmPrivateVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *ConfirmPrivateVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

type ConfirmPublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual interface.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmPublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmPublicVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *ConfirmPublicVirtualInterfaceInput) SetVirtualInterfaceId(v string) *ConfirmPublicVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

type ConfirmPublicVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The state of the virtual interface. The following are the possible values:
	//
	//    * confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * available: A virtual interface that is able to forward traffic.
	//
	//    * down: A virtual interface that is BGP down.
	//
	//    * deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * deleted: A virtual interface that cannot forward traffic.
	//
	//    * rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the Confirming state is deleted by
	//    the virtual interface owner, the virtual interface enters the Rejected
	//    state.
	//
	//    * unknown: The state of the virtual interface is not available.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *ConfirmPublicVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *ConfirmPublicVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

type ConfirmTransitVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Direct Connect gateway.
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`

	// The ID of the virtual interface.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmTransitVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmTransitVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmTransitVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmTransitVirtualInterfaceInput"}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *ConfirmTransitVirtualInterfaceInput) SetDirectConnectGatewayId(v string) *ConfirmTransitVirtualInterfaceInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *ConfirmTransitVirtualInterfaceInput) SetVirtualInterfaceId(v string) *ConfirmTransitVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

type ConfirmTransitVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The state of the virtual interface. The following are the possible values:
	//
	//    * confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * available: A virtual interface that is able to forward traffic.
	//
	//    * down: A virtual interface that is BGP down.
	//
	//    * deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * deleted: A virtual interface that cannot forward traffic.
	//
	//    * rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the Confirming state is deleted by
	//    the virtual interface owner, the virtual interface enters the Rejected
	//    state.
	//
	//    * unknown: The state of the virtual interface is not available.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s ConfirmTransitVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmTransitVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *ConfirmTransitVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *ConfirmTransitVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

// Information about an AWS Direct Connect connection.
type Connection struct {
	_ struct{} `type:"structure"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The bandwidth of the connection.
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The name of the connection.
	ConnectionName *string `locationName:"connectionName" type:"string"`

	// The state of the connection. The following are the possible values:
	//
	//    * ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * pending: The connection has been approved and is being initialized.
	//
	//    * available: The network link is up and the connection is ready for use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The connection is being deleted.
	//
	//    * deleted: The connection has been deleted.
	//
	//    * rejected: A hosted connection in the ordering state enters the rejected
	//    state if it is deleted by the customer.
	//
	//    * unknown: The state of the connection is not available.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`

	// Indicates whether the connection supports a secondary BGP peer in the same
	// address family (IPv4/IPv6).
	HasLogicalRedundancy *string `locationName:"hasLogicalRedundancy" type:"string" enum:"HasLogicalRedundancy"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeLoa for this connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The ID of the AWS account that owns the connection.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the AWS Direct Connect service provider associated with the connection.
	PartnerName *string `locationName:"partnerName" type:"string"`

	// The name of the service provider associated with the connection.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the connection.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

// SetAwsDevice sets the AwsDevice field's value.
func (s *Connection) SetAwsDevice(v string) *Connection {
	s.AwsDevice = &v
	return s
}

// SetAwsDeviceV2 sets the AwsDeviceV2 field's value.
func (s *Connection) SetAwsDeviceV2(v string) *Connection {
	s.AwsDeviceV2 = &v
	return s
}

// SetBandwidth sets the Bandwidth field's value.
func (s *Connection) SetBandwidth(v string) *Connection {
	s.Bandwidth = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *Connection) SetConnectionId(v string) *Connection {
	s.ConnectionId = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *Connection) SetConnectionName(v string) *Connection {
	s.ConnectionName = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *Connection) SetConnectionState(v string) *Connection {
	s.ConnectionState = &v
	return s
}

// SetHasLogicalRedundancy sets the HasLogicalRedundancy field's value.
func (s *Connection) SetHasLogicalRedundancy(v string) *Connection {
	s.HasLogicalRedundancy = &v
	return s
}

// SetJumboFrameCapable sets the JumboFrameCapable field's value.
func (s *Connection) SetJumboFrameCapable(v bool) *Connection {
	s.JumboFrameCapable = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *Connection) SetLagId(v string) *Connection {
	s.LagId = &v
	return s
}

// SetLoaIssueTime sets the LoaIssueTime field's value.
func (s *Connection) SetLoaIssueTime(v time.Time) *Connection {
	s.LoaIssueTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Connection) SetLocation(v string) *Connection {
	s.Location = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Connection) SetOwnerAccount(v string) *Connection {
	s.OwnerAccount = &v
	return s
}

// SetPartnerName sets the PartnerName field's value.
func (s *Connection) SetPartnerName(v string) *Connection {
	s.PartnerName = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *Connection) SetProviderName(v string) *Connection {
	s.ProviderName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Connection) SetRegion(v string) *Connection {
	s.Region = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Connection) SetTags(v []*Tag) *Connection {
	s.Tags = v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *Connection) SetVlan(v int64) *Connection {
	s.Vlan = &v
	return s
}

type Connections struct {
	_ struct{} `type:"structure"`

	// The connections.
	Connections []*Connection `locationName:"connections" type:"list"`
}

// String returns the string representation
func (s Connections) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connections) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *Connections) SetConnections(v []*Connection) *Connections {
	s.Connections = v
	return s
}

type CreateBGPPeerInput struct {
	_ struct{} `type:"structure"`

	// Information about the BGP peer.
	NewBGPPeer *NewBGPPeer `locationName:"newBGPPeer" type:"structure"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s CreateBGPPeerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBGPPeerInput) GoString() string {
	return s.String()
}

// SetNewBGPPeer sets the NewBGPPeer field's value.
func (s *CreateBGPPeerInput) SetNewBGPPeer(v *NewBGPPeer) *CreateBGPPeerInput {
	s.NewBGPPeer = v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *CreateBGPPeerInput) SetVirtualInterfaceId(v string) *CreateBGPPeerInput {
	s.VirtualInterfaceId = &v
	return s
}

type CreateBGPPeerOutput struct {
	_ struct{} `type:"structure"`

	// The virtual interface.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s CreateBGPPeerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBGPPeerOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *CreateBGPPeerOutput) SetVirtualInterface(v *VirtualInterface) *CreateBGPPeerOutput {
	s.VirtualInterface = v
	return s
}

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The bandwidth of the connection.
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the connection.
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The location of the connection.
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`

	// The name of the service provider associated with the requested connection.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The tags to associate with the lag.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateConnectionInput) SetBandwidth(v string) *CreateConnectionInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *CreateConnectionInput) SetConnectionName(v string) *CreateConnectionInput {
	s.ConnectionName = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *CreateConnectionInput) SetLagId(v string) *CreateConnectionInput {
	s.LagId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateConnectionInput) SetLocation(v string) *CreateConnectionInput {
	s.Location = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *CreateConnectionInput) SetProviderName(v string) *CreateConnectionInput {
	s.ProviderName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectionInput) SetTags(v []*Tag) *CreateConnectionInput {
	s.Tags = v
	return s
}

type CreateDirectConnectGatewayAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway
	//
	// This parameter is required when you create an association to a transit gateway.
	//
	// For information about how to set the prefixes, see Allowed Prefixes (https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes)
	// in the AWS Direct Connect User Guide.
	AddAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"addAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the Direct Connect gateway.
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`

	// The ID of the virtual private gateway or transit gateway.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectConnectGatewayAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectConnectGatewayAssociationInput"}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddAllowedPrefixesToDirectConnectGateway sets the AddAllowedPrefixesToDirectConnectGateway field's value.
func (s *CreateDirectConnectGatewayAssociationInput) SetAddAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *CreateDirectConnectGatewayAssociationInput {
	s.AddAllowedPrefixesToDirectConnectGateway = v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *CreateDirectConnectGatewayAssociationInput) SetDirectConnectGatewayId(v string) *CreateDirectConnectGatewayAssociationInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *CreateDirectConnectGatewayAssociationInput) SetGatewayId(v string) *CreateDirectConnectGatewayAssociationInput {
	s.GatewayId = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *CreateDirectConnectGatewayAssociationInput) SetVirtualGatewayId(v string) *CreateDirectConnectGatewayAssociationInput {
	s.VirtualGatewayId = &v
	return s
}

type CreateDirectConnectGatewayAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The association to be created.
	DirectConnectGatewayAssociation *GatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayAssociationOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociation sets the DirectConnectGatewayAssociation field's value.
func (s *CreateDirectConnectGatewayAssociationOutput) SetDirectConnectGatewayAssociation(v *GatewayAssociation) *CreateDirectConnectGatewayAssociationOutput {
	s.DirectConnectGatewayAssociation = v
	return s
}

type CreateDirectConnectGatewayAssociationProposalInput struct {
	_ struct{} `type:"structure"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway.
	AddAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"addAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the Direct Connect gateway.
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`

	// The ID of the AWS account that owns the Direct Connect gateway.
	//
	// DirectConnectGatewayOwnerAccount is a required field
	DirectConnectGatewayOwnerAccount *string `locationName:"directConnectGatewayOwnerAccount" type:"string" required:"true"`

	// The ID of the virtual private gateway or transit gateway.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" type:"string" required:"true"`

	// The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
	RemoveAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"removeAllowedPrefixesToDirectConnectGateway" type:"list"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationProposalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayAssociationProposalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectConnectGatewayAssociationProposalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectConnectGatewayAssociationProposalInput"}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}
	if s.DirectConnectGatewayOwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayOwnerAccount"))
	}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddAllowedPrefixesToDirectConnectGateway sets the AddAllowedPrefixesToDirectConnectGateway field's value.
func (s *CreateDirectConnectGatewayAssociationProposalInput) SetAddAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *CreateDirectConnectGatewayAssociationProposalInput {
	s.AddAllowedPrefixesToDirectConnectGateway = v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *CreateDirectConnectGatewayAssociationProposalInput) SetDirectConnectGatewayId(v string) *CreateDirectConnectGatewayAssociationProposalInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetDirectConnectGatewayOwnerAccount sets the DirectConnectGatewayOwnerAccount field's value.
func (s *CreateDirectConnectGatewayAssociationProposalInput) SetDirectConnectGatewayOwnerAccount(v string) *CreateDirectConnectGatewayAssociationProposalInput {
	s.DirectConnectGatewayOwnerAccount = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *CreateDirectConnectGatewayAssociationProposalInput) SetGatewayId(v string) *CreateDirectConnectGatewayAssociationProposalInput {
	s.GatewayId = &v
	return s
}

// SetRemoveAllowedPrefixesToDirectConnectGateway sets the RemoveAllowedPrefixesToDirectConnectGateway field's value.
func (s *CreateDirectConnectGatewayAssociationProposalInput) SetRemoveAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *CreateDirectConnectGatewayAssociationProposalInput {
	s.RemoveAllowedPrefixesToDirectConnectGateway = v
	return s
}

type CreateDirectConnectGatewayAssociationProposalOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Direct Connect gateway proposal.
	DirectConnectGatewayAssociationProposal *GatewayAssociationProposal `locationName:"directConnectGatewayAssociationProposal" type:"structure"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayAssociationProposalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayAssociationProposalOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociationProposal sets the DirectConnectGatewayAssociationProposal field's value.
func (s *CreateDirectConnectGatewayAssociationProposalOutput) SetDirectConnectGatewayAssociationProposal(v *GatewayAssociationProposal) *CreateDirectConnectGatewayAssociationProposalOutput {
	s.DirectConnectGatewayAssociationProposal = v
	return s
}

type CreateDirectConnectGatewayInput struct {
	_ struct{} `type:"structure"`

	// The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be
	// configured on the Amazon side of the connection. The ASN must be in the private
	// range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294. The default
	// is 64512.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The name of the Direct Connect gateway.
	//
	// DirectConnectGatewayName is a required field
	DirectConnectGatewayName *string `locationName:"directConnectGatewayName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectConnectGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectConnectGatewayInput"}
	if s.DirectConnectGatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *CreateDirectConnectGatewayInput) SetAmazonSideAsn(v int64) *CreateDirectConnectGatewayInput {
	s.AmazonSideAsn = &v
	return s
}

// SetDirectConnectGatewayName sets the DirectConnectGatewayName field's value.
func (s *CreateDirectConnectGatewayInput) SetDirectConnectGatewayName(v string) *CreateDirectConnectGatewayInput {
	s.DirectConnectGatewayName = &v
	return s
}

type CreateDirectConnectGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Direct Connect gateway.
	DirectConnectGateway *Gateway `locationName:"directConnectGateway" type:"structure"`
}

// String returns the string representation
func (s CreateDirectConnectGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectConnectGatewayOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGateway sets the DirectConnectGateway field's value.
func (s *CreateDirectConnectGatewayOutput) SetDirectConnectGateway(v *Gateway) *CreateDirectConnectGatewayOutput {
	s.DirectConnectGateway = v
	return s
}

type CreateInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The port bandwidth, in Gbps. The possible values are 1 and 10.
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the interconnect.
	//
	// InterconnectName is a required field
	InterconnectName *string `locationName:"interconnectName" type:"string" required:"true"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The location of the interconnect.
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`

	// The name of the service provider associated with the interconnect.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The tags to associate with the interconnect.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreateInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInterconnectInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.InterconnectName == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateInterconnectInput) SetBandwidth(v string) *CreateInterconnectInput {
	s.Bandwidth = &v
	return s
}

// SetInterconnectName sets the InterconnectName field's value.
func (s *CreateInterconnectInput) SetInterconnectName(v string) *CreateInterconnectInput {
	s.InterconnectName = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *CreateInterconnectInput) SetLagId(v string) *CreateInterconnectInput {
	s.LagId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateInterconnectInput) SetLocation(v string) *CreateInterconnectInput {
	s.Location = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *CreateInterconnectInput) SetProviderName(v string) *CreateInterconnectInput {
	s.ProviderName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInterconnectInput) SetTags(v []*Tag) *CreateInterconnectInput {
	s.Tags = v
	return s
}

type CreateLagInput struct {
	_ struct{} `type:"structure"`

	// The tags to associate with the automtically created LAGs.
	ChildConnectionTags []*Tag `locationName:"childConnectionTags" min:"1" type:"list"`

	// The ID of an existing connection to migrate to the LAG.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The bandwidth of the individual physical connections bundled by the LAG.
	// The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps,
	// 1Gbps, 2Gbps, 5Gbps, and 10Gbps.
	//
	// ConnectionsBandwidth is a required field
	ConnectionsBandwidth *string `locationName:"connectionsBandwidth" type:"string" required:"true"`

	// The name of the LAG.
	//
	// LagName is a required field
	LagName *string `locationName:"lagName" type:"string" required:"true"`

	// The location for the LAG.
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`

	// The number of physical connections initially provisioned and bundled by the
	// LAG.
	//
	// NumberOfConnections is a required field
	NumberOfConnections *int64 `locationName:"numberOfConnections" type:"integer" required:"true"`

	// The name of the service provider associated with the LAG.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The tags to associate with the LAG.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreateLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLagInput"}
	if s.ChildConnectionTags != nil && len(s.ChildConnectionTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChildConnectionTags", 1))
	}
	if s.ConnectionsBandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionsBandwidth"))
	}
	if s.LagName == nil {
		invalidParams.Add(request.NewErrParamRequired("LagName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.NumberOfConnections == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfConnections"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ChildConnectionTags != nil {
		for i, v := range s.ChildConnectionTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChildConnectionTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildConnectionTags sets the ChildConnectionTags field's value.
func (s *CreateLagInput) SetChildConnectionTags(v []*Tag) *CreateLagInput {
	s.ChildConnectionTags = v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreateLagInput) SetConnectionId(v string) *CreateLagInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionsBandwidth sets the ConnectionsBandwidth field's value.
func (s *CreateLagInput) SetConnectionsBandwidth(v string) *CreateLagInput {
	s.ConnectionsBandwidth = &v
	return s
}

// SetLagName sets the LagName field's value.
func (s *CreateLagInput) SetLagName(v string) *CreateLagInput {
	s.LagName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateLagInput) SetLocation(v string) *CreateLagInput {
	s.Location = &v
	return s
}

// SetNumberOfConnections sets the NumberOfConnections field's value.
func (s *CreateLagInput) SetNumberOfConnections(v int64) *CreateLagInput {
	s.NumberOfConnections = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *CreateLagInput) SetProviderName(v string) *CreateLagInput {
	s.ProviderName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLagInput) SetTags(v []*Tag) *CreateLagInput {
	s.Tags = v
	return s
}

type CreatePrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Information about the private virtual interface.
	//
	// NewPrivateVirtualInterface is a required field
	NewPrivateVirtualInterface *NewPrivateVirtualInterface `locationName:"newPrivateVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrivateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPrivateVirtualInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPrivateVirtualInterface"))
	}
	if s.NewPrivateVirtualInterface != nil {
		if err := s.NewPrivateVirtualInterface.Validate(); err != nil {
			invalidParams.AddNested("NewPrivateVirtualInterface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreatePrivateVirtualInterfaceInput) SetConnectionId(v string) *CreatePrivateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPrivateVirtualInterface sets the NewPrivateVirtualInterface field's value.
func (s *CreatePrivateVirtualInterfaceInput) SetNewPrivateVirtualInterface(v *NewPrivateVirtualInterface) *CreatePrivateVirtualInterfaceInput {
	s.NewPrivateVirtualInterface = v
	return s
}

type CreatePublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Information about the public virtual interface.
	//
	// NewPublicVirtualInterface is a required field
	NewPublicVirtualInterface *NewPublicVirtualInterface `locationName:"newPublicVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublicVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPublicVirtualInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPublicVirtualInterface"))
	}
	if s.NewPublicVirtualInterface != nil {
		if err := s.NewPublicVirtualInterface.Validate(); err != nil {
			invalidParams.AddNested("NewPublicVirtualInterface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreatePublicVirtualInterfaceInput) SetConnectionId(v string) *CreatePublicVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPublicVirtualInterface sets the NewPublicVirtualInterface field's value.
func (s *CreatePublicVirtualInterfaceInput) SetNewPublicVirtualInterface(v *NewPublicVirtualInterface) *CreatePublicVirtualInterfaceInput {
	s.NewPublicVirtualInterface = v
	return s
}

type CreateTransitVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Information about the transit virtual interface.
	//
	// NewTransitVirtualInterface is a required field
	NewTransitVirtualInterface *NewTransitVirtualInterface `locationName:"newTransitVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTransitVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTransitVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTransitVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTransitVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewTransitVirtualInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NewTransitVirtualInterface"))
	}
	if s.NewTransitVirtualInterface != nil {
		if err := s.NewTransitVirtualInterface.Validate(); err != nil {
			invalidParams.AddNested("NewTransitVirtualInterface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreateTransitVirtualInterfaceInput) SetConnectionId(v string) *CreateTransitVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewTransitVirtualInterface sets the NewTransitVirtualInterface field's value.
func (s *CreateTransitVirtualInterfaceInput) SetNewTransitVirtualInterface(v *NewTransitVirtualInterface) *CreateTransitVirtualInterfaceInput {
	s.NewTransitVirtualInterface = v
	return s
}

type CreateTransitVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// Information about a virtual interface.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s CreateTransitVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTransitVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *CreateTransitVirtualInterfaceOutput) SetVirtualInterface(v *VirtualInterface) *CreateTransitVirtualInterfaceOutput {
	s.VirtualInterface = v
	return s
}

type DeleteBGPPeerInput struct {
	_ struct{} `type:"structure"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The ID of the BGP peer.
	BgpPeerId *string `locationName:"bgpPeerId" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DeleteBGPPeerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBGPPeerInput) GoString() string {
	return s.String()
}

// SetAsn sets the Asn field's value.
func (s *DeleteBGPPeerInput) SetAsn(v int64) *DeleteBGPPeerInput {
	s.Asn = &v
	return s
}

// SetBgpPeerId sets the BgpPeerId field's value.
func (s *DeleteBGPPeerInput) SetBgpPeerId(v string) *DeleteBGPPeerInput {
	s.BgpPeerId = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *DeleteBGPPeerInput) SetCustomerAddress(v string) *DeleteBGPPeerInput {
	s.CustomerAddress = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DeleteBGPPeerInput) SetVirtualInterfaceId(v string) *DeleteBGPPeerInput {
	s.VirtualInterfaceId = &v
	return s
}

type DeleteBGPPeerOutput struct {
	_ struct{} `type:"structure"`

	// The virtual interface.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s DeleteBGPPeerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBGPPeerOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *DeleteBGPPeerOutput) SetVirtualInterface(v *VirtualInterface) *DeleteBGPPeerOutput {
	s.VirtualInterface = v
	return s
}

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DeleteConnectionInput) SetConnectionId(v string) *DeleteConnectionInput {
	s.ConnectionId = &v
	return s
}

type DeleteDirectConnectGatewayAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Direct Connect gateway association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayAssociationInput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *DeleteDirectConnectGatewayAssociationInput) SetAssociationId(v string) *DeleteDirectConnectGatewayAssociationInput {
	s.AssociationId = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DeleteDirectConnectGatewayAssociationInput) SetDirectConnectGatewayId(v string) *DeleteDirectConnectGatewayAssociationInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *DeleteDirectConnectGatewayAssociationInput) SetVirtualGatewayId(v string) *DeleteDirectConnectGatewayAssociationInput {
	s.VirtualGatewayId = &v
	return s
}

type DeleteDirectConnectGatewayAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted association.
	DirectConnectGatewayAssociation *GatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayAssociationOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociation sets the DirectConnectGatewayAssociation field's value.
func (s *DeleteDirectConnectGatewayAssociationOutput) SetDirectConnectGatewayAssociation(v *GatewayAssociation) *DeleteDirectConnectGatewayAssociationOutput {
	s.DirectConnectGatewayAssociation = v
	return s
}

type DeleteDirectConnectGatewayAssociationProposalInput struct {
	_ struct{} `type:"structure"`

	// The ID of the proposal.
	//
	// ProposalId is a required field
	ProposalId *string `locationName:"proposalId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationProposalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayAssociationProposalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectConnectGatewayAssociationProposalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectConnectGatewayAssociationProposalInput"}
	if s.ProposalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposalId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProposalId sets the ProposalId field's value.
func (s *DeleteDirectConnectGatewayAssociationProposalInput) SetProposalId(v string) *DeleteDirectConnectGatewayAssociationProposalInput {
	s.ProposalId = &v
	return s
}

type DeleteDirectConnectGatewayAssociationProposalOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	DirectConnectGatewayAssociationProposal *GatewayAssociationProposal `locationName:"directConnectGatewayAssociationProposal" type:"structure"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationProposalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayAssociationProposalOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociationProposal sets the DirectConnectGatewayAssociationProposal field's value.
func (s *DeleteDirectConnectGatewayAssociationProposalOutput) SetDirectConnectGatewayAssociationProposal(v *GatewayAssociationProposal) *DeleteDirectConnectGatewayAssociationProposalOutput {
	s.DirectConnectGatewayAssociationProposal = v
	return s
}

type DeleteDirectConnectGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Direct Connect gateway.
	//
	// DirectConnectGatewayId is a required field
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectConnectGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectConnectGatewayInput"}
	if s.DirectConnectGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectConnectGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DeleteDirectConnectGatewayInput) SetDirectConnectGatewayId(v string) *DeleteDirectConnectGatewayInput {
	s.DirectConnectGatewayId = &v
	return s
}

type DeleteDirectConnectGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Direct Connect gateway.
	DirectConnectGateway *Gateway `locationName:"directConnectGateway" type:"structure"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectConnectGatewayOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGateway sets the DirectConnectGateway field's value.
func (s *DeleteDirectConnectGatewayOutput) SetDirectConnectGateway(v *Gateway) *DeleteDirectConnectGatewayOutput {
	s.DirectConnectGateway = v
	return s
}

type DeleteInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInterconnectInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DeleteInterconnectInput) SetInterconnectId(v string) *DeleteInterconnectInput {
	s.InterconnectId = &v
	return s
}

type DeleteInterconnectOutput struct {
	_ struct{} `type:"structure"`

	// The state of the interconnect. The following are the possible values:
	//
	//    * requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * pending: The interconnect is approved, and is being initialized.
	//
	//    * available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The interconnect is being deleted.
	//
	//    * deleted: The interconnect is deleted.
	//
	//    * unknown: The state of the interconnect is not available.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`
}

// String returns the string representation
func (s DeleteInterconnectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectOutput) GoString() string {
	return s.String()
}

// SetInterconnectState sets the InterconnectState field's value.
func (s *DeleteInterconnectOutput) SetInterconnectState(v string) *DeleteInterconnectOutput {
	s.InterconnectState = &v
	return s
}

type DeleteLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG.
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLagInput"}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLagId sets the LagId field's value.
func (s *DeleteLagInput) SetLagId(v string) *DeleteLagInput {
	s.LagId = &v
	return s
}

type DeleteVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual interface.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DeleteVirtualInterfaceInput) SetVirtualInterfaceId(v string) *DeleteVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

type DeleteVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The state of the virtual interface. The following are the possible values:
	//
	//    * confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * available: A virtual interface that is able to forward traffic.
	//
	//    * down: A virtual interface that is BGP down.
	//
	//    * deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * deleted: A virtual interface that cannot forward traffic.
	//
	//    * rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the Confirming state is deleted by
	//    the virtual interface owner, the virtual interface enters the Rejected
	//    state.
	//
	//    * unknown: The state of the virtual interface is not available.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *DeleteVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *DeleteVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

type DescribeConnectionLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the APN partner or service provider who establishes connectivity
	// on your behalf. If you specify this parameter, the LOA-CFA lists the provider
	// name alongside your company name as the requester of the cross connect.
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionLoaInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeConnectionLoaInput) SetConnectionId(v string) *DescribeConnectionLoaInput {
	s.ConnectionId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeConnectionLoaInput) SetLoaContentType(v string) *DescribeConnectionLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeConnectionLoaInput) SetProviderName(v string) *DescribeConnectionLoaInput {
	s.ProviderName = &v
	return s
}

type DescribeConnectionLoaOutput struct {
	_ struct{} `type:"structure"`

	// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).
	Loa *Loa `locationName:"loa" type:"structure"`
}

// String returns the string representation
func (s DescribeConnectionLoaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionLoaOutput) GoString() string {
	return s.String()
}

// SetLoa sets the Loa field's value.
func (s *DescribeConnectionLoaOutput) SetLoa(v *Loa) *DescribeConnectionLoaOutput {
	s.Loa = v
	return s
}

type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeConnectionsInput) SetConnectionId(v string) *DescribeConnectionsInput {
	s.ConnectionId = &v
	return s
}

type DescribeConnectionsOnInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConnectionsOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsOnInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionsOnInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionsOnInterconnectInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeConnectionsOnInterconnectInput) SetInterconnectId(v string) *DescribeConnectionsOnInterconnectInput {
	s.InterconnectId = &v
	return s
}

type DescribeDirectConnectGatewayAssociationProposalsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	AssociatedGatewayId *string `locationName:"associatedGatewayId" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the proposal.
	ProposalId *string `locationName:"proposalId" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationProposalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAssociationProposalsInput) GoString() string {
	return s.String()
}

// SetAssociatedGatewayId sets the AssociatedGatewayId field's value.
func (s *DescribeDirectConnectGatewayAssociationProposalsInput) SetAssociatedGatewayId(v string) *DescribeDirectConnectGatewayAssociationProposalsInput {
	s.AssociatedGatewayId = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DescribeDirectConnectGatewayAssociationProposalsInput) SetDirectConnectGatewayId(v string) *DescribeDirectConnectGatewayAssociationProposalsInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectConnectGatewayAssociationProposalsInput) SetMaxResults(v int64) *DescribeDirectConnectGatewayAssociationProposalsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAssociationProposalsInput) SetNextToken(v string) *DescribeDirectConnectGatewayAssociationProposalsInput {
	s.NextToken = &v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *DescribeDirectConnectGatewayAssociationProposalsInput) SetProposalId(v string) *DescribeDirectConnectGatewayAssociationProposalsInput {
	s.ProposalId = &v
	return s
}

type DescribeDirectConnectGatewayAssociationProposalsOutput struct {
	_ struct{} `type:"structure"`

	// Describes the Direct Connect gateway association proposals.
	DirectConnectGatewayAssociationProposals []*GatewayAssociationProposal `locationName:"directConnectGatewayAssociationProposals" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationProposalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAssociationProposalsOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociationProposals sets the DirectConnectGatewayAssociationProposals field's value.
func (s *DescribeDirectConnectGatewayAssociationProposalsOutput) SetDirectConnectGatewayAssociationProposals(v []*GatewayAssociationProposal) *DescribeDirectConnectGatewayAssociationProposalsOutput {
	s.DirectConnectGatewayAssociationProposals = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAssociationProposalsOutput) SetNextToken(v string) *DescribeDirectConnectGatewayAssociationProposalsOutput {
	s.NextToken = &v
	return s
}

type DescribeDirectConnectGatewayAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	AssociatedGatewayId *string `locationName:"associatedGatewayId" type:"string"`

	// The ID of the Direct Connect gateway association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous call to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAssociationsInput) GoString() string {
	return s.String()
}

// SetAssociatedGatewayId sets the AssociatedGatewayId field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetAssociatedGatewayId(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.AssociatedGatewayId = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetAssociationId(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.AssociationId = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetDirectConnectGatewayId(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetMaxResults(v int64) *DescribeDirectConnectGatewayAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetNextToken(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.NextToken = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *DescribeDirectConnectGatewayAssociationsInput) SetVirtualGatewayId(v string) *DescribeDirectConnectGatewayAssociationsInput {
	s.VirtualGatewayId = &v
	return s
}

type DescribeDirectConnectGatewayAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations.
	DirectConnectGatewayAssociations []*GatewayAssociation `locationName:"directConnectGatewayAssociations" type:"list"`

	// The token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAssociationsOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociations sets the DirectConnectGatewayAssociations field's value.
func (s *DescribeDirectConnectGatewayAssociationsOutput) SetDirectConnectGatewayAssociations(v []*GatewayAssociation) *DescribeDirectConnectGatewayAssociationsOutput {
	s.DirectConnectGatewayAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAssociationsOutput) SetNextToken(v string) *DescribeDirectConnectGatewayAssociationsOutput {
	s.NextToken = &v
	return s
}

type DescribeDirectConnectGatewayAttachmentsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous call to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsInput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetDirectConnectGatewayId(v string) *DescribeDirectConnectGatewayAttachmentsInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetMaxResults(v int64) *DescribeDirectConnectGatewayAttachmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetNextToken(v string) *DescribeDirectConnectGatewayAttachmentsInput {
	s.NextToken = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DescribeDirectConnectGatewayAttachmentsInput) SetVirtualInterfaceId(v string) *DescribeDirectConnectGatewayAttachmentsInput {
	s.VirtualInterfaceId = &v
	return s
}

type DescribeDirectConnectGatewayAttachmentsOutput struct {
	_ struct{} `type:"structure"`

	// The attachments.
	DirectConnectGatewayAttachments []*GatewayAttachment `locationName:"directConnectGatewayAttachments" type:"list"`

	// The token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewayAttachmentsOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAttachments sets the DirectConnectGatewayAttachments field's value.
func (s *DescribeDirectConnectGatewayAttachmentsOutput) SetDirectConnectGatewayAttachments(v []*GatewayAttachment) *DescribeDirectConnectGatewayAttachmentsOutput {
	s.DirectConnectGatewayAttachments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewayAttachmentsOutput) SetNextToken(v string) *DescribeDirectConnectGatewayAttachmentsOutput {
	s.NextToken = &v
	return s
}

type DescribeDirectConnectGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous call to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewaysInput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *DescribeDirectConnectGatewaysInput) SetDirectConnectGatewayId(v string) *DescribeDirectConnectGatewaysInput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectConnectGatewaysInput) SetMaxResults(v int64) *DescribeDirectConnectGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewaysInput) SetNextToken(v string) *DescribeDirectConnectGatewaysInput {
	s.NextToken = &v
	return s
}

type DescribeDirectConnectGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The Direct Connect gateways.
	DirectConnectGateways []*Gateway `locationName:"directConnectGateways" type:"list"`

	// The token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectConnectGatewaysOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGateways sets the DirectConnectGateways field's value.
func (s *DescribeDirectConnectGatewaysOutput) SetDirectConnectGateways(v []*Gateway) *DescribeDirectConnectGatewaysOutput {
	s.DirectConnectGateways = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectConnectGatewaysOutput) SetNextToken(v string) *DescribeDirectConnectGatewaysOutput {
	s.NextToken = &v
	return s
}

type DescribeHostedConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect or LAG.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHostedConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHostedConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHostedConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHostedConnectionsInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeHostedConnectionsInput) SetConnectionId(v string) *DescribeHostedConnectionsInput {
	s.ConnectionId = &v
	return s
}

type DescribeInterconnectLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the service provider who establishes connectivity on your behalf.
	// If you supply this parameter, the LOA-CFA lists the provider name alongside
	// your company name as the requester of the cross connect.
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeInterconnectLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInterconnectLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInterconnectLoaInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeInterconnectLoaInput) SetInterconnectId(v string) *DescribeInterconnectLoaInput {
	s.InterconnectId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeInterconnectLoaInput) SetLoaContentType(v string) *DescribeInterconnectLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeInterconnectLoaInput) SetProviderName(v string) *DescribeInterconnectLoaInput {
	s.ProviderName = &v
	return s
}

type DescribeInterconnectLoaOutput struct {
	_ struct{} `type:"structure"`

	// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).
	Loa *Loa `locationName:"loa" type:"structure"`
}

// String returns the string representation
func (s DescribeInterconnectLoaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectLoaOutput) GoString() string {
	return s.String()
}

// SetLoa sets the Loa field's value.
func (s *DescribeInterconnectLoaOutput) SetLoa(v *Loa) *DescribeInterconnectLoaOutput {
	s.Loa = v
	return s
}

type DescribeInterconnectsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	InterconnectId *string `locationName:"interconnectId" type:"string"`
}

// String returns the string representation
func (s DescribeInterconnectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsInput) GoString() string {
	return s.String()
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeInterconnectsInput) SetInterconnectId(v string) *DescribeInterconnectsInput {
	s.InterconnectId = &v
	return s
}

type DescribeInterconnectsOutput struct {
	_ struct{} `type:"structure"`

	// The interconnects.
	Interconnects []*Interconnect `locationName:"interconnects" type:"list"`
}

// String returns the string representation
func (s DescribeInterconnectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsOutput) GoString() string {
	return s.String()
}

// SetInterconnects sets the Interconnects field's value.
func (s *DescribeInterconnectsOutput) SetInterconnects(v []*Interconnect) *DescribeInterconnectsOutput {
	s.Interconnects = v
	return s
}

type DescribeLagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`
}

// String returns the string representation
func (s DescribeLagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLagsInput) GoString() string {
	return s.String()
}

// SetLagId sets the LagId field's value.
func (s *DescribeLagsInput) SetLagId(v string) *DescribeLagsInput {
	s.LagId = &v
	return s
}

type DescribeLagsOutput struct {
	_ struct{} `type:"structure"`

	// The LAGs.
	Lags []*Lag `locationName:"lags" type:"list"`
}

// String returns the string representation
func (s DescribeLagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLagsOutput) GoString() string {
	return s.String()
}

// SetLags sets the Lags field's value.
func (s *DescribeLagsOutput) SetLags(v []*Lag) *DescribeLagsOutput {
	s.Lags = v
	return s
}

type DescribeLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of a connection, LAG, or interconnect.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the service provider who establishes connectivity on your behalf.
	// If you specify this parameter, the LOA-CFA lists the provider name alongside
	// your company name as the requester of the cross connect.
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoaInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeLoaInput) SetConnectionId(v string) *DescribeLoaInput {
	s.ConnectionId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeLoaInput) SetLoaContentType(v string) *DescribeLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeLoaInput) SetProviderName(v string) *DescribeLoaInput {
	s.ProviderName = &v
	return s
}

type DescribeLocationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsInput) GoString() string {
	return s.String()
}

type DescribeLocationsOutput struct {
	_ struct{} `type:"structure"`

	// The locations.
	Locations []*Location `locationName:"locations" type:"list"`
}

// String returns the string representation
func (s DescribeLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsOutput) GoString() string {
	return s.String()
}

// SetLocations sets the Locations field's value.
func (s *DescribeLocationsOutput) SetLocations(v []*Location) *DescribeLocationsOutput {
	s.Locations = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the resources.
	//
	// ResourceArns is a required field
	ResourceArns []*string `locationName:"resourceArns" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArns sets the ResourceArns field's value.
func (s *DescribeTagsInput) SetResourceArns(v []*string) *DescribeTagsInput {
	s.ResourceArns = v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	ResourceTags []*ResourceTag `locationName:"resourceTags" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetResourceTags sets the ResourceTags field's value.
func (s *DescribeTagsOutput) SetResourceTags(v []*ResourceTag) *DescribeTagsOutput {
	s.ResourceTags = v
	return s
}

type DescribeVirtualGatewaysInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysInput) GoString() string {
	return s.String()
}

type DescribeVirtualGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The virtual private gateways.
	VirtualGateways []*VirtualGateway `locationName:"virtualGateways" type:"list"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysOutput) GoString() string {
	return s.String()
}

// SetVirtualGateways sets the VirtualGateways field's value.
func (s *DescribeVirtualGatewaysOutput) SetVirtualGateways(v []*VirtualGateway) *DescribeVirtualGatewaysOutput {
	s.VirtualGateways = v
	return s
}

type DescribeVirtualInterfacesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesInput) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeVirtualInterfacesInput) SetConnectionId(v string) *DescribeVirtualInterfacesInput {
	s.ConnectionId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DescribeVirtualInterfacesInput) SetVirtualInterfaceId(v string) *DescribeVirtualInterfacesInput {
	s.VirtualInterfaceId = &v
	return s
}

type DescribeVirtualInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// The virtual interfaces
	VirtualInterfaces []*VirtualInterface `locationName:"virtualInterfaces" type:"list"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaces sets the VirtualInterfaces field's value.
func (s *DescribeVirtualInterfacesOutput) SetVirtualInterfaces(v []*VirtualInterface) *DescribeVirtualInterfacesOutput {
	s.VirtualInterfaces = v
	return s
}

type DisassociateConnectionFromLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the LAG.
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateConnectionFromLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConnectionFromLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectionFromLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConnectionFromLagInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DisassociateConnectionFromLagInput) SetConnectionId(v string) *DisassociateConnectionFromLagInput {
	s.ConnectionId = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *DisassociateConnectionFromLagInput) SetLagId(v string) *DisassociateConnectionFromLagInput {
	s.LagId = &v
	return s
}

// Information about a Direct Connect gateway, which enables you to connect
// virtual interfaces and virtual private gateway or transit gateways.
type Gateway struct {
	_ struct{} `type:"structure"`

	// The autonomous system number (ASN) for the Amazon side of the connection.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The name of the Direct Connect gateway.
	DirectConnectGatewayName *string `locationName:"directConnectGatewayName" type:"string"`

	// The state of the Direct Connect gateway. The following are the possible values:
	//
	//    * pending: The initial state after calling CreateDirectConnectGateway.
	//
	//    * available: The Direct Connect gateway is ready for use.
	//
	//    * deleting: The initial state after calling DeleteDirectConnectGateway.
	//
	//    * deleted: The Direct Connect gateway is deleted and cannot pass traffic.
	DirectConnectGatewayState *string `locationName:"directConnectGatewayState" type:"string" enum:"GatewayState"`

	// The ID of the AWS account that owns the Direct Connect gateway.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The error message if the state of an object failed to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`
}

// String returns the string representation
func (s Gateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Gateway) GoString() string {
	return s.String()
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *Gateway) SetAmazonSideAsn(v int64) *Gateway {
	s.AmazonSideAsn = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *Gateway) SetDirectConnectGatewayId(v string) *Gateway {
	s.DirectConnectGatewayId = &v
	return s
}

// SetDirectConnectGatewayName sets the DirectConnectGatewayName field's value.
func (s *Gateway) SetDirectConnectGatewayName(v string) *Gateway {
	s.DirectConnectGatewayName = &v
	return s
}

// SetDirectConnectGatewayState sets the DirectConnectGatewayState field's value.
func (s *Gateway) SetDirectConnectGatewayState(v string) *Gateway {
	s.DirectConnectGatewayState = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Gateway) SetOwnerAccount(v string) *Gateway {
	s.OwnerAccount = &v
	return s
}

// SetStateChangeError sets the StateChangeError field's value.
func (s *Gateway) SetStateChangeError(v string) *Gateway {
	s.StateChangeError = &v
	return s
}

// Information about an association between a Direct Connect gateway and a virtual
// private gateway or transit gateway.
type GatewayAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway.
	AllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"allowedPrefixesToDirectConnectGateway" type:"list"`

	// Information about the associated gateway.
	AssociatedGateway *AssociatedGateway `locationName:"associatedGateway" type:"structure"`

	// The ID of the Direct Connect gateway association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The state of the association. The following are the possible values:
	//
	//    * associating: The initial state after calling CreateDirectConnectGatewayAssociation.
	//
	//    * associated: The Direct Connect gateway and virtual private gateway or
	//    transit gateway are successfully associated and ready to pass traffic.
	//
	//    * disassociating: The initial state after calling DeleteDirectConnectGatewayAssociation.
	//
	//    * disassociated: The virtual private gateway or transit gateway is disassociated
	//    from the Direct Connect gateway. Traffic flow between the Direct Connect
	//    gateway and virtual private gateway or transit gateway is stopped.
	AssociationState *string `locationName:"associationState" type:"string" enum:"GatewayAssociationState"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The ID of the AWS account that owns the associated gateway.
	DirectConnectGatewayOwnerAccount *string `locationName:"directConnectGatewayOwnerAccount" type:"string"`

	// The error message if the state of an object failed to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`

	// The ID of the virtual private gateway. Applies only to private virtual interfaces.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the AWS account that owns the virtual private gateway.
	VirtualGatewayOwnerAccount *string `locationName:"virtualGatewayOwnerAccount" type:"string"`

	// The AWS Region where the virtual private gateway is located.
	VirtualGatewayRegion *string `locationName:"virtualGatewayRegion" deprecated:"true" type:"string"`
}

// String returns the string representation
func (s GatewayAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayAssociation) GoString() string {
	return s.String()
}

// SetAllowedPrefixesToDirectConnectGateway sets the AllowedPrefixesToDirectConnectGateway field's value.
func (s *GatewayAssociation) SetAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *GatewayAssociation {
	s.AllowedPrefixesToDirectConnectGateway = v
	return s
}

// SetAssociatedGateway sets the AssociatedGateway field's value.
func (s *GatewayAssociation) SetAssociatedGateway(v *AssociatedGateway) *GatewayAssociation {
	s.AssociatedGateway = v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *GatewayAssociation) SetAssociationId(v string) *GatewayAssociation {
	s.AssociationId = &v
	return s
}

// SetAssociationState sets the AssociationState field's value.
func (s *GatewayAssociation) SetAssociationState(v string) *GatewayAssociation {
	s.AssociationState = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *GatewayAssociation) SetDirectConnectGatewayId(v string) *GatewayAssociation {
	s.DirectConnectGatewayId = &v
	return s
}

// SetDirectConnectGatewayOwnerAccount sets the DirectConnectGatewayOwnerAccount field's value.
func (s *GatewayAssociation) SetDirectConnectGatewayOwnerAccount(v string) *GatewayAssociation {
	s.DirectConnectGatewayOwnerAccount = &v
	return s
}

// SetStateChangeError sets the StateChangeError field's value.
func (s *GatewayAssociation) SetStateChangeError(v string) *GatewayAssociation {
	s.StateChangeError = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *GatewayAssociation) SetVirtualGatewayId(v string) *GatewayAssociation {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualGatewayOwnerAccount sets the VirtualGatewayOwnerAccount field's value.
func (s *GatewayAssociation) SetVirtualGatewayOwnerAccount(v string) *GatewayAssociation {
	s.VirtualGatewayOwnerAccount = &v
	return s
}

// SetVirtualGatewayRegion sets the VirtualGatewayRegion field's value.
func (s *GatewayAssociation) SetVirtualGatewayRegion(v string) *GatewayAssociation {
	s.VirtualGatewayRegion = &v
	return s
}

// Information about the proposal request to attach a virtual private gateway
// to a Direct Connect gateway.
type GatewayAssociationProposal struct {
	_ struct{} `type:"structure"`

	// Information about the associated gateway.
	AssociatedGateway *AssociatedGateway `locationName:"associatedGateway" type:"structure"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The ID of the AWS account that owns the Direct Connect gateway.
	DirectConnectGatewayOwnerAccount *string `locationName:"directConnectGatewayOwnerAccount" type:"string"`

	// The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
	ExistingAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"existingAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the association proposal.
	ProposalId *string `locationName:"proposalId" type:"string"`

	// The state of the proposal. The following are possible values:
	//
	//    * accepted: The proposal has been accepted. The Direct Connect gateway
	//    association is available to use in this state.
	//
	//    * deleted: The proposal has been deleted by the owner that made the proposal.
	//    The Direct Connect gateway association cannot be used in this state.
	//
	//    * requested: The proposal has been requested. The Direct Connect gateway
	//    association cannot be used in this state.
	ProposalState *string `locationName:"proposalState" type:"string" enum:"GatewayAssociationProposalState"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway.
	RequestedAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"requestedAllowedPrefixesToDirectConnectGateway" type:"list"`
}

// String returns the string representation
func (s GatewayAssociationProposal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayAssociationProposal) GoString() string {
	return s.String()
}

// SetAssociatedGateway sets the AssociatedGateway field's value.
func (s *GatewayAssociationProposal) SetAssociatedGateway(v *AssociatedGateway) *GatewayAssociationProposal {
	s.AssociatedGateway = v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *GatewayAssociationProposal) SetDirectConnectGatewayId(v string) *GatewayAssociationProposal {
	s.DirectConnectGatewayId = &v
	return s
}

// SetDirectConnectGatewayOwnerAccount sets the DirectConnectGatewayOwnerAccount field's value.
func (s *GatewayAssociationProposal) SetDirectConnectGatewayOwnerAccount(v string) *GatewayAssociationProposal {
	s.DirectConnectGatewayOwnerAccount = &v
	return s
}

// SetExistingAllowedPrefixesToDirectConnectGateway sets the ExistingAllowedPrefixesToDirectConnectGateway field's value.
func (s *GatewayAssociationProposal) SetExistingAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *GatewayAssociationProposal {
	s.ExistingAllowedPrefixesToDirectConnectGateway = v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *GatewayAssociationProposal) SetProposalId(v string) *GatewayAssociationProposal {
	s.ProposalId = &v
	return s
}

// SetProposalState sets the ProposalState field's value.
func (s *GatewayAssociationProposal) SetProposalState(v string) *GatewayAssociationProposal {
	s.ProposalState = &v
	return s
}

// SetRequestedAllowedPrefixesToDirectConnectGateway sets the RequestedAllowedPrefixesToDirectConnectGateway field's value.
func (s *GatewayAssociationProposal) SetRequestedAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *GatewayAssociationProposal {
	s.RequestedAllowedPrefixesToDirectConnectGateway = v
	return s
}

// Information about an attachment between a Direct Connect gateway and a virtual
// interface.
type GatewayAttachment struct {
	_ struct{} `type:"structure"`

	// The state of the attachment. The following are the possible values:
	//
	//    * attaching: The initial state after a virtual interface is created using
	//    the Direct Connect gateway.
	//
	//    * attached: The Direct Connect gateway and virtual interface are attached
	//    and ready to pass traffic.
	//
	//    * detaching: The initial state after calling DeleteVirtualInterface.
	//
	//    * detached: The virtual interface is detached from the Direct Connect
	//    gateway. Traffic flow between the Direct Connect gateway and virtual interface
	//    is stopped.
	AttachmentState *string `locationName:"attachmentState" type:"string" enum:"GatewayAttachmentState"`

	// The type of attachment.
	AttachmentType *string `locationName:"attachmentType" type:"string" enum:"GatewayAttachmentType"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The error message if the state of an object failed to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The ID of the AWS account that owns the virtual interface.
	VirtualInterfaceOwnerAccount *string `locationName:"virtualInterfaceOwnerAccount" type:"string"`

	// The AWS Region where the virtual interface is located.
	VirtualInterfaceRegion *string `locationName:"virtualInterfaceRegion" type:"string"`
}

// String returns the string representation
func (s GatewayAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayAttachment) GoString() string {
	return s.String()
}

// SetAttachmentState sets the AttachmentState field's value.
func (s *GatewayAttachment) SetAttachmentState(v string) *GatewayAttachment {
	s.AttachmentState = &v
	return s
}

// SetAttachmentType sets the AttachmentType field's value.
func (s *GatewayAttachment) SetAttachmentType(v string) *GatewayAttachment {
	s.AttachmentType = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *GatewayAttachment) SetDirectConnectGatewayId(v string) *GatewayAttachment {
	s.DirectConnectGatewayId = &v
	return s
}

// SetStateChangeError sets the StateChangeError field's value.
func (s *GatewayAttachment) SetStateChangeError(v string) *GatewayAttachment {
	s.StateChangeError = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *GatewayAttachment) SetVirtualInterfaceId(v string) *GatewayAttachment {
	s.VirtualInterfaceId = &v
	return s
}

// SetVirtualInterfaceOwnerAccount sets the VirtualInterfaceOwnerAccount field's value.
func (s *GatewayAttachment) SetVirtualInterfaceOwnerAccount(v string) *GatewayAttachment {
	s.VirtualInterfaceOwnerAccount = &v
	return s
}

// SetVirtualInterfaceRegion sets the VirtualInterfaceRegion field's value.
func (s *GatewayAttachment) SetVirtualInterfaceRegion(v string) *GatewayAttachment {
	s.VirtualInterfaceRegion = &v
	return s
}

// Information about an interconnect.
type Interconnect struct {
	_ struct{} `type:"structure"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The bandwidth of the connection.
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// Indicates whether the interconnect supports a secondary BGP in the same address
	// family (IPv4/IPv6).
	HasLogicalRedundancy *string `locationName:"hasLogicalRedundancy" type:"string" enum:"HasLogicalRedundancy"`

	// The ID of the interconnect.
	InterconnectId *string `locationName:"interconnectId" type:"string"`

	// The name of the interconnect.
	InterconnectName *string `locationName:"interconnectName" type:"string"`

	// The state of the interconnect. The following are the possible values:
	//
	//    * requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * pending: The interconnect is approved, and is being initialized.
	//
	//    * available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The interconnect is being deleted.
	//
	//    * deleted: The interconnect is deleted.
	//
	//    * unknown: The state of the interconnect is not available.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeLoa for this connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The name of the service provider associated with the interconnect.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the interconnect.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s Interconnect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Interconnect) GoString() string {
	return s.String()
}

// SetAwsDevice sets the AwsDevice field's value.
func (s *Interconnect) SetAwsDevice(v string) *Interconnect {
	s.AwsDevice = &v
	return s
}

// SetAwsDeviceV2 sets the AwsDeviceV2 field's value.
func (s *Interconnect) SetAwsDeviceV2(v string) *Interconnect {
	s.AwsDeviceV2 = &v
	return s
}

// SetBandwidth sets the Bandwidth field's value.
func (s *Interconnect) SetBandwidth(v string) *Interconnect {
	s.Bandwidth = &v
	return s
}

// SetHasLogicalRedundancy sets the HasLogicalRedundancy field's value.
func (s *Interconnect) SetHasLogicalRedundancy(v string) *Interconnect {
	s.HasLogicalRedundancy = &v
	return s
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *Interconnect) SetInterconnectId(v string) *Interconnect {
	s.InterconnectId = &v
	return s
}

// SetInterconnectName sets the InterconnectName field's value.
func (s *Interconnect) SetInterconnectName(v string) *Interconnect {
	s.InterconnectName = &v
	return s
}

// SetInterconnectState sets the InterconnectState field's value.
func (s *Interconnect) SetInterconnectState(v string) *Interconnect {
	s.InterconnectState = &v
	return s
}

// SetJumboFrameCapable sets the JumboFrameCapable field's value.
func (s *Interconnect) SetJumboFrameCapable(v bool) *Interconnect {
	s.JumboFrameCapable = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *Interconnect) SetLagId(v string) *Interconnect {
	s.LagId = &v
	return s
}

// SetLoaIssueTime sets the LoaIssueTime field's value.
func (s *Interconnect) SetLoaIssueTime(v time.Time) *Interconnect {
	s.LoaIssueTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Interconnect) SetLocation(v string) *Interconnect {
	s.Location = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *Interconnect) SetProviderName(v string) *Interconnect {
	s.ProviderName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Interconnect) SetRegion(v string) *Interconnect {
	s.Region = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Interconnect) SetTags(v []*Tag) *Interconnect {
	s.Tags = v
	return s
}

// Information about a link aggregation group (LAG).
type Lag struct {
	_ struct{} `type:"structure"`

	// Indicates whether the LAG can host other connections.
	AllowsHostedConnections *bool `locationName:"allowsHostedConnections" type:"boolean"`

	// The AWS Direct Connect endpoint that hosts the LAG.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The AWS Direct Connect endpoint that hosts the LAG.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The connections bundled by the LAG.
	Connections []*Connection `locationName:"connections" type:"list"`

	// The individual bandwidth of the physical connections bundled by the LAG.
	// The possible values are 1Gbps and 10Gbps.
	ConnectionsBandwidth *string `locationName:"connectionsBandwidth" type:"string"`

	// Indicates whether the LAG supports a secondary BGP peer in the same address
	// family (IPv4/IPv6).
	HasLogicalRedundancy *string `locationName:"hasLogicalRedundancy" type:"string" enum:"HasLogicalRedundancy"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The name of the LAG.
	LagName *string `locationName:"lagName" type:"string"`

	// The state of the LAG. The following are the possible values:
	//
	//    * requested: The initial state of a LAG. The LAG stays in the requested
	//    state until the Letter of Authorization (LOA) is available.
	//
	//    * pending: The LAG has been approved and is being initialized.
	//
	//    * available: The network link is established and the LAG is ready for
	//    use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The LAG is being deleted.
	//
	//    * deleted: The LAG is deleted.
	//
	//    * unknown: The state of the LAG is not available.
	LagState *string `locationName:"lagState" type:"string" enum:"LagState"`

	// The location of the LAG.
	Location *string `locationName:"location" type:"string"`

	// The minimum number of physical connections that must be operational for the
	// LAG itself to be operational.
	MinimumLinks *int64 `locationName:"minimumLinks" type:"integer"`

	// The number of physical connections bundled by the LAG, up to a maximum of
	// 10.
	NumberOfConnections *int64 `locationName:"numberOfConnections" type:"integer"`

	// The ID of the AWS account that owns the LAG.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the service provider associated with the LAG.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the LAG.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s Lag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Lag) GoString() string {
	return s.String()
}

// SetAllowsHostedConnections sets the AllowsHostedConnections field's value.
func (s *Lag) SetAllowsHostedConnections(v bool) *Lag {
	s.AllowsHostedConnections = &v
	return s
}

// SetAwsDevice sets the AwsDevice field's value.
func (s *Lag) SetAwsDevice(v string) *Lag {
	s.AwsDevice = &v
	return s
}

// SetAwsDeviceV2 sets the AwsDeviceV2 field's value.
func (s *Lag) SetAwsDeviceV2(v string) *Lag {
	s.AwsDeviceV2 = &v
	return s
}

// SetConnections sets the Connections field's value.
func (s *Lag) SetConnections(v []*Connection) *Lag {
	s.Connections = v
	return s
}

// SetConnectionsBandwidth sets the ConnectionsBandwidth field's value.
func (s *Lag) SetConnectionsBandwidth(v string) *Lag {
	s.ConnectionsBandwidth = &v
	return s
}

// SetHasLogicalRedundancy sets the HasLogicalRedundancy field's value.
func (s *Lag) SetHasLogicalRedundancy(v string) *Lag {
	s.HasLogicalRedundancy = &v
	return s
}

// SetJumboFrameCapable sets the JumboFrameCapable field's value.
func (s *Lag) SetJumboFrameCapable(v bool) *Lag {
	s.JumboFrameCapable = &v
	return s
}

// SetLagId sets the LagId field's value.
func (s *Lag) SetLagId(v string) *Lag {
	s.LagId = &v
	return s
}

// SetLagName sets the LagName field's value.
func (s *Lag) SetLagName(v string) *Lag {
	s.LagName = &v
	return s
}

// SetLagState sets the LagState field's value.
func (s *Lag) SetLagState(v string) *Lag {
	s.LagState = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Lag) SetLocation(v string) *Lag {
	s.Location = &v
	return s
}

// SetMinimumLinks sets the MinimumLinks field's value.
func (s *Lag) SetMinimumLinks(v int64) *Lag {
	s.MinimumLinks = &v
	return s
}

// SetNumberOfConnections sets the NumberOfConnections field's value.
func (s *Lag) SetNumberOfConnections(v int64) *Lag {
	s.NumberOfConnections = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Lag) SetOwnerAccount(v string) *Lag {
	s.OwnerAccount = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *Lag) SetProviderName(v string) *Lag {
	s.ProviderName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Lag) SetRegion(v string) *Lag {
	s.Region = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Lag) SetTags(v []*Tag) *Lag {
	s.Tags = v
	return s
}

// Information about a Letter of Authorization - Connecting Facility Assignment
// (LOA-CFA) for a connection.
type Loa struct {
	_ struct{} `type:"structure"`

	// The binary contents of the LOA-CFA document.
	//
	// LoaContent is automatically base64 encoded/decoded by the SDK.
	LoaContent []byte `locationName:"loaContent" type:"blob"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`
}

// String returns the string representation
func (s Loa) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Loa) GoString() string {
	return s.String()
}

// SetLoaContent sets the LoaContent field's value.
func (s *Loa) SetLoaContent(v []byte) *Loa {
	s.LoaContent = v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *Loa) SetLoaContentType(v string) *Loa {
	s.LoaContentType = &v
	return s
}

// Information about an AWS Direct Connect location.
type Location struct {
	_ struct{} `type:"structure"`

	// The available port speeds for the location.
	AvailablePortSpeeds []*string `locationName:"availablePortSpeeds" type:"list"`

	// The name of the service provider for the location.
	AvailableProviders []*string `locationName:"availableProviders" type:"list"`

	// The code for the location.
	LocationCode *string `locationName:"locationCode" type:"string"`

	// The name of the location. This includes the name of the colocation partner
	// and the physical site of the building.
	LocationName *string `locationName:"locationName" type:"string"`

	// The AWS Region for the location.
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// SetAvailablePortSpeeds sets the AvailablePortSpeeds field's value.
func (s *Location) SetAvailablePortSpeeds(v []*string) *Location {
	s.AvailablePortSpeeds = v
	return s
}

// SetAvailableProviders sets the AvailableProviders field's value.
func (s *Location) SetAvailableProviders(v []*string) *Location {
	s.AvailableProviders = v
	return s
}

// SetLocationCode sets the LocationCode field's value.
func (s *Location) SetLocationCode(v string) *Location {
	s.LocationCode = &v
	return s
}

// SetLocationName sets the LocationName field's value.
func (s *Location) SetLocationName(v string) *Location {
	s.LocationName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Location) SetRegion(v string) *Location {
	s.Region = &v
	return s
}

// Information about a new BGP peer.
type NewBGPPeer struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s NewBGPPeer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewBGPPeer) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewBGPPeer) SetAddressFamily(v string) *NewBGPPeer {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewBGPPeer) SetAmazonAddress(v string) *NewBGPPeer {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewBGPPeer) SetAsn(v int64) *NewBGPPeer {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewBGPPeer) SetAuthKey(v string) *NewBGPPeer {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewBGPPeer) SetCustomerAddress(v string) *NewBGPPeer {
	s.CustomerAddress = &v
	return s
}

// Information about a private virtual interface.
type NewPrivateVirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the private virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPrivateVirtualInterface"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPrivateVirtualInterface) SetAddressFamily(v string) *NewPrivateVirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPrivateVirtualInterface) SetAmazonAddress(v string) *NewPrivateVirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPrivateVirtualInterface) SetAsn(v int64) *NewPrivateVirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPrivateVirtualInterface) SetAuthKey(v string) *NewPrivateVirtualInterface {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPrivateVirtualInterface) SetCustomerAddress(v string) *NewPrivateVirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *NewPrivateVirtualInterface) SetDirectConnectGatewayId(v string) *NewPrivateVirtualInterface {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMtu sets the Mtu field's value.
func (s *NewPrivateVirtualInterface) SetMtu(v int64) *NewPrivateVirtualInterface {
	s.Mtu = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *NewPrivateVirtualInterface) SetTags(v []*Tag) *NewPrivateVirtualInterface {
	s.Tags = v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *NewPrivateVirtualInterface) SetVirtualGatewayId(v string) *NewPrivateVirtualInterface {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPrivateVirtualInterface) SetVirtualInterfaceName(v string) *NewPrivateVirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPrivateVirtualInterface) SetVlan(v int64) *NewPrivateVirtualInterface {
	s.Vlan = &v
	return s
}

// Information about a private virtual interface to be provisioned on a connection.
type NewPrivateVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the private virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterfaceAllocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPrivateVirtualInterfaceAllocation"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAddressFamily(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAmazonAddress(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAsn(v int64) *NewPrivateVirtualInterfaceAllocation {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAuthKey(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetCustomerAddress(v string) *NewPrivateVirtualInterfaceAllocation {
	s.CustomerAddress = &v
	return s
}

// SetMtu sets the Mtu field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetMtu(v int64) *NewPrivateVirtualInterfaceAllocation {
	s.Mtu = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetTags(v []*Tag) *NewPrivateVirtualInterfaceAllocation {
	s.Tags = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetVirtualInterfaceName(v string) *NewPrivateVirtualInterfaceAllocation {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetVlan(v int64) *NewPrivateVirtualInterfaceAllocation {
	s.Vlan = &v
	return s
}

// Information about a public virtual interface.
type NewPublicVirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The routes to be advertised to the AWS network in this Region. Applies to
	// public virtual interfaces.
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The tags associated with the public virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPublicVirtualInterface"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPublicVirtualInterface) SetAddressFamily(v string) *NewPublicVirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPublicVirtualInterface) SetAmazonAddress(v string) *NewPublicVirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPublicVirtualInterface) SetAsn(v int64) *NewPublicVirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPublicVirtualInterface) SetAuthKey(v string) *NewPublicVirtualInterface {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPublicVirtualInterface) SetCustomerAddress(v string) *NewPublicVirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *NewPublicVirtualInterface) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *NewPublicVirtualInterface {
	s.RouteFilterPrefixes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *NewPublicVirtualInterface) SetTags(v []*Tag) *NewPublicVirtualInterface {
	s.Tags = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPublicVirtualInterface) SetVirtualInterfaceName(v string) *NewPublicVirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPublicVirtualInterface) SetVlan(v int64) *NewPublicVirtualInterface {
	s.Vlan = &v
	return s
}

// Information about a public virtual interface to be provisioned on a connection.
type NewPublicVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The routes to be advertised to the AWS network in this Region. Applies to
	// public virtual interfaces.
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The tags associated with the public virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterfaceAllocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPublicVirtualInterfaceAllocation"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAddressFamily(v string) *NewPublicVirtualInterfaceAllocation {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAmazonAddress(v string) *NewPublicVirtualInterfaceAllocation {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAsn(v int64) *NewPublicVirtualInterfaceAllocation {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAuthKey(v string) *NewPublicVirtualInterfaceAllocation {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetCustomerAddress(v string) *NewPublicVirtualInterfaceAllocation {
	s.CustomerAddress = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *NewPublicVirtualInterfaceAllocation {
	s.RouteFilterPrefixes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetTags(v []*Tag) *NewPublicVirtualInterfaceAllocation {
	s.Tags = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetVirtualInterfaceName(v string) *NewPublicVirtualInterfaceAllocation {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetVlan(v int64) *NewPublicVirtualInterfaceAllocation {
	s.Vlan = &v
	return s
}

// Information about a transit virtual interface.
type NewTransitVirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the transitive virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s NewTransitVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewTransitVirtualInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewTransitVirtualInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewTransitVirtualInterface"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewTransitVirtualInterface) SetAddressFamily(v string) *NewTransitVirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewTransitVirtualInterface) SetAmazonAddress(v string) *NewTransitVirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewTransitVirtualInterface) SetAsn(v int64) *NewTransitVirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewTransitVirtualInterface) SetAuthKey(v string) *NewTransitVirtualInterface {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewTransitVirtualInterface) SetCustomerAddress(v string) *NewTransitVirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *NewTransitVirtualInterface) SetDirectConnectGatewayId(v string) *NewTransitVirtualInterface {
	s.DirectConnectGatewayId = &v
	return s
}

// SetMtu sets the Mtu field's value.
func (s *NewTransitVirtualInterface) SetMtu(v int64) *NewTransitVirtualInterface {
	s.Mtu = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *NewTransitVirtualInterface) SetTags(v []*Tag) *NewTransitVirtualInterface {
	s.Tags = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewTransitVirtualInterface) SetVirtualInterfaceName(v string) *NewTransitVirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewTransitVirtualInterface) SetVlan(v int64) *NewTransitVirtualInterface {
	s.Vlan = &v
	return s
}

// Information about a transit virtual interface to be provisioned on a connection.
type NewTransitVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the transitive virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s NewTransitVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewTransitVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewTransitVirtualInterfaceAllocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewTransitVirtualInterfaceAllocation"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetAddressFamily(v string) *NewTransitVirtualInterfaceAllocation {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetAmazonAddress(v string) *NewTransitVirtualInterfaceAllocation {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetAsn(v int64) *NewTransitVirtualInterfaceAllocation {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetAuthKey(v string) *NewTransitVirtualInterfaceAllocation {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetCustomerAddress(v string) *NewTransitVirtualInterfaceAllocation {
	s.CustomerAddress = &v
	return s
}

// SetMtu sets the Mtu field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetMtu(v int64) *NewTransitVirtualInterfaceAllocation {
	s.Mtu = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetTags(v []*Tag) *NewTransitVirtualInterfaceAllocation {
	s.Tags = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetVirtualInterfaceName(v string) *NewTransitVirtualInterfaceAllocation {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewTransitVirtualInterfaceAllocation) SetVlan(v int64) *NewTransitVirtualInterfaceAllocation {
	s.Vlan = &v
	return s
}

// Information about a tag associated with an AWS Direct Connect resource.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The tags.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTag) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceTag) SetResourceArn(v string) *ResourceTag {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceTag) SetTags(v []*Tag) *ResourceTag {
	s.Tags = v
	return s
}

// Information about a route filter prefix that a customer can advertise through
// Border Gateway Protocol (BGP) over a public virtual interface.
type RouteFilterPrefix struct {
	_ struct{} `type:"structure"`

	// The CIDR block for the advertised route. Separate multiple routes using commas.
	// An IPv6 CIDR must use /64 or shorter.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s RouteFilterPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteFilterPrefix) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *RouteFilterPrefix) SetCidr(v string) *RouteFilterPrefix {
	s.Cidr = &v
	return s
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDirectConnectGatewayAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway.
	AddAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"addAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the Direct Connect gateway association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
	RemoveAllowedPrefixesToDirectConnectGateway []*RouteFilterPrefix `locationName:"removeAllowedPrefixesToDirectConnectGateway" type:"list"`
}

// String returns the string representation
func (s UpdateDirectConnectGatewayAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDirectConnectGatewayAssociationInput) GoString() string {
	return s.String()
}

// SetAddAllowedPrefixesToDirectConnectGateway sets the AddAllowedPrefixesToDirectConnectGateway field's value.
func (s *UpdateDirectConnectGatewayAssociationInput) SetAddAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *UpdateDirectConnectGatewayAssociationInput {
	s.AddAllowedPrefixesToDirectConnectGateway = v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *UpdateDirectConnectGatewayAssociationInput) SetAssociationId(v string) *UpdateDirectConnectGatewayAssociationInput {
	s.AssociationId = &v
	return s
}

// SetRemoveAllowedPrefixesToDirectConnectGateway sets the RemoveAllowedPrefixesToDirectConnectGateway field's value.
func (s *UpdateDirectConnectGatewayAssociationInput) SetRemoveAllowedPrefixesToDirectConnectGateway(v []*RouteFilterPrefix) *UpdateDirectConnectGatewayAssociationInput {
	s.RemoveAllowedPrefixesToDirectConnectGateway = v
	return s
}

type UpdateDirectConnectGatewayAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about an association between a Direct Connect gateway and a virtual
	// private gateway or transit gateway.
	DirectConnectGatewayAssociation *GatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s UpdateDirectConnectGatewayAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDirectConnectGatewayAssociationOutput) GoString() string {
	return s.String()
}

// SetDirectConnectGatewayAssociation sets the DirectConnectGatewayAssociation field's value.
func (s *UpdateDirectConnectGatewayAssociationOutput) SetDirectConnectGatewayAssociation(v *GatewayAssociation) *UpdateDirectConnectGatewayAssociationOutput {
	s.DirectConnectGatewayAssociation = v
	return s
}

type UpdateLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG.
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`

	// The name of the LAG.
	LagName *string `locationName:"lagName" type:"string"`

	// The minimum number of physical connections that must be operational for the
	// LAG itself to be operational.
	MinimumLinks *int64 `locationName:"minimumLinks" type:"integer"`
}

// String returns the string representation
func (s UpdateLagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLagInput"}
	if s.LagId == nil {
		invalidParams.Add(request.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLagId sets the LagId field's value.
func (s *UpdateLagInput) SetLagId(v string) *UpdateLagInput {
	s.LagId = &v
	return s
}

// SetLagName sets the LagName field's value.
func (s *UpdateLagInput) SetLagName(v string) *UpdateLagInput {
	s.LagName = &v
	return s
}

// SetMinimumLinks sets the MinimumLinks field's value.
func (s *UpdateLagInput) SetMinimumLinks(v int64) *UpdateLagInput {
	s.MinimumLinks = &v
	return s
}

type UpdateVirtualInterfaceAttributesInput struct {
	_ struct{} `type:"structure"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The ID of the virtual private interface.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualInterfaceAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualInterfaceAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualInterfaceAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualInterfaceAttributesInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMtu sets the Mtu field's value.
func (s *UpdateVirtualInterfaceAttributesInput) SetMtu(v int64) *UpdateVirtualInterfaceAttributesInput {
	s.Mtu = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *UpdateVirtualInterfaceAttributesInput) SetVirtualInterfaceId(v string) *UpdateVirtualInterfaceAttributesInput {
	s.VirtualInterfaceId = &v
	return s
}

// Information about a virtual interface.
type UpdateVirtualInterfaceAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system number (ASN) for the Amazon side of the connection.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The Direct Connect endpoint on which the virtual interface terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The BGP peers configured on this virtual interface.
	BgpPeers []*BGPPeer `locationName:"bgpPeers" type:"list"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The customer router configuration.
	CustomerRouterConfig *string `locationName:"customerRouterConfig" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The ID of the AWS account that owns the virtual interface.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The AWS Region where the virtual interface is located.
	Region *string `locationName:"region" type:"string"`

	// The routes to be advertised to the AWS network in this Region. Applies to
	// public virtual interfaces.
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The tags associated with the virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the virtual private gateway. Applies only to private virtual interfaces.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The name of the virtual interface assigned by the customer network.
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// The state of the virtual interface. The following are the possible values:
	//
	//    * confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * available: A virtual interface that is able to forward traffic.
	//
	//    * down: A virtual interface that is BGP down.
	//
	//    * deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * deleted: A virtual interface that cannot forward traffic.
	//
	//    * rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the Confirming state is deleted by
	//    the virtual interface owner, the virtual interface enters the Rejected
	//    state.
	//
	//    * unknown: The state of the virtual interface is not available.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	// The type of virtual interface. The possible values are private and public.
	VirtualInterfaceType *string `locationName:"virtualInterfaceType" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s UpdateVirtualInterfaceAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualInterfaceAttributesOutput) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetAddressFamily(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetAmazonAddress(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.AmazonAddress = &v
	return s
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetAmazonSideAsn(v int64) *UpdateVirtualInterfaceAttributesOutput {
	s.AmazonSideAsn = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetAsn(v int64) *UpdateVirtualInterfaceAttributesOutput {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetAuthKey(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.AuthKey = &v
	return s
}

// SetAwsDeviceV2 sets the AwsDeviceV2 field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetAwsDeviceV2(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.AwsDeviceV2 = &v
	return s
}

// SetBgpPeers sets the BgpPeers field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetBgpPeers(v []*BGPPeer) *UpdateVirtualInterfaceAttributesOutput {
	s.BgpPeers = v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetConnectionId(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.ConnectionId = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetCustomerAddress(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.CustomerAddress = &v
	return s
}

// SetCustomerRouterConfig sets the CustomerRouterConfig field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetCustomerRouterConfig(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.CustomerRouterConfig = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetDirectConnectGatewayId(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.DirectConnectGatewayId = &v
	return s
}

// SetJumboFrameCapable sets the JumboFrameCapable field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetJumboFrameCapable(v bool) *UpdateVirtualInterfaceAttributesOutput {
	s.JumboFrameCapable = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetLocation(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.Location = &v
	return s
}

// SetMtu sets the Mtu field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetMtu(v int64) *UpdateVirtualInterfaceAttributesOutput {
	s.Mtu = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetOwnerAccount(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.OwnerAccount = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetRegion(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.Region = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *UpdateVirtualInterfaceAttributesOutput {
	s.RouteFilterPrefixes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetTags(v []*Tag) *UpdateVirtualInterfaceAttributesOutput {
	s.Tags = v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetVirtualGatewayId(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetVirtualInterfaceId(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.VirtualInterfaceId = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetVirtualInterfaceName(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.VirtualInterfaceName = &v
	return s
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetVirtualInterfaceState(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.VirtualInterfaceState = &v
	return s
}

// SetVirtualInterfaceType sets the VirtualInterfaceType field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetVirtualInterfaceType(v string) *UpdateVirtualInterfaceAttributesOutput {
	s.VirtualInterfaceType = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *UpdateVirtualInterfaceAttributesOutput) SetVlan(v int64) *UpdateVirtualInterfaceAttributesOutput {
	s.Vlan = &v
	return s
}

// Information about a virtual private gateway for a private virtual interface.
type VirtualGateway struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The state of the virtual private gateway. The following are the possible
	// values:
	//
	//    * pending: Initial state after creating the virtual private gateway.
	//
	//    * available: Ready for use by a private virtual interface.
	//
	//    * deleting: Initial state after deleting the virtual private gateway.
	//
	//    * deleted: The virtual private gateway is deleted. The private virtual
	//    interface is unable to send traffic over this gateway.
	VirtualGatewayState *string `locationName:"virtualGatewayState" type:"string"`
}

// String returns the string representation
func (s VirtualGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualGateway) GoString() string {
	return s.String()
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *VirtualGateway) SetVirtualGatewayId(v string) *VirtualGateway {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualGatewayState sets the VirtualGatewayState field's value.
func (s *VirtualGateway) SetVirtualGatewayState(v string) *VirtualGateway {
	s.VirtualGatewayState = &v
	return s
}

// Information about a virtual interface.
type VirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system number (ASN) for the Amazon side of the connection.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The Direct Connect endpoint on which the virtual interface terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The BGP peers configured on this virtual interface.
	BgpPeers []*BGPPeer `locationName:"bgpPeers" type:"list"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The customer router configuration.
	CustomerRouterConfig *string `locationName:"customerRouterConfig" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The ID of the AWS account that owns the virtual interface.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The AWS Region where the virtual interface is located.
	Region *string `locationName:"region" type:"string"`

	// The routes to be advertised to the AWS network in this Region. Applies to
	// public virtual interfaces.
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The tags associated with the virtual interface.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the virtual private gateway. Applies only to private virtual interfaces.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The name of the virtual interface assigned by the customer network.
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// The state of the virtual interface. The following are the possible values:
	//
	//    * confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * available: A virtual interface that is able to forward traffic.
	//
	//    * down: A virtual interface that is BGP down.
	//
	//    * deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * deleted: A virtual interface that cannot forward traffic.
	//
	//    * rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the Confirming state is deleted by
	//    the virtual interface owner, the virtual interface enters the Rejected
	//    state.
	//
	//    * unknown: The state of the virtual interface is not available.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	// The type of virtual interface. The possible values are private and public.
	VirtualInterfaceType *string `locationName:"virtualInterfaceType" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s VirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualInterface) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *VirtualInterface) SetAddressFamily(v string) *VirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *VirtualInterface) SetAmazonAddress(v string) *VirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAmazonSideAsn sets the AmazonSideAsn field's value.
func (s *VirtualInterface) SetAmazonSideAsn(v int64) *VirtualInterface {
	s.AmazonSideAsn = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *VirtualInterface) SetAsn(v int64) *VirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *VirtualInterface) SetAuthKey(v string) *VirtualInterface {
	s.AuthKey = &v
	return s
}

// SetAwsDeviceV2 sets the AwsDeviceV2 field's value.
func (s *VirtualInterface) SetAwsDeviceV2(v string) *VirtualInterface {
	s.AwsDeviceV2 = &v
	return s
}

// SetBgpPeers sets the BgpPeers field's value.
func (s *VirtualInterface) SetBgpPeers(v []*BGPPeer) *VirtualInterface {
	s.BgpPeers = v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *VirtualInterface) SetConnectionId(v string) *VirtualInterface {
	s.ConnectionId = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *VirtualInterface) SetCustomerAddress(v string) *VirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetCustomerRouterConfig sets the CustomerRouterConfig field's value.
func (s *VirtualInterface) SetCustomerRouterConfig(v string) *VirtualInterface {
	s.CustomerRouterConfig = &v
	return s
}

// SetDirectConnectGatewayId sets the DirectConnectGatewayId field's value.
func (s *VirtualInterface) SetDirectConnectGatewayId(v string) *VirtualInterface {
	s.DirectConnectGatewayId = &v
	return s
}

// SetJumboFrameCapable sets the JumboFrameCapable field's value.
func (s *VirtualInterface) SetJumboFrameCapable(v bool) *VirtualInterface {
	s.JumboFrameCapable = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *VirtualInterface) SetLocation(v string) *VirtualInterface {
	s.Location = &v
	return s
}

// SetMtu sets the Mtu field's value.
func (s *VirtualInterface) SetMtu(v int64) *VirtualInterface {
	s.Mtu = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *VirtualInterface) SetOwnerAccount(v string) *VirtualInterface {
	s.OwnerAccount = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *VirtualInterface) SetRegion(v string) *VirtualInterface {
	s.Region = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *VirtualInterface) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *VirtualInterface {
	s.RouteFilterPrefixes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *VirtualInterface) SetTags(v []*Tag) *VirtualInterface {
	s.Tags = v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *VirtualInterface) SetVirtualGatewayId(v string) *VirtualInterface {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *VirtualInterface) SetVirtualInterfaceId(v string) *VirtualInterface {
	s.VirtualInterfaceId = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *VirtualInterface) SetVirtualInterfaceName(v string) *VirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *VirtualInterface) SetVirtualInterfaceState(v string) *VirtualInterface {
	s.VirtualInterfaceState = &v
	return s
}

// SetVirtualInterfaceType sets the VirtualInterfaceType field's value.
func (s *VirtualInterface) SetVirtualInterfaceType(v string) *VirtualInterface {
	s.VirtualInterfaceType = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *VirtualInterface) SetVlan(v int64) *VirtualInterface {
	s.Vlan = &v
	return s
}

const (
	// AddressFamilyIpv4 is a AddressFamily enum value
	AddressFamilyIpv4 = "ipv4"

	// AddressFamilyIpv6 is a AddressFamily enum value
	AddressFamilyIpv6 = "ipv6"
)

const (
	// BGPPeerStateVerifying is a BGPPeerState enum value
	BGPPeerStateVerifying = "verifying"

	// BGPPeerStatePending is a BGPPeerState enum value
	BGPPeerStatePending = "pending"

	// BGPPeerStateAvailable is a BGPPeerState enum value
	BGPPeerStateAvailable = "available"

	// BGPPeerStateDeleting is a BGPPeerState enum value
	BGPPeerStateDeleting = "deleting"

	// BGPPeerStateDeleted is a BGPPeerState enum value
	BGPPeerStateDeleted = "deleted"
)

const (
	// BGPStatusUp is a BGPStatus enum value
	BGPStatusUp = "up"

	// BGPStatusDown is a BGPStatus enum value
	BGPStatusDown = "down"

	// BGPStatusUnknown is a BGPStatus enum value
	BGPStatusUnknown = "unknown"
)

const (
	// ConnectionStateOrdering is a ConnectionState enum value
	ConnectionStateOrdering = "ordering"

	// ConnectionStateRequested is a ConnectionState enum value
	ConnectionStateRequested = "requested"

	// ConnectionStatePending is a ConnectionState enum value
	ConnectionStatePending = "pending"

	// ConnectionStateAvailable is a ConnectionState enum value
	ConnectionStateAvailable = "available"

	// ConnectionStateDown is a ConnectionState enum value
	ConnectionStateDown = "down"

	// ConnectionStateDeleting is a ConnectionState enum value
	ConnectionStateDeleting = "deleting"

	// ConnectionStateDeleted is a ConnectionState enum value
	ConnectionStateDeleted = "deleted"

	// ConnectionStateRejected is a ConnectionState enum value
	ConnectionStateRejected = "rejected"

	// ConnectionStateUnknown is a ConnectionState enum value
	ConnectionStateUnknown = "unknown"
)

const (
	// GatewayAssociationProposalStateRequested is a GatewayAssociationProposalState enum value
	GatewayAssociationProposalStateRequested = "requested"

	// GatewayAssociationProposalStateAccepted is a GatewayAssociationProposalState enum value
	GatewayAssociationProposalStateAccepted = "accepted"

	// GatewayAssociationProposalStateDeleted is a GatewayAssociationProposalState enum value
	GatewayAssociationProposalStateDeleted = "deleted"
)

const (
	// GatewayAssociationStateAssociating is a GatewayAssociationState enum value
	GatewayAssociationStateAssociating = "associating"

	// GatewayAssociationStateAssociated is a GatewayAssociationState enum value
	GatewayAssociationStateAssociated = "associated"

	// GatewayAssociationStateDisassociating is a GatewayAssociationState enum value
	GatewayAssociationStateDisassociating = "disassociating"

	// GatewayAssociationStateDisassociated is a GatewayAssociationState enum value
	GatewayAssociationStateDisassociated = "disassociated"

	// GatewayAssociationStateUpdating is a GatewayAssociationState enum value
	GatewayAssociationStateUpdating = "updating"
)

const (
	// GatewayAttachmentStateAttaching is a GatewayAttachmentState enum value
	GatewayAttachmentStateAttaching = "attaching"

	// GatewayAttachmentStateAttached is a GatewayAttachmentState enum value
	GatewayAttachmentStateAttached = "attached"

	// GatewayAttachmentStateDetaching is a GatewayAttachmentState enum value
	GatewayAttachmentStateDetaching = "detaching"

	// GatewayAttachmentStateDetached is a GatewayAttachmentState enum value
	GatewayAttachmentStateDetached = "detached"
)

const (
	// GatewayAttachmentTypeTransitVirtualInterface is a GatewayAttachmentType enum value
	GatewayAttachmentTypeTransitVirtualInterface = "TransitVirtualInterface"

	// GatewayAttachmentTypePrivateVirtualInterface is a GatewayAttachmentType enum value
	GatewayAttachmentTypePrivateVirtualInterface = "PrivateVirtualInterface"
)

const (
	// GatewayStatePending is a GatewayState enum value
	GatewayStatePending = "pending"

	// GatewayStateAvailable is a GatewayState enum value
	GatewayStateAvailable = "available"

	// GatewayStateDeleting is a GatewayState enum value
	GatewayStateDeleting = "deleting"

	// GatewayStateDeleted is a GatewayState enum value
	GatewayStateDeleted = "deleted"
)

const (
	// GatewayTypeVirtualPrivateGateway is a GatewayType enum value
	GatewayTypeVirtualPrivateGateway = "virtualPrivateGateway"

	// GatewayTypeTransitGateway is a GatewayType enum value
	GatewayTypeTransitGateway = "transitGateway"
)

const (
	// HasLogicalRedundancyUnknown is a HasLogicalRedundancy enum value
	HasLogicalRedundancyUnknown = "unknown"

	// HasLogicalRedundancyYes is a HasLogicalRedundancy enum value
	HasLogicalRedundancyYes = "yes"

	// HasLogicalRedundancyNo is a HasLogicalRedundancy enum value
	HasLogicalRedundancyNo = "no"
)

const (
	// InterconnectStateRequested is a InterconnectState enum value
	InterconnectStateRequested = "requested"

	// InterconnectStatePending is a InterconnectState enum value
	InterconnectStatePending = "pending"

	// InterconnectStateAvailable is a InterconnectState enum value
	InterconnectStateAvailable = "available"

	// InterconnectStateDown is a InterconnectState enum value
	InterconnectStateDown = "down"

	// InterconnectStateDeleting is a InterconnectState enum value
	InterconnectStateDeleting = "deleting"

	// InterconnectStateDeleted is a InterconnectState enum value
	InterconnectStateDeleted = "deleted"

	// InterconnectStateUnknown is a InterconnectState enum value
	InterconnectStateUnknown = "unknown"
)

const (
	// LagStateRequested is a LagState enum value
	LagStateRequested = "requested"

	// LagStatePending is a LagState enum value
	LagStatePending = "pending"

	// LagStateAvailable is a LagState enum value
	LagStateAvailable = "available"

	// LagStateDown is a LagState enum value
	LagStateDown = "down"

	// LagStateDeleting is a LagState enum value
	LagStateDeleting = "deleting"

	// LagStateDeleted is a LagState enum value
	LagStateDeleted = "deleted"

	// LagStateUnknown is a LagState enum value
	LagStateUnknown = "unknown"
)

const (
	// LoaContentTypeApplicationPdf is a LoaContentType enum value
	LoaContentTypeApplicationPdf = "application/pdf"
)

const (
	// VirtualInterfaceStateConfirming is a VirtualInterfaceState enum value
	VirtualInterfaceStateConfirming = "confirming"

	// VirtualInterfaceStateVerifying is a VirtualInterfaceState enum value
	VirtualInterfaceStateVerifying = "verifying"

	// VirtualInterfaceStatePending is a VirtualInterfaceState enum value
	VirtualInterfaceStatePending = "pending"

	// VirtualInterfaceStateAvailable is a VirtualInterfaceState enum value
	VirtualInterfaceStateAvailable = "available"

	// VirtualInterfaceStateDown is a VirtualInterfaceState enum value
	VirtualInterfaceStateDown = "down"

	// VirtualInterfaceStateDeleting is a VirtualInterfaceState enum value
	VirtualInterfaceStateDeleting = "deleting"

	// VirtualInterfaceStateDeleted is a VirtualInterfaceState enum value
	VirtualInterfaceStateDeleted = "deleted"

	// VirtualInterfaceStateRejected is a VirtualInterfaceState enum value
	VirtualInterfaceStateRejected = "rejected"

	// VirtualInterfaceStateUnknown is a VirtualInterfaceState enum value
	VirtualInterfaceStateUnknown = "unknown"
)
