package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateVul invokes the aegis.OperateVul API synchronously
// api document: https://help.aliyun.com/api/aegis/operatevul.html
func (client *Client) OperateVul(request *OperateVulRequest) (response *OperateVulResponse, err error) {
	response = CreateOperateVulResponse()
	err = client.DoAction(request, response)
	return
}

// OperateVulWithChan invokes the aegis.OperateVul API asynchronously
// api document: https://help.aliyun.com/api/aegis/operatevul.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateVulWithChan(request *OperateVulRequest) (<-chan *OperateVulResponse, <-chan error) {
	responseChan := make(chan *OperateVulResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateVul(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateVulWithCallback invokes the aegis.OperateVul API asynchronously
// api document: https://help.aliyun.com/api/aegis/operatevul.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateVulWithCallback(request *OperateVulRequest, callback func(response *OperateVulResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateVulResponse
		var err error
		defer close(result)
		response, err = client.OperateVul(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateVulRequest is the request struct for api OperateVul
type OperateVulRequest struct {
	*requests.RpcRequest
	Reason      string `position:"Query" name:"Reason"`
	SourceIp    string `position:"Query" name:"SourceIp"`
	OperateType string `position:"Query" name:"OperateType"`
	Type        string `position:"Query" name:"Type"`
	Info        string `position:"Query" name:"Info"`
}

// OperateVulResponse is the response struct for api OperateVul
type OperateVulResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateVulRequest creates a request to invoke OperateVul API
func CreateOperateVulRequest() (request *OperateVulRequest) {
	request = &OperateVulRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "OperateVul", "vipaegis", "openAPI")
	return
}

// CreateOperateVulResponse creates a response to parse from OperateVul response
func CreateOperateVulResponse() (response *OperateVulResponse) {
	response = &OperateVulResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
