package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDiversify invokes the airec.ModifyDiversify API synchronously
// api document: https://help.aliyun.com/api/airec/modifydiversify.html
func (client *Client) ModifyDiversify(request *ModifyDiversifyRequest) (response *ModifyDiversifyResponse, err error) {
	response = CreateModifyDiversifyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDiversifyWithChan invokes the airec.ModifyDiversify API asynchronously
// api document: https://help.aliyun.com/api/airec/modifydiversify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDiversifyWithChan(request *ModifyDiversifyRequest) (<-chan *ModifyDiversifyResponse, <-chan error) {
	responseChan := make(chan *ModifyDiversifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDiversify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDiversifyWithCallback invokes the airec.ModifyDiversify API asynchronously
// api document: https://help.aliyun.com/api/airec/modifydiversify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDiversifyWithCallback(request *ModifyDiversifyRequest, callback func(response *ModifyDiversifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDiversifyResponse
		var err error
		defer close(result)
		response, err = client.ModifyDiversify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDiversifyRequest is the request struct for api ModifyDiversify
type ModifyDiversifyRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"Name"`
}

// ModifyDiversifyResponse is the response struct for api ModifyDiversify
type ModifyDiversifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateModifyDiversifyRequest creates a request to invoke ModifyDiversify API
func CreateModifyDiversifyRequest() (request *ModifyDiversifyRequest) {
	request = &ModifyDiversifyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "ModifyDiversify", "/openapi/instances/[InstanceId]/diversifies/[Name]", "airec", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateModifyDiversifyResponse creates a response to parse from ModifyDiversify response
func CreateModifyDiversifyResponse() (response *ModifyDiversifyResponse) {
	response = &ModifyDiversifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
