package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExposureSettings invokes the airec.ModifyExposureSettings API synchronously
// api document: https://help.aliyun.com/api/airec/modifyexposuresettings.html
func (client *Client) ModifyExposureSettings(request *ModifyExposureSettingsRequest) (response *ModifyExposureSettingsResponse, err error) {
	response = CreateModifyExposureSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExposureSettingsWithChan invokes the airec.ModifyExposureSettings API asynchronously
// api document: https://help.aliyun.com/api/airec/modifyexposuresettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExposureSettingsWithChan(request *ModifyExposureSettingsRequest) (<-chan *ModifyExposureSettingsResponse, <-chan error) {
	responseChan := make(chan *ModifyExposureSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExposureSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExposureSettingsWithCallback invokes the airec.ModifyExposureSettings API asynchronously
// api document: https://help.aliyun.com/api/airec/modifyexposuresettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExposureSettingsWithCallback(request *ModifyExposureSettingsRequest, callback func(response *ModifyExposureSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExposureSettingsResponse
		var err error
		defer close(result)
		response, err = client.ModifyExposureSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExposureSettingsRequest is the request struct for api ModifyExposureSettings
type ModifyExposureSettingsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ModifyExposureSettingsResponse is the response struct for api ModifyExposureSettings
type ModifyExposureSettingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateModifyExposureSettingsRequest creates a request to invoke ModifyExposureSettings API
func CreateModifyExposureSettingsRequest() (request *ModifyExposureSettingsRequest) {
	request = &ModifyExposureSettingsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "ModifyExposureSettings", "/openapi/instances/[InstanceId]/exposure-settings", "airec", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateModifyExposureSettingsResponse creates a response to parse from ModifyExposureSettings response
func CreateModifyExposureSettingsResponse() (response *ModifyExposureSettingsResponse) {
	response = &ModifyExposureSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
