package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGtmInstanceAddressPool invokes the alidns.DescribeGtmInstanceAddressPool API synchronously
// api document: https://help.aliyun.com/api/alidns/describegtminstanceaddresspool.html
func (client *Client) DescribeGtmInstanceAddressPool(request *DescribeGtmInstanceAddressPoolRequest) (response *DescribeGtmInstanceAddressPoolResponse, err error) {
	response = CreateDescribeGtmInstanceAddressPoolResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGtmInstanceAddressPoolWithChan invokes the alidns.DescribeGtmInstanceAddressPool API asynchronously
// api document: https://help.aliyun.com/api/alidns/describegtminstanceaddresspool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGtmInstanceAddressPoolWithChan(request *DescribeGtmInstanceAddressPoolRequest) (<-chan *DescribeGtmInstanceAddressPoolResponse, <-chan error) {
	responseChan := make(chan *DescribeGtmInstanceAddressPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGtmInstanceAddressPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGtmInstanceAddressPoolWithCallback invokes the alidns.DescribeGtmInstanceAddressPool API asynchronously
// api document: https://help.aliyun.com/api/alidns/describegtminstanceaddresspool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGtmInstanceAddressPoolWithCallback(request *DescribeGtmInstanceAddressPoolRequest, callback func(response *DescribeGtmInstanceAddressPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGtmInstanceAddressPoolResponse
		var err error
		defer close(result)
		response, err = client.DescribeGtmInstanceAddressPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGtmInstanceAddressPoolRequest is the request struct for api DescribeGtmInstanceAddressPool
type DescribeGtmInstanceAddressPoolRequest struct {
	*requests.RpcRequest
	AddrPoolId   string `position:"Query" name:"AddrPoolId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeGtmInstanceAddressPoolResponse is the response struct for api DescribeGtmInstanceAddressPool
type DescribeGtmInstanceAddressPoolResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	AddrPoolId          string `json:"AddrPoolId" xml:"AddrPoolId"`
	CreateTime          string `json:"CreateTime" xml:"CreateTime"`
	CreateTimestamp     int64  `json:"CreateTimestamp" xml:"CreateTimestamp"`
	UpdateTime          string `json:"UpdateTime" xml:"UpdateTime"`
	UpdateTimestamp     int64  `json:"UpdateTimestamp" xml:"UpdateTimestamp"`
	AddrCount           int    `json:"AddrCount" xml:"AddrCount"`
	MinAvailableAddrNum int    `json:"MinAvailableAddrNum" xml:"MinAvailableAddrNum"`
	MonitorConfigId     string `json:"MonitorConfigId" xml:"MonitorConfigId"`
	MonitorStatus       string `json:"MonitorStatus" xml:"MonitorStatus"`
	Name                string `json:"Name" xml:"Name"`
	Status              string `json:"Status" xml:"Status"`
	Type                string `json:"Type" xml:"Type"`
	Addrs               Addrs  `json:"Addrs" xml:"Addrs"`
}

// CreateDescribeGtmInstanceAddressPoolRequest creates a request to invoke DescribeGtmInstanceAddressPool API
func CreateDescribeGtmInstanceAddressPoolRequest() (request *DescribeGtmInstanceAddressPoolRequest) {
	request = &DescribeGtmInstanceAddressPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeGtmInstanceAddressPool", "Alidns", "openAPI")
	return
}

// CreateDescribeGtmInstanceAddressPoolResponse creates a response to parse from DescribeGtmInstanceAddressPool response
func CreateDescribeGtmInstanceAddressPoolResponse() (response *DescribeGtmInstanceAddressPoolResponse) {
	response = &DescribeGtmInstanceAddressPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
