package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCreateInstancePrice invokes the alidns.QueryCreateInstancePrice API synchronously
// api document: https://help.aliyun.com/api/alidns/querycreateinstanceprice.html
func (client *Client) QueryCreateInstancePrice(request *QueryCreateInstancePriceRequest) (response *QueryCreateInstancePriceResponse, err error) {
	response = CreateQueryCreateInstancePriceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCreateInstancePriceWithChan invokes the alidns.QueryCreateInstancePrice API asynchronously
// api document: https://help.aliyun.com/api/alidns/querycreateinstanceprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCreateInstancePriceWithChan(request *QueryCreateInstancePriceRequest) (<-chan *QueryCreateInstancePriceResponse, <-chan error) {
	responseChan := make(chan *QueryCreateInstancePriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCreateInstancePrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCreateInstancePriceWithCallback invokes the alidns.QueryCreateInstancePrice API asynchronously
// api document: https://help.aliyun.com/api/alidns/querycreateinstanceprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCreateInstancePriceWithCallback(request *QueryCreateInstancePriceRequest, callback func(response *QueryCreateInstancePriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCreateInstancePriceResponse
		var err error
		defer close(result)
		response, err = client.QueryCreateInstancePrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCreateInstancePriceRequest is the request struct for api QueryCreateInstancePrice
type QueryCreateInstancePriceRequest struct {
	*requests.RpcRequest
	Month           requests.Integer `position:"Query" name:"Month"`
	UserClientIp    string           `position:"Query" name:"UserClientIp"`
	Lang            string           `position:"Query" name:"Lang"`
	InstanceVersion string           `position:"Query" name:"InstanceVersion"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryCreateInstancePriceResponse is the response struct for api QueryCreateInstancePrice
type QueryCreateInstancePriceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Origin    string `json:"Origin" xml:"Origin"`
	Discount  string `json:"Discount" xml:"Discount"`
	Amount    string `json:"Amount" xml:"Amount"`
	Currency  string `json:"Currency" xml:"Currency"`
	Rules     Rules  `json:"Rules" xml:"Rules"`
}

// CreateQueryCreateInstancePriceRequest creates a request to invoke QueryCreateInstancePrice API
func CreateQueryCreateInstancePriceRequest() (request *QueryCreateInstancePriceRequest) {
	request = &QueryCreateInstancePriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "QueryCreateInstancePrice", "Alidns", "openAPI")
	return
}

// CreateQueryCreateInstancePriceResponse creates a response to parse from QueryCreateInstancePrice response
func CreateQueryCreateInstancePriceResponse() (response *QueryCreateInstancePriceResponse) {
	response = &QueryCreateInstancePriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
