package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIpOrHosts invokes the arms.GetIpOrHosts API synchronously
// api document: https://help.aliyun.com/api/arms/getiporhosts.html
func (client *Client) GetIpOrHosts(request *GetIpOrHostsRequest) (response *GetIpOrHostsResponse, err error) {
	response = CreateGetIpOrHostsResponse()
	err = client.DoAction(request, response)
	return
}

// GetIpOrHostsWithChan invokes the arms.GetIpOrHosts API asynchronously
// api document: https://help.aliyun.com/api/arms/getiporhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIpOrHostsWithChan(request *GetIpOrHostsRequest) (<-chan *GetIpOrHostsResponse, <-chan error) {
	responseChan := make(chan *GetIpOrHostsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIpOrHosts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIpOrHostsWithCallback invokes the arms.GetIpOrHosts API asynchronously
// api document: https://help.aliyun.com/api/arms/getiporhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIpOrHostsWithCallback(request *GetIpOrHostsRequest, callback func(response *GetIpOrHostsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIpOrHostsResponse
		var err error
		defer close(result)
		response, err = client.GetIpOrHosts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIpOrHostsRequest is the request struct for api GetIpOrHosts
type GetIpOrHostsRequest struct {
	*requests.RpcRequest
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	ServiceName string           `position:"Query" name:"ServiceName"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
}

// GetIpOrHostsResponse is the response struct for api GetIpOrHosts
type GetIpOrHostsResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Data      DataInGetIpOrHosts `json:"Data" xml:"Data"`
}

// CreateGetIpOrHostsRequest creates a request to invoke GetIpOrHosts API
func CreateGetIpOrHostsRequest() (request *GetIpOrHostsRequest) {
	request = &GetIpOrHostsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-02-19", "GetIpOrHosts", "", "")
	return
}

// CreateGetIpOrHostsResponse creates a response to parse from GetIpOrHosts response
func CreateGetIpOrHostsResponse() (response *GetIpOrHostsResponse) {
	response = &GetIpOrHostsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
