package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckConsortiumDomain invokes the baas.CheckConsortiumDomain API synchronously
// api document: https://help.aliyun.com/api/baas/checkconsortiumdomain.html
func (client *Client) CheckConsortiumDomain(request *CheckConsortiumDomainRequest) (response *CheckConsortiumDomainResponse, err error) {
	response = CreateCheckConsortiumDomainResponse()
	err = client.DoAction(request, response)
	return
}

// CheckConsortiumDomainWithChan invokes the baas.CheckConsortiumDomain API asynchronously
// api document: https://help.aliyun.com/api/baas/checkconsortiumdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckConsortiumDomainWithChan(request *CheckConsortiumDomainRequest) (<-chan *CheckConsortiumDomainResponse, <-chan error) {
	responseChan := make(chan *CheckConsortiumDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckConsortiumDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckConsortiumDomainWithCallback invokes the baas.CheckConsortiumDomain API asynchronously
// api document: https://help.aliyun.com/api/baas/checkconsortiumdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckConsortiumDomainWithCallback(request *CheckConsortiumDomainRequest, callback func(response *CheckConsortiumDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckConsortiumDomainResponse
		var err error
		defer close(result)
		response, err = client.CheckConsortiumDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckConsortiumDomainRequest is the request struct for api CheckConsortiumDomain
type CheckConsortiumDomainRequest struct {
	*requests.RpcRequest
	DomainCode string `position:"Body" name:"DomainCode"`
}

// CheckConsortiumDomainResponse is the response struct for api CheckConsortiumDomain
type CheckConsortiumDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCheckConsortiumDomainRequest creates a request to invoke CheckConsortiumDomain API
func CreateCheckConsortiumDomainRequest() (request *CheckConsortiumDomainRequest) {
	request = &CheckConsortiumDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "CheckConsortiumDomain", "", "")
	return
}

// CreateCheckConsortiumDomainResponse creates a response to parse from CheckConsortiumDomain response
func CreateCheckConsortiumDomainResponse() (response *CheckConsortiumDomainResponse) {
	response = &CheckConsortiumDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
