package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConsortiumMember invokes the baas.CreateConsortiumMember API synchronously
// api document: https://help.aliyun.com/api/baas/createconsortiummember.html
func (client *Client) CreateConsortiumMember(request *CreateConsortiumMemberRequest) (response *CreateConsortiumMemberResponse, err error) {
	response = CreateCreateConsortiumMemberResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConsortiumMemberWithChan invokes the baas.CreateConsortiumMember API asynchronously
// api document: https://help.aliyun.com/api/baas/createconsortiummember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateConsortiumMemberWithChan(request *CreateConsortiumMemberRequest) (<-chan *CreateConsortiumMemberResponse, <-chan error) {
	responseChan := make(chan *CreateConsortiumMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConsortiumMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConsortiumMemberWithCallback invokes the baas.CreateConsortiumMember API asynchronously
// api document: https://help.aliyun.com/api/baas/createconsortiummember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateConsortiumMemberWithCallback(request *CreateConsortiumMemberRequest, callback func(response *CreateConsortiumMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConsortiumMemberResponse
		var err error
		defer close(result)
		response, err = client.CreateConsortiumMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConsortiumMemberRequest is the request struct for api CreateConsortiumMember
type CreateConsortiumMemberRequest struct {
	*requests.RpcRequest
	Code         string                                `position:"Query" name:"Code"`
	Organization *[]CreateConsortiumMemberOrganization `position:"Query" name:"Organization"  type:"Repeated"`
	ConsortiumId string                                `position:"Query" name:"ConsortiumId"`
}

// CreateConsortiumMemberOrganization is a repeated param struct in CreateConsortiumMemberRequest
type CreateConsortiumMemberOrganization struct {
	Id string `name:"Id"`
}

// CreateConsortiumMemberResponse is the response struct for api CreateConsortiumMember
type CreateConsortiumMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCreateConsortiumMemberRequest creates a request to invoke CreateConsortiumMember API
func CreateCreateConsortiumMemberRequest() (request *CreateConsortiumMemberRequest) {
	request = &CreateConsortiumMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "CreateConsortiumMember", "", "")
	return
}

// CreateCreateConsortiumMemberResponse creates a response to parse from CreateConsortiumMember response
func CreateCreateConsortiumMemberResponse() (response *CreateConsortiumMemberResponse) {
	response = &CreateConsortiumMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
