package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteChaincode invokes the baas.DeleteChaincode API synchronously
// api document: https://help.aliyun.com/api/baas/deletechaincode.html
func (client *Client) DeleteChaincode(request *DeleteChaincodeRequest) (response *DeleteChaincodeResponse, err error) {
	response = CreateDeleteChaincodeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteChaincodeWithChan invokes the baas.DeleteChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/deletechaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteChaincodeWithChan(request *DeleteChaincodeRequest) (<-chan *DeleteChaincodeResponse, <-chan error) {
	responseChan := make(chan *DeleteChaincodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteChaincode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteChaincodeWithCallback invokes the baas.DeleteChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/deletechaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteChaincodeWithCallback(request *DeleteChaincodeRequest, callback func(response *DeleteChaincodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteChaincodeResponse
		var err error
		defer close(result)
		response, err = client.DeleteChaincode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteChaincodeRequest is the request struct for api DeleteChaincode
type DeleteChaincodeRequest struct {
	*requests.RpcRequest
	ChaincodeId string `position:"Body" name:"ChaincodeId"`
}

// DeleteChaincodeResponse is the response struct for api DeleteChaincode
type DeleteChaincodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteChaincodeRequest creates a request to invoke DeleteChaincode API
func CreateDeleteChaincodeRequest() (request *DeleteChaincodeRequest) {
	request = &DeleteChaincodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DeleteChaincode", "", "")
	return
}

// CreateDeleteChaincodeResponse creates a response to parse from DeleteChaincode response
func CreateDeleteChaincodeResponse() (response *DeleteChaincodeResponse) {
	response = &DeleteChaincodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
