package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplies invokes the baas.DescribeApplies API synchronously
// api document: https://help.aliyun.com/api/baas/describeapplies.html
func (client *Client) DescribeApplies(request *DescribeAppliesRequest) (response *DescribeAppliesResponse, err error) {
	response = CreateDescribeAppliesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppliesWithChan invokes the baas.DescribeApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/describeapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppliesWithChan(request *DescribeAppliesRequest) (<-chan *DescribeAppliesResponse, <-chan error) {
	responseChan := make(chan *DescribeAppliesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppliesWithCallback invokes the baas.DescribeApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/describeapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppliesWithCallback(request *DescribeAppliesRequest, callback func(response *DescribeAppliesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppliesResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppliesRequest is the request struct for api DescribeApplies
type DescribeAppliesRequest struct {
	*requests.RpcRequest
	Current  requests.Integer `position:"Body" name:"Current"`
	Bizid    string           `position:"Body" name:"Bizid"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
	Status   string           `position:"Body" name:"Status"`
}

// DescribeAppliesResponse is the response struct for api DescribeApplies
type DescribeAppliesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeAppliesRequest creates a request to invoke DescribeApplies API
func CreateDescribeAppliesRequest() (request *DescribeAppliesRequest) {
	request = &DescribeAppliesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeApplies", "", "")
	return
}

// CreateDescribeAppliesResponse creates a response to parse from DescribeApplies response
func CreateDescribeAppliesResponse() (response *DescribeAppliesResponse) {
	response = &DescribeAppliesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
