package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCandidateOrganizations invokes the baas.DescribeCandidateOrganizations API synchronously
// api document: https://help.aliyun.com/api/baas/describecandidateorganizations.html
func (client *Client) DescribeCandidateOrganizations(request *DescribeCandidateOrganizationsRequest) (response *DescribeCandidateOrganizationsResponse, err error) {
	response = CreateDescribeCandidateOrganizationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCandidateOrganizationsWithChan invokes the baas.DescribeCandidateOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describecandidateorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCandidateOrganizationsWithChan(request *DescribeCandidateOrganizationsRequest) (<-chan *DescribeCandidateOrganizationsResponse, <-chan error) {
	responseChan := make(chan *DescribeCandidateOrganizationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCandidateOrganizations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCandidateOrganizationsWithCallback invokes the baas.DescribeCandidateOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describecandidateorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCandidateOrganizationsWithCallback(request *DescribeCandidateOrganizationsRequest, callback func(response *DescribeCandidateOrganizationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCandidateOrganizationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCandidateOrganizations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCandidateOrganizationsRequest is the request struct for api DescribeCandidateOrganizations
type DescribeCandidateOrganizationsRequest struct {
	*requests.RpcRequest
	Location string `position:"Body" name:"Location"`
}

// DescribeCandidateOrganizationsResponse is the response struct for api DescribeCandidateOrganizations
type DescribeCandidateOrganizationsResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Success   bool                            `json:"Success" xml:"Success"`
	ErrorCode int                             `json:"ErrorCode" xml:"ErrorCode"`
	Result    []DescribeCandidateOrganization `json:"Result" xml:"Result"`
}

// CreateDescribeCandidateOrganizationsRequest creates a request to invoke DescribeCandidateOrganizations API
func CreateDescribeCandidateOrganizationsRequest() (request *DescribeCandidateOrganizationsRequest) {
	request = &DescribeCandidateOrganizationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeCandidateOrganizations", "", "")
	return
}

// CreateDescribeCandidateOrganizationsResponse creates a response to parse from DescribeCandidateOrganizations response
func CreateDescribeCandidateOrganizationsResponse() (response *DescribeCandidateOrganizationsResponse) {
	response = &DescribeCandidateOrganizationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
