package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMyBlockchains invokes the baas.DescribeMyBlockchains API synchronously
// api document: https://help.aliyun.com/api/baas/describemyblockchains.html
func (client *Client) DescribeMyBlockchains(request *DescribeMyBlockchainsRequest) (response *DescribeMyBlockchainsResponse, err error) {
	response = CreateDescribeMyBlockchainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMyBlockchainsWithChan invokes the baas.DescribeMyBlockchains API asynchronously
// api document: https://help.aliyun.com/api/baas/describemyblockchains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMyBlockchainsWithChan(request *DescribeMyBlockchainsRequest) (<-chan *DescribeMyBlockchainsResponse, <-chan error) {
	responseChan := make(chan *DescribeMyBlockchainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMyBlockchains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMyBlockchainsWithCallback invokes the baas.DescribeMyBlockchains API asynchronously
// api document: https://help.aliyun.com/api/baas/describemyblockchains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMyBlockchainsWithCallback(request *DescribeMyBlockchainsRequest, callback func(response *DescribeMyBlockchainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMyBlockchainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeMyBlockchains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMyBlockchainsRequest is the request struct for api DescribeMyBlockchains
type DescribeMyBlockchainsRequest struct {
	*requests.RpcRequest
}

// DescribeMyBlockchainsResponse is the response struct for api DescribeMyBlockchains
type DescribeMyBlockchainsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeMyBlockchainsRequest creates a request to invoke DescribeMyBlockchains API
func CreateDescribeMyBlockchainsRequest() (request *DescribeMyBlockchainsRequest) {
	request = &DescribeMyBlockchainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeMyBlockchains", "", "")
	return
}

// CreateDescribeMyBlockchainsResponse creates a response to parse from DescribeMyBlockchains response
func CreateDescribeMyBlockchainsResponse() (response *DescribeMyBlockchainsResponse) {
	response = &DescribeMyBlockchainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
