package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetCertificate invokes the baas.ResetCertificate API synchronously
// api document: https://help.aliyun.com/api/baas/resetcertificate.html
func (client *Client) ResetCertificate(request *ResetCertificateRequest) (response *ResetCertificateResponse, err error) {
	response = CreateResetCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// ResetCertificateWithChan invokes the baas.ResetCertificate API asynchronously
// api document: https://help.aliyun.com/api/baas/resetcertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetCertificateWithChan(request *ResetCertificateRequest) (<-chan *ResetCertificateResponse, <-chan error) {
	responseChan := make(chan *ResetCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetCertificateWithCallback invokes the baas.ResetCertificate API asynchronously
// api document: https://help.aliyun.com/api/baas/resetcertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetCertificateWithCallback(request *ResetCertificateRequest, callback func(response *ResetCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetCertificateResponse
		var err error
		defer close(result)
		response, err = client.ResetCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetCertificateRequest is the request struct for api ResetCertificate
type ResetCertificateRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// ResetCertificateResponse is the response struct for api ResetCertificate
type ResetCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateResetCertificateRequest creates a request to invoke ResetCertificate API
func CreateResetCertificateRequest() (request *ResetCertificateRequest) {
	request = &ResetCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "ResetCertificate", "", "")
	return
}

// CreateResetCertificateResponse creates a response to parse from ResetCertificate response
func CreateResetCertificateResponse() (response *ResetCertificateResponse) {
	response = &ResetCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
