package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetScenario invokes the ccc.GetScenario API synchronously
// api document: https://help.aliyun.com/api/ccc/getscenario.html
func (client *Client) GetScenario(request *GetScenarioRequest) (response *GetScenarioResponse, err error) {
	response = CreateGetScenarioResponse()
	err = client.DoAction(request, response)
	return
}

// GetScenarioWithChan invokes the ccc.GetScenario API asynchronously
// api document: https://help.aliyun.com/api/ccc/getscenario.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetScenarioWithChan(request *GetScenarioRequest) (<-chan *GetScenarioResponse, <-chan error) {
	responseChan := make(chan *GetScenarioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetScenario(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetScenarioWithCallback invokes the ccc.GetScenario API asynchronously
// api document: https://help.aliyun.com/api/ccc/getscenario.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetScenarioWithCallback(request *GetScenarioRequest, callback func(response *GetScenarioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetScenarioResponse
		var err error
		defer close(result)
		response, err = client.GetScenario(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetScenarioRequest is the request struct for api GetScenario
type GetScenarioRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	ScenarioId string `position:"Query" name:"ScenarioId"`
}

// GetScenarioResponse is the response struct for api GetScenario
type GetScenarioResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Scenario       Scenario `json:"Scenario" xml:"Scenario"`
}

// CreateGetScenarioRequest creates a request to invoke GetScenario API
func CreateGetScenarioRequest() (request *GetScenarioRequest) {
	request = &GetScenarioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetScenario", "", "")
	return
}

// CreateGetScenarioResponse creates a response to parse from GetScenario response
func CreateGetScenarioResponse() (response *GetScenarioResponse) {
	response = &GetScenarioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
