package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateApi invokes the cloudapi.CreateApi API synchronously
// api document: https://help.aliyun.com/api/cloudapi/createapi.html
func (client *Client) CreateApi(request *CreateApiRequest) (response *CreateApiResponse, err error) {
	response = CreateCreateApiResponse()
	err = client.DoAction(request, response)
	return
}

// CreateApiWithChan invokes the cloudapi.CreateApi API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/createapi.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateApiWithChan(request *CreateApiRequest) (<-chan *CreateApiResponse, <-chan error) {
	responseChan := make(chan *CreateApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateApiWithCallback invokes the cloudapi.CreateApi API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/createapi.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateApiWithCallback(request *CreateApiRequest, callback func(response *CreateApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateApiResponse
		var err error
		defer close(result)
		response, err = client.CreateApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateApiRequest is the request struct for api CreateApi
type CreateApiRequest struct {
	*requests.RpcRequest
	WebSocketApiType     string           `position:"Query" name:"WebSocketApiType"`
	ErrorCodeSamples     string           `position:"Query" name:"ErrorCodeSamples"`
	AppCodeAuthType      string           `position:"Query" name:"AppCodeAuthType"`
	Description          string           `position:"Query" name:"Description"`
	DisableInternet      requests.Boolean `position:"Query" name:"DisableInternet"`
	ConstantParameters   string           `position:"Query" name:"ConstantParameters"`
	AuthType             string           `position:"Query" name:"AuthType"`
	AllowSignatureMethod string           `position:"Query" name:"AllowSignatureMethod"`
	ServiceParameters    string           `position:"Query" name:"ServiceParameters"`
	FailResultSample     string           `position:"Query" name:"FailResultSample"`
	SystemParameters     string           `position:"Query" name:"SystemParameters"`
	ServiceParametersMap string           `position:"Query" name:"ServiceParametersMap"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	OpenIdConnectConfig  string           `position:"Query" name:"OpenIdConnectConfig"`
	RequestParameters    string           `position:"Query" name:"RequestParameters"`
	ResultDescriptions   string           `position:"Query" name:"ResultDescriptions"`
	Visibility           string           `position:"Query" name:"Visibility"`
	GroupId              string           `position:"Query" name:"GroupId"`
	ServiceConfig        string           `position:"Query" name:"ServiceConfig"`
	ResultType           string           `position:"Query" name:"ResultType"`
	ApiName              string           `position:"Query" name:"ApiName"`
	ResultSample         string           `position:"Query" name:"ResultSample"`
	ForceNonceCheck      requests.Boolean `position:"Query" name:"ForceNonceCheck"`
	RequestConfig        string           `position:"Query" name:"RequestConfig"`
	ResultBodyModel      string           `position:"Query" name:"ResultBodyModel"`
}

// CreateApiResponse is the response struct for api CreateApi
type CreateApiResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ApiId     string `json:"ApiId" xml:"ApiId"`
}

// CreateCreateApiRequest creates a request to invoke CreateApi API
func CreateCreateApiRequest() (request *CreateApiRequest) {
	request = &CreateApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "CreateApi", "apigateway", "openAPI")
	return
}

// CreateCreateApiResponse creates a response to parse from CreateApi response
func CreateCreateApiResponse() (response *CreateApiResponse) {
	response = &CreateApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
