package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetAppCode invokes the cloudapi.ResetAppCode API synchronously
// api document: https://help.aliyun.com/api/cloudapi/resetappcode.html
func (client *Client) ResetAppCode(request *ResetAppCodeRequest) (response *ResetAppCodeResponse, err error) {
	response = CreateResetAppCodeResponse()
	err = client.DoAction(request, response)
	return
}

// ResetAppCodeWithChan invokes the cloudapi.ResetAppCode API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/resetappcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetAppCodeWithChan(request *ResetAppCodeRequest) (<-chan *ResetAppCodeResponse, <-chan error) {
	responseChan := make(chan *ResetAppCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetAppCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetAppCodeWithCallback invokes the cloudapi.ResetAppCode API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/resetappcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetAppCodeWithCallback(request *ResetAppCodeRequest, callback func(response *ResetAppCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetAppCodeResponse
		var err error
		defer close(result)
		response, err = client.ResetAppCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetAppCodeRequest is the request struct for api ResetAppCode
type ResetAppCodeRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	AppCode       string `position:"Query" name:"AppCode"`
}

// ResetAppCodeResponse is the response struct for api ResetAppCode
type ResetAppCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetAppCodeRequest creates a request to invoke ResetAppCode API
func CreateResetAppCodeRequest() (request *ResetAppCodeRequest) {
	request = &ResetAppCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ResetAppCode", "apigateway", "openAPI")
	return
}

// CreateResetAppCodeResponse creates a response to parse from ResetAppCode response
func CreateResetAppCodeResponse() (response *ResetAppCodeResponse) {
	response = &ResetAppCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
