package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLatestStaStatistic invokes the cloudwf.GetLatestStaStatistic API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getlateststastatistic.html
func (client *Client) GetLatestStaStatistic(request *GetLatestStaStatisticRequest) (response *GetLatestStaStatisticResponse, err error) {
	response = CreateGetLatestStaStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// GetLatestStaStatisticWithChan invokes the cloudwf.GetLatestStaStatistic API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getlateststastatistic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLatestStaStatisticWithChan(request *GetLatestStaStatisticRequest) (<-chan *GetLatestStaStatisticResponse, <-chan error) {
	responseChan := make(chan *GetLatestStaStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLatestStaStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLatestStaStatisticWithCallback invokes the cloudwf.GetLatestStaStatistic API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getlateststastatistic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLatestStaStatisticWithCallback(request *GetLatestStaStatisticRequest, callback func(response *GetLatestStaStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLatestStaStatisticResponse
		var err error
		defer close(result)
		response, err = client.GetLatestStaStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLatestStaStatisticRequest is the request struct for api GetLatestStaStatistic
type GetLatestStaStatisticRequest struct {
	*requests.RpcRequest
	ApgroupId requests.Integer `position:"Query" name:"ApgroupId"`
}

// GetLatestStaStatisticResponse is the response struct for api GetLatestStaStatistic
type GetLatestStaStatisticResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetLatestStaStatisticRequest creates a request to invoke GetLatestStaStatistic API
func CreateGetLatestStaStatisticRequest() (request *GetLatestStaStatisticRequest) {
	request = &GetLatestStaStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetLatestStaStatistic", "cloudwf", "openAPI")
	return
}

// CreateGetLatestStaStatisticResponse creates a response to parse from GetLatestStaStatistic response
func CreateGetLatestStaStatisticResponse() (response *GetLatestStaStatisticResponse) {
	response = &GetLatestStaStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
