package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendCommandByMac invokes the cloudwf.SendCommandByMac API synchronously
// api document: https://help.aliyun.com/api/cloudwf/sendcommandbymac.html
func (client *Client) SendCommandByMac(request *SendCommandByMacRequest) (response *SendCommandByMacResponse, err error) {
	response = CreateSendCommandByMacResponse()
	err = client.DoAction(request, response)
	return
}

// SendCommandByMacWithChan invokes the cloudwf.SendCommandByMac API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/sendcommandbymac.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendCommandByMacWithChan(request *SendCommandByMacRequest) (<-chan *SendCommandByMacResponse, <-chan error) {
	responseChan := make(chan *SendCommandByMacResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendCommandByMac(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendCommandByMacWithCallback invokes the cloudwf.SendCommandByMac API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/sendcommandbymac.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendCommandByMacWithCallback(request *SendCommandByMacRequest, callback func(response *SendCommandByMacResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendCommandByMacResponse
		var err error
		defer close(result)
		response, err = client.SendCommandByMac(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendCommandByMacRequest is the request struct for api SendCommandByMac
type SendCommandByMacRequest struct {
	*requests.RpcRequest
	MacList *[]string `position:"Query" name:"MacList"  type:"Repeated"`
	Command string    `position:"Query" name:"Command"`
}

// SendCommandByMacResponse is the response struct for api SendCommandByMac
type SendCommandByMacResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSendCommandByMacRequest creates a request to invoke SendCommandByMac API
func CreateSendCommandByMacRequest() (request *SendCommandByMacRequest) {
	request = &SendCommandByMacRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SendCommandByMac", "cloudwf", "openAPI")
	return
}

// CreateSendCommandByMacResponse creates a response to parse from SendCommandByMac response
func CreateSendCommandByMacResponse() (response *SendCommandByMacResponse) {
	response = &SendCommandByMacResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
