package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMetricList invokes the cms.DescribeMetricList API synchronously
// api document: https://help.aliyun.com/api/cms/describemetriclist.html
func (client *Client) DescribeMetricList(request *DescribeMetricListRequest) (response *DescribeMetricListResponse, err error) {
	response = CreateDescribeMetricListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMetricListWithChan invokes the cms.DescribeMetricList API asynchronously
// api document: https://help.aliyun.com/api/cms/describemetriclist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMetricListWithChan(request *DescribeMetricListRequest) (<-chan *DescribeMetricListResponse, <-chan error) {
	responseChan := make(chan *DescribeMetricListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMetricList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMetricListWithCallback invokes the cms.DescribeMetricList API asynchronously
// api document: https://help.aliyun.com/api/cms/describemetriclist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMetricListWithCallback(request *DescribeMetricListRequest, callback func(response *DescribeMetricListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMetricListResponse
		var err error
		defer close(result)
		response, err = client.DescribeMetricList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMetricListRequest is the request struct for api DescribeMetricList
type DescribeMetricListRequest struct {
	*requests.RpcRequest
	Period     string `position:"Query" name:"Period"`
	NextToken  string `position:"Query" name:"NextToken"`
	Namespace  string `position:"Query" name:"Namespace"`
	Length     string `position:"Query" name:"Length"`
	EndTime    string `position:"Query" name:"EndTime"`
	Express    string `position:"Query" name:"Express"`
	StartTime  string `position:"Query" name:"StartTime"`
	MetricName string `position:"Query" name:"MetricName"`
	Dimensions string `position:"Query" name:"Dimensions"`
}

// DescribeMetricListResponse is the response struct for api DescribeMetricList
type DescribeMetricListResponse struct {
	*responses.BaseResponse
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	NextToken  string `json:"NextToken" xml:"NextToken"`
	Datapoints string `json:"Datapoints" xml:"Datapoints"`
	Period     string `json:"Period" xml:"Period"`
	Success    bool   `json:"Success" xml:"Success"`
}

// CreateDescribeMetricListRequest creates a request to invoke DescribeMetricList API
func CreateDescribeMetricListRequest() (request *DescribeMetricListRequest) {
	request = &DescribeMetricListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMetricList", "cms", "openAPI")
	return
}

// CreateDescribeMetricListResponse creates a response to parse from DescribeMetricList response
func CreateDescribeMetricListResponse() (response *DescribeMetricListResponse) {
	response = &DescribeMetricListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
