package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSiteMonitorQuota invokes the cms.DescribeSiteMonitorQuota API synchronously
// api document: https://help.aliyun.com/api/cms/describesitemonitorquota.html
func (client *Client) DescribeSiteMonitorQuota(request *DescribeSiteMonitorQuotaRequest) (response *DescribeSiteMonitorQuotaResponse, err error) {
	response = CreateDescribeSiteMonitorQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSiteMonitorQuotaWithChan invokes the cms.DescribeSiteMonitorQuota API asynchronously
// api document: https://help.aliyun.com/api/cms/describesitemonitorquota.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSiteMonitorQuotaWithChan(request *DescribeSiteMonitorQuotaRequest) (<-chan *DescribeSiteMonitorQuotaResponse, <-chan error) {
	responseChan := make(chan *DescribeSiteMonitorQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSiteMonitorQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSiteMonitorQuotaWithCallback invokes the cms.DescribeSiteMonitorQuota API asynchronously
// api document: https://help.aliyun.com/api/cms/describesitemonitorquota.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSiteMonitorQuotaWithCallback(request *DescribeSiteMonitorQuotaRequest, callback func(response *DescribeSiteMonitorQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSiteMonitorQuotaResponse
		var err error
		defer close(result)
		response, err = client.DescribeSiteMonitorQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSiteMonitorQuotaRequest is the request struct for api DescribeSiteMonitorQuota
type DescribeSiteMonitorQuotaRequest struct {
	*requests.RpcRequest
}

// DescribeSiteMonitorQuotaResponse is the response struct for api DescribeSiteMonitorQuota
type DescribeSiteMonitorQuotaResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeSiteMonitorQuotaRequest creates a request to invoke DescribeSiteMonitorQuota API
func CreateDescribeSiteMonitorQuotaRequest() (request *DescribeSiteMonitorQuotaRequest) {
	request = &DescribeSiteMonitorQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeSiteMonitorQuota", "cms", "openAPI")
	return
}

// CreateDescribeSiteMonitorQuotaResponse creates a response to parse from DescribeSiteMonitorQuota response
func CreateDescribeSiteMonitorQuotaResponse() (response *DescribeSiteMonitorQuotaResponse) {
	response = &DescribeSiteMonitorQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
