package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutMonitoringConfig invokes the cms.PutMonitoringConfig API synchronously
// api document: https://help.aliyun.com/api/cms/putmonitoringconfig.html
func (client *Client) PutMonitoringConfig(request *PutMonitoringConfigRequest) (response *PutMonitoringConfigResponse, err error) {
	response = CreatePutMonitoringConfigResponse()
	err = client.DoAction(request, response)
	return
}

// PutMonitoringConfigWithChan invokes the cms.PutMonitoringConfig API asynchronously
// api document: https://help.aliyun.com/api/cms/putmonitoringconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutMonitoringConfigWithChan(request *PutMonitoringConfigRequest) (<-chan *PutMonitoringConfigResponse, <-chan error) {
	responseChan := make(chan *PutMonitoringConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutMonitoringConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutMonitoringConfigWithCallback invokes the cms.PutMonitoringConfig API asynchronously
// api document: https://help.aliyun.com/api/cms/putmonitoringconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutMonitoringConfigWithCallback(request *PutMonitoringConfigRequest, callback func(response *PutMonitoringConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutMonitoringConfigResponse
		var err error
		defer close(result)
		response, err = client.PutMonitoringConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutMonitoringConfigRequest is the request struct for api PutMonitoringConfig
type PutMonitoringConfigRequest struct {
	*requests.RpcRequest
	EnableInstallAgentNewECS requests.Boolean `position:"Query" name:"EnableInstallAgentNewECS"`
	AutoInstall              requests.Boolean `position:"Query" name:"AutoInstall"`
}

// PutMonitoringConfigResponse is the response struct for api PutMonitoringConfig
type PutMonitoringConfigResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutMonitoringConfigRequest creates a request to invoke PutMonitoringConfig API
func CreatePutMonitoringConfigRequest() (request *PutMonitoringConfigRequest) {
	request = &PutMonitoringConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutMonitoringConfig", "cms", "openAPI")
	return
}

// CreatePutMonitoringConfigResponse creates a response to parse from PutMonitoringConfig response
func CreatePutMonitoringConfigResponse() (response *PutMonitoringConfigResponse) {
	response = &PutMonitoringConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
