package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRepoAuthorization invokes the cr.DeleteRepoAuthorization API synchronously
// api document: https://help.aliyun.com/api/cr/deleterepoauthorization.html
func (client *Client) DeleteRepoAuthorization(request *DeleteRepoAuthorizationRequest) (response *DeleteRepoAuthorizationResponse, err error) {
	response = CreateDeleteRepoAuthorizationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRepoAuthorizationWithChan invokes the cr.DeleteRepoAuthorization API asynchronously
// api document: https://help.aliyun.com/api/cr/deleterepoauthorization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRepoAuthorizationWithChan(request *DeleteRepoAuthorizationRequest) (<-chan *DeleteRepoAuthorizationResponse, <-chan error) {
	responseChan := make(chan *DeleteRepoAuthorizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRepoAuthorization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRepoAuthorizationWithCallback invokes the cr.DeleteRepoAuthorization API asynchronously
// api document: https://help.aliyun.com/api/cr/deleterepoauthorization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRepoAuthorizationWithCallback(request *DeleteRepoAuthorizationRequest, callback func(response *DeleteRepoAuthorizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRepoAuthorizationResponse
		var err error
		defer close(result)
		response, err = client.DeleteRepoAuthorization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRepoAuthorizationRequest is the request struct for api DeleteRepoAuthorization
type DeleteRepoAuthorizationRequest struct {
	*requests.RoaRequest
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	RepoName      string           `position:"Path" name:"RepoName"`
	AuthorizeId   requests.Integer `position:"Path" name:"AuthorizeId"`
}

// DeleteRepoAuthorizationResponse is the response struct for api DeleteRepoAuthorization
type DeleteRepoAuthorizationResponse struct {
	*responses.BaseResponse
}

// CreateDeleteRepoAuthorizationRequest creates a request to invoke DeleteRepoAuthorization API
func CreateDeleteRepoAuthorizationRequest() (request *DeleteRepoAuthorizationRequest) {
	request = &DeleteRepoAuthorizationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "DeleteRepoAuthorization", "/repos/[RepoNamespace]/[RepoName]/authorizations/[AuthorizeId]", "cr", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteRepoAuthorizationResponse creates a response to parse from DeleteRepoAuthorization response
func CreateDeleteRepoAuthorizationResponse() (response *DeleteRepoAuthorizationResponse) {
	response = &DeleteRepoAuthorizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
