package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserSourceAccount invokes the cr.DeleteUserSourceAccount API synchronously
// api document: https://help.aliyun.com/api/cr/deleteusersourceaccount.html
func (client *Client) DeleteUserSourceAccount(request *DeleteUserSourceAccountRequest) (response *DeleteUserSourceAccountResponse, err error) {
	response = CreateDeleteUserSourceAccountResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserSourceAccountWithChan invokes the cr.DeleteUserSourceAccount API asynchronously
// api document: https://help.aliyun.com/api/cr/deleteusersourceaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUserSourceAccountWithChan(request *DeleteUserSourceAccountRequest) (<-chan *DeleteUserSourceAccountResponse, <-chan error) {
	responseChan := make(chan *DeleteUserSourceAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserSourceAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserSourceAccountWithCallback invokes the cr.DeleteUserSourceAccount API asynchronously
// api document: https://help.aliyun.com/api/cr/deleteusersourceaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUserSourceAccountWithCallback(request *DeleteUserSourceAccountRequest, callback func(response *DeleteUserSourceAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserSourceAccountResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserSourceAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserSourceAccountRequest is the request struct for api DeleteUserSourceAccount
type DeleteUserSourceAccountRequest struct {
	*requests.RoaRequest
	SourceAccountId requests.Integer `position:"Path" name:"SourceAccountId"`
}

// DeleteUserSourceAccountResponse is the response struct for api DeleteUserSourceAccount
type DeleteUserSourceAccountResponse struct {
	*responses.BaseResponse
}

// CreateDeleteUserSourceAccountRequest creates a request to invoke DeleteUserSourceAccount API
func CreateDeleteUserSourceAccountRequest() (request *DeleteUserSourceAccountRequest) {
	request = &DeleteUserSourceAccountRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "DeleteUserSourceAccount", "/users/sourceAccount/[SourceAccountId]", "cr", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteUserSourceAccountResponse creates a response to parse from DeleteUserSourceAccount response
func CreateDeleteUserSourceAccountResponse() (response *DeleteUserSourceAccountResponse) {
	response = &DeleteUserSourceAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
