package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoWebhook invokes the cr.GetRepoWebhook API synchronously
// api document: https://help.aliyun.com/api/cr/getrepowebhook.html
func (client *Client) GetRepoWebhook(request *GetRepoWebhookRequest) (response *GetRepoWebhookResponse, err error) {
	response = CreateGetRepoWebhookResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoWebhookWithChan invokes the cr.GetRepoWebhook API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepowebhook.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoWebhookWithChan(request *GetRepoWebhookRequest) (<-chan *GetRepoWebhookResponse, <-chan error) {
	responseChan := make(chan *GetRepoWebhookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoWebhook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoWebhookWithCallback invokes the cr.GetRepoWebhook API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepowebhook.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoWebhookWithCallback(request *GetRepoWebhookRequest, callback func(response *GetRepoWebhookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoWebhookResponse
		var err error
		defer close(result)
		response, err = client.GetRepoWebhook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoWebhookRequest is the request struct for api GetRepoWebhook
type GetRepoWebhookRequest struct {
	*requests.RoaRequest
	RepoNamespace string `position:"Path" name:"RepoNamespace"`
	RepoName      string `position:"Path" name:"RepoName"`
}

// GetRepoWebhookResponse is the response struct for api GetRepoWebhook
type GetRepoWebhookResponse struct {
	*responses.BaseResponse
}

// CreateGetRepoWebhookRequest creates a request to invoke GetRepoWebhook API
func CreateGetRepoWebhookRequest() (request *GetRepoWebhookRequest) {
	request = &GetRepoWebhookRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRepoWebhook", "/repos/[RepoNamespace]/[RepoName]/webhooks", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRepoWebhookResponse creates a response to parse from GetRepoWebhook response
func CreateGetRepoWebhookResponse() (response *GetRepoWebhookResponse) {
	response = &GetRepoWebhookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
