package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoWebhookLogList invokes the cr.GetRepoWebhookLogList API synchronously
// api document: https://help.aliyun.com/api/cr/getrepowebhookloglist.html
func (client *Client) GetRepoWebhookLogList(request *GetRepoWebhookLogListRequest) (response *GetRepoWebhookLogListResponse, err error) {
	response = CreateGetRepoWebhookLogListResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoWebhookLogListWithChan invokes the cr.GetRepoWebhookLogList API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepowebhookloglist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoWebhookLogListWithChan(request *GetRepoWebhookLogListRequest) (<-chan *GetRepoWebhookLogListResponse, <-chan error) {
	responseChan := make(chan *GetRepoWebhookLogListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoWebhookLogList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoWebhookLogListWithCallback invokes the cr.GetRepoWebhookLogList API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepowebhookloglist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoWebhookLogListWithCallback(request *GetRepoWebhookLogListRequest, callback func(response *GetRepoWebhookLogListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoWebhookLogListResponse
		var err error
		defer close(result)
		response, err = client.GetRepoWebhookLogList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoWebhookLogListRequest is the request struct for api GetRepoWebhookLogList
type GetRepoWebhookLogListRequest struct {
	*requests.RoaRequest
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	WebhookId     requests.Integer `position:"Path" name:"WebhookId"`
	RepoName      string           `position:"Path" name:"RepoName"`
}

// GetRepoWebhookLogListResponse is the response struct for api GetRepoWebhookLogList
type GetRepoWebhookLogListResponse struct {
	*responses.BaseResponse
}

// CreateGetRepoWebhookLogListRequest creates a request to invoke GetRepoWebhookLogList API
func CreateGetRepoWebhookLogListRequest() (request *GetRepoWebhookLogListRequest) {
	request = &GetRepoWebhookLogListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRepoWebhookLogList", "/repos/[RepoNamespace]/[RepoName]/webhooks/[WebhookId]/logs", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRepoWebhookLogListResponse creates a response to parse from GetRepoWebhookLogList response
func CreateGetRepoWebhookLogListResponse() (response *GetRepoWebhookLogListResponse) {
	response = &GetRepoWebhookLogListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
