package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserSourceRepoList invokes the cr.GetUserSourceRepoList API synchronously
// api document: https://help.aliyun.com/api/cr/getusersourcerepolist.html
func (client *Client) GetUserSourceRepoList(request *GetUserSourceRepoListRequest) (response *GetUserSourceRepoListResponse, err error) {
	response = CreateGetUserSourceRepoListResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserSourceRepoListWithChan invokes the cr.GetUserSourceRepoList API asynchronously
// api document: https://help.aliyun.com/api/cr/getusersourcerepolist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserSourceRepoListWithChan(request *GetUserSourceRepoListRequest) (<-chan *GetUserSourceRepoListResponse, <-chan error) {
	responseChan := make(chan *GetUserSourceRepoListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserSourceRepoList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserSourceRepoListWithCallback invokes the cr.GetUserSourceRepoList API asynchronously
// api document: https://help.aliyun.com/api/cr/getusersourcerepolist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserSourceRepoListWithCallback(request *GetUserSourceRepoListRequest, callback func(response *GetUserSourceRepoListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserSourceRepoListResponse
		var err error
		defer close(result)
		response, err = client.GetUserSourceRepoList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserSourceRepoListRequest is the request struct for api GetUserSourceRepoList
type GetUserSourceRepoListRequest struct {
	*requests.RoaRequest
	SourceAccountId requests.Integer `position:"Path" name:"SourceAccountId"`
}

// GetUserSourceRepoListResponse is the response struct for api GetUserSourceRepoList
type GetUserSourceRepoListResponse struct {
	*responses.BaseResponse
}

// CreateGetUserSourceRepoListRequest creates a request to invoke GetUserSourceRepoList API
func CreateGetUserSourceRepoListRequest() (request *GetUserSourceRepoListRequest) {
	request = &GetUserSourceRepoListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetUserSourceRepoList", "/users/sourceAccount/[SourceAccountId]/repos", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetUserSourceRepoListResponse creates a response to parse from GetUserSourceRepoList response
func CreateGetUserSourceRepoListResponse() (response *GetUserSourceRepoListResponse) {
	response = &GetUserSourceRepoListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
