package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEdgeClusterAttachScripts invokes the cs.DescribeEdgeClusterAttachScripts API synchronously
// api document: https://help.aliyun.com/api/cs/describeedgeclusterattachscripts.html
func (client *Client) DescribeEdgeClusterAttachScripts(request *DescribeEdgeClusterAttachScriptsRequest) (response *DescribeEdgeClusterAttachScriptsResponse, err error) {
	response = CreateDescribeEdgeClusterAttachScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEdgeClusterAttachScriptsWithChan invokes the cs.DescribeEdgeClusterAttachScripts API asynchronously
// api document: https://help.aliyun.com/api/cs/describeedgeclusterattachscripts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEdgeClusterAttachScriptsWithChan(request *DescribeEdgeClusterAttachScriptsRequest) (<-chan *DescribeEdgeClusterAttachScriptsResponse, <-chan error) {
	responseChan := make(chan *DescribeEdgeClusterAttachScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEdgeClusterAttachScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEdgeClusterAttachScriptsWithCallback invokes the cs.DescribeEdgeClusterAttachScripts API asynchronously
// api document: https://help.aliyun.com/api/cs/describeedgeclusterattachscripts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEdgeClusterAttachScriptsWithCallback(request *DescribeEdgeClusterAttachScriptsRequest, callback func(response *DescribeEdgeClusterAttachScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEdgeClusterAttachScriptsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEdgeClusterAttachScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEdgeClusterAttachScriptsRequest is the request struct for api DescribeEdgeClusterAttachScripts
type DescribeEdgeClusterAttachScriptsRequest struct {
	*requests.RoaRequest
	ClusterId  string `position:"Path" name:"ClusterId"`
	NamePrefix string `position:"Query" name:"NamePrefix"`
}

// DescribeEdgeClusterAttachScriptsResponse is the response struct for api DescribeEdgeClusterAttachScripts
type DescribeEdgeClusterAttachScriptsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeEdgeClusterAttachScriptsRequest creates a request to invoke DescribeEdgeClusterAttachScripts API
func CreateDescribeEdgeClusterAttachScriptsRequest() (request *DescribeEdgeClusterAttachScriptsRequest) {
	request = &DescribeEdgeClusterAttachScriptsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeEdgeClusterAttachScripts", "/clusters/[ClusterId]/attachscript", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeEdgeClusterAttachScriptsResponse creates a response to parse from DescribeEdgeClusterAttachScripts response
func CreateDescribeEdgeClusterAttachScriptsResponse() (response *DescribeEdgeClusterAttachScriptsResponse) {
	response = &DescribeEdgeClusterAttachScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
