//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigureMigrationJob invokes the dts.ConfigureMigrationJob API synchronously
// api document: https://help.aliyun.com/api/dts/configuremigrationjob.html
func (client *Client) ConfigureMigrationJob(request *ConfigureMigrationJobRequest) (response *ConfigureMigrationJobResponse, err error) {
	response = CreateConfigureMigrationJobResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigureMigrationJobWithChan invokes the dts.ConfigureMigrationJob API asynchronously
// api document: https://help.aliyun.com/api/dts/configuremigrationjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigureMigrationJobWithChan(request *ConfigureMigrationJobRequest) (<-chan *ConfigureMigrationJobResponse, <-chan error) {
	responseChan := make(chan *ConfigureMigrationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigureMigrationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigureMigrationJobWithCallback invokes the dts.ConfigureMigrationJob API asynchronously
// api document: https://help.aliyun.com/api/dts/configuremigrationjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigureMigrationJobWithCallback(request *ConfigureMigrationJobRequest, callback func(response *ConfigureMigrationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigureMigrationJobResponse
		var err error
		defer close(result)
		response, err = client.ConfigureMigrationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigureMigrationJobRequest is the request struct for api ConfigureMigrationJob
type ConfigureMigrationJobRequest struct {
	*requests.RpcRequest
	MigrationJobId      string                                   `position:"Query" name:"MigrationJobId"`
	MigrationJobName    string                                   `position:"Query" name:"MigrationJobName"`
	MigrationObject     string                                   `position:"Query" name:"MigrationObject"`
	MigrationReserved   string                                   `position:"Query" name:"MigrationReserved"`
	Checkpoint          string                                   `position:"Query" name:"Checkpoint"`
	OwnerId             string                                   `position:"Query" name:"OwnerId"`
	SourceEndpoint      ConfigureMigrationJobSourceEndpoint      `position:"Query" name:"SourceEndpoint" type:"Struct"`
	DestinationEndpoint ConfigureMigrationJobDestinationEndpoint `position:"Query" name:"DestinationEndpoint" type:"Struct"`
	MigrationMode       ConfigureMigrationJobMigrationMode       `position:"Query" name:"MigrationMode" type:"Struct"`
}

type ConfigureMigrationJobSourceEndpoint struct {
	InstanceType string `name:"InstanceType"`
	InstanceID   string `name:"InstanceID"`
	EngineName   string `name:"EngineName"`
	Region       string `name:"Region"`
	IP           string `name:"IP"`
	Port         string `name:"Port"`
	OracleSID    string `name:"OracleSID"`
	DatabaseName string `name:"DatabaseName"`
	UserName     string `name:"UserName"`
	Password     string `name:"Password"`
	OwnerID      string `name:"OwnerID"`
	Role         string `name:"Role"`
}

type ConfigureMigrationJobDestinationEndpoint struct {
	InstanceType string `name:"InstanceType"`
	InstanceID   string `name:"InstanceID"`
	EngineName   string `name:"EngineName"`
	Region       string `name:"Region"`
	IP           string `name:"IP"`
	Port         string `name:"Port"`
	DataBaseName string `name:"DataBaseName"`
	UserName     string `name:"UserName"`
	Password     string `name:"Password"`
}

type ConfigureMigrationJobMigrationMode struct {
	StructureIntialization requests.Boolean `name:"StructureIntialization"`
	DataIntialization      requests.Boolean `name:"DataIntialization"`
	DataSynchronization    requests.Boolean `name:"DataSynchronization"`
}

// ConfigureMigrationJobResponse is the response struct for api ConfigureMigrationJob
type ConfigureMigrationJobResponse struct {
	*responses.BaseResponse
	Success    string `json:"Success" xml:"Success"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigureMigrationJobRequest creates a request to invoke ConfigureMigrationJob API
func CreateConfigureMigrationJobRequest() (request *ConfigureMigrationJobRequest) {
	request = &ConfigureMigrationJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "ConfigureMigrationJob", "dts", "openAPI")
	return
}

// CreateConfigureMigrationJobResponse creates a response to parse from ConfigureMigrationJob response
func CreateConfigureMigrationJobResponse() (response *ConfigureMigrationJobResponse) {
	response = &ConfigureMigrationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
