//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSynchronizationJob invokes the dts.DeleteSynchronizationJob API synchronously
// api document: https://help.aliyun.com/api/dts/deletesynchronizationjob.html
func (client *Client) DeleteSynchronizationJob(request *DeleteSynchronizationJobRequest) (response *DeleteSynchronizationJobResponse, err error) {
	response = CreateDeleteSynchronizationJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSynchronizationJobWithChan invokes the dts.DeleteSynchronizationJob API asynchronously
// api document: https://help.aliyun.com/api/dts/deletesynchronizationjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSynchronizationJobWithChan(request *DeleteSynchronizationJobRequest) (<-chan *DeleteSynchronizationJobResponse, <-chan error) {
	responseChan := make(chan *DeleteSynchronizationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSynchronizationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSynchronizationJobWithCallback invokes the dts.DeleteSynchronizationJob API asynchronously
// api document: https://help.aliyun.com/api/dts/deletesynchronizationjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSynchronizationJobWithCallback(request *DeleteSynchronizationJobRequest, callback func(response *DeleteSynchronizationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSynchronizationJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteSynchronizationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSynchronizationJobRequest is the request struct for api DeleteSynchronizationJob
type DeleteSynchronizationJobRequest struct {
	*requests.RpcRequest
	SynchronizationJobId string `position:"Query" name:"SynchronizationJobId"`
	OwnerId              string `position:"Query" name:"OwnerId"`
}

// DeleteSynchronizationJobResponse is the response struct for api DeleteSynchronizationJob
type DeleteSynchronizationJobResponse struct {
	*responses.BaseResponse
	Success    string `json:"Success" xml:"Success"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSynchronizationJobRequest creates a request to invoke DeleteSynchronizationJob API
func CreateDeleteSynchronizationJobRequest() (request *DeleteSynchronizationJobRequest) {
	request = &DeleteSynchronizationJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DeleteSynchronizationJob", "dts", "openAPI")
	return
}

// CreateDeleteSynchronizationJobResponse creates a response to parse from DeleteSynchronizationJob response
func CreateDeleteSynchronizationJobResponse() (response *DeleteSynchronizationJobResponse) {
	response = &DeleteSynchronizationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
