//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEndpointSwitchStatus invokes the dts.DescribeEndpointSwitchStatus API synchronously
// api document: https://help.aliyun.com/api/dts/describeendpointswitchstatus.html
func (client *Client) DescribeEndpointSwitchStatus(request *DescribeEndpointSwitchStatusRequest) (response *DescribeEndpointSwitchStatusResponse, err error) {
	response = CreateDescribeEndpointSwitchStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEndpointSwitchStatusWithChan invokes the dts.DescribeEndpointSwitchStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describeendpointswitchstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEndpointSwitchStatusWithChan(request *DescribeEndpointSwitchStatusRequest) (<-chan *DescribeEndpointSwitchStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeEndpointSwitchStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEndpointSwitchStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEndpointSwitchStatusWithCallback invokes the dts.DescribeEndpointSwitchStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describeendpointswitchstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEndpointSwitchStatusWithCallback(request *DescribeEndpointSwitchStatusRequest, callback func(response *DescribeEndpointSwitchStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEndpointSwitchStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeEndpointSwitchStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEndpointSwitchStatusRequest is the request struct for api DescribeEndpointSwitchStatus
type DescribeEndpointSwitchStatusRequest struct {
	*requests.RpcRequest
	TaskId      string `position:"Query" name:"TaskId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	OwnerId     string `position:"Query" name:"OwnerId"`
}

// DescribeEndpointSwitchStatusResponse is the response struct for api DescribeEndpointSwitchStatus
type DescribeEndpointSwitchStatusResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Status       string `json:"Status" xml:"Status"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDescribeEndpointSwitchStatusRequest creates a request to invoke DescribeEndpointSwitchStatus API
func CreateDescribeEndpointSwitchStatusRequest() (request *DescribeEndpointSwitchStatusRequest) {
	request = &DescribeEndpointSwitchStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeEndpointSwitchStatus", "dts", "openAPI")
	return
}

// CreateDescribeEndpointSwitchStatusResponse creates a response to parse from DescribeEndpointSwitchStatus response
func CreateDescribeEndpointSwitchStatusResponse() (response *DescribeEndpointSwitchStatusResponse) {
	response = &DescribeEndpointSwitchStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
