//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInitializationStatus invokes the dts.DescribeInitializationStatus API synchronously
// api document: https://help.aliyun.com/api/dts/describeinitializationstatus.html
func (client *Client) DescribeInitializationStatus(request *DescribeInitializationStatusRequest) (response *DescribeInitializationStatusResponse, err error) {
	response = CreateDescribeInitializationStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInitializationStatusWithChan invokes the dts.DescribeInitializationStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describeinitializationstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInitializationStatusWithChan(request *DescribeInitializationStatusRequest) (<-chan *DescribeInitializationStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeInitializationStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInitializationStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInitializationStatusWithCallback invokes the dts.DescribeInitializationStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describeinitializationstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInitializationStatusWithCallback(request *DescribeInitializationStatusRequest, callback func(response *DescribeInitializationStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInitializationStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeInitializationStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInitializationStatusRequest is the request struct for api DescribeInitializationStatus
type DescribeInitializationStatusRequest struct {
	*requests.RpcRequest
	SynchronizationJobId string           `position:"Query" name:"SynchronizationJobId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	PageNum              requests.Integer `position:"Query" name:"PageNum"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
}

// DescribeInitializationStatusResponse is the response struct for api DescribeInitializationStatus
type DescribeInitializationStatusResponse struct {
	*responses.BaseResponse
	StructureInitializationDetails DescribeInitializationStatusStructureInitializationDetails0 `json:"StructureInitializationDetails" xml:"StructureInitializationDetails"`
	DataInitializationDetails      DescribeInitializationStatusDataInitializationDetails0      `json:"DataInitializationDetails" xml:"DataInitializationDetails"`
	DataSynchronizationDetails     DescribeInitializationStatusDataSynchronizationDetails0     `json:"DataSynchronizationDetails" xml:"DataSynchronizationDetails"`
}

type DescribeInitializationStatusStructureInitializationDetails0 struct {
	StructureInitializationDetail []DescribeInitializationStatusStructureInitializationDetail1 `json:"StructureInitializationDetail" xml:"StructureInitializationDetail"`
}

type DescribeInitializationStatusStructureInitializationDetail1 struct {
	ObjectName             string                                     `json:"ObjectName" xml:"ObjectName"`
	ObjectType             string                                     `json:"ObjectType" xml:"ObjectType"`
	SourceOwnerDBName      string                                     `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string                                     `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string                                     `json:"Status" xml:"Status"`
	ErrorMessage           string                                     `json:"ErrorMessage" xml:"ErrorMessage"`
	ObjectDefinition       string                                     `json:"ObjectDefinition" xml:"ObjectDefinition"`
	Constraints            []DescribeInitializationStatusConstraints1 `json:"Constraints" xml:"Constraints"`
}

type DescribeInitializationStatusDataInitializationDetails0 struct {
	DataInitializationDetail []DescribeInitializationStatusDataInitializationDetail1 `json:"DataInitializationDetail" xml:"DataInitializationDetail"`
}

type DescribeInitializationStatusDataInitializationDetail1 struct {
	TableName              string `json:"TableName" xml:"TableName"`
	SourceOwnerDBName      string `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string `json:"Status" xml:"Status"`
	ErrorMessage           string `json:"ErrorMessage" xml:"ErrorMessage"`
	TotalRowNum            string `json:"TotalRowNum" xml:"TotalRowNum"`
	FinishRowNum           string `json:"FinishRowNum" xml:"FinishRowNum"`
	UsedTime               string `json:"UsedTime" xml:"UsedTime"`
}

type DescribeInitializationStatusDataSynchronizationDetails0 struct {
	DataSynchronizationDetail []DescribeInitializationStatusDataSynchronizationDetail1 `json:"DataSynchronizationDetail" xml:"DataSynchronizationDetail"`
}

type DescribeInitializationStatusDataSynchronizationDetail1 struct {
	TableName              string `json:"TableName" xml:"TableName"`
	SourceOwnerDBName      string `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string `json:"Status" xml:"Status"`
	ErrorMessage           string `json:"ErrorMessage" xml:"ErrorMessage"`
}

type DescribeInitializationStatusConstraints1 struct {
	StructureInitializationDetail []DescribeInitializationStatusStructureInitializationDetail2 `json:"StructureInitializationDetail" xml:"StructureInitializationDetail"`
}

type DescribeInitializationStatusStructureInitializationDetail2 struct {
	ObjectName             string `json:"ObjectName" xml:"ObjectName"`
	ObjectType             string `json:"ObjectType" xml:"ObjectType"`
	SourceOwnerDBName      string `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string `json:"Status" xml:"Status"`
	ErrorMessage           string `json:"ErrorMessage" xml:"ErrorMessage"`
	ObjectDefinition       string `json:"ObjectDefinition" xml:"ObjectDefinition"`
}

// CreateDescribeInitializationStatusRequest creates a request to invoke DescribeInitializationStatus API
func CreateDescribeInitializationStatusRequest() (request *DescribeInitializationStatusRequest) {
	request = &DescribeInitializationStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeInitializationStatus", "dts", "openAPI")
	return
}

// CreateDescribeInitializationStatusResponse creates a response to parse from DescribeInitializationStatus response
func CreateDescribeInitializationStatusResponse() (response *DescribeInitializationStatusResponse) {
	response = &DescribeInitializationStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
