//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSynchronizationJobs invokes the dts.DescribeSynchronizationJobs API synchronously
// api document: https://help.aliyun.com/api/dts/describesynchronizationjobs.html
func (client *Client) DescribeSynchronizationJobs(request *DescribeSynchronizationJobsRequest) (response *DescribeSynchronizationJobsResponse, err error) {
	response = CreateDescribeSynchronizationJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSynchronizationJobsWithChan invokes the dts.DescribeSynchronizationJobs API asynchronously
// api document: https://help.aliyun.com/api/dts/describesynchronizationjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSynchronizationJobsWithChan(request *DescribeSynchronizationJobsRequest) (<-chan *DescribeSynchronizationJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeSynchronizationJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSynchronizationJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSynchronizationJobsWithCallback invokes the dts.DescribeSynchronizationJobs API asynchronously
// api document: https://help.aliyun.com/api/dts/describesynchronizationjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSynchronizationJobsWithCallback(request *DescribeSynchronizationJobsRequest, callback func(response *DescribeSynchronizationJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSynchronizationJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSynchronizationJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSynchronizationJobsRequest is the request struct for api DescribeSynchronizationJobs
type DescribeSynchronizationJobsRequest struct {
	*requests.RpcRequest
	PageSize               requests.Integer `position:"Query" name:"PageSize"`
	PageNum                requests.Integer `position:"Query" name:"PageNum"`
	SynchronizationJobName string           `position:"Query" name:"SynchronizationJobName"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	OwnerId                string           `position:"Query" name:"OwnerId"`
}

// DescribeSynchronizationJobsResponse is the response struct for api DescribeSynchronizationJobs
type DescribeSynchronizationJobsResponse struct {
	*responses.BaseResponse
	RequestId                string                                               `json:"RequestId" xml:"RequestId"`
	PageNumber               int                                                  `json:"PageNumber" xml:"PageNumber"`
	TotalRecordCount         int64                                                `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageRecordCount          int                                                  `json:"PageRecordCount" xml:"PageRecordCount"`
	SynchronizationInstances DescribeSynchronizationJobsSynchronizationInstances0 `json:"SynchronizationInstances" xml:"SynchronizationInstances"`
}

type DescribeSynchronizationJobsSynchronizationInstances0 struct {
	SynchronizationInstance []DescribeSynchronizationJobsSynchronizationInstance1 `json:"SynchronizationInstance" xml:"SynchronizationInstance"`
}

type DescribeSynchronizationJobsSynchronizationInstance1 struct {
	SynchronizationJobId          string                                                    `json:"SynchronizationJobId" xml:"SynchronizationJobId"`
	SynchronizationDirection      string                                                    `json:"SynchronizationDirection" xml:"SynchronizationDirection"`
	SynchronizationJobName        string                                                    `json:"SynchronizationJobName" xml:"SynchronizationJobName"`
	SynchronizationJobClass       string                                                    `json:"SynchronizationJobClass" xml:"SynchronizationJobClass"`
	PayType                       string                                                    `json:"PayType" xml:"PayType"`
	ExpireTime                    string                                                    `json:"ExpireTime" xml:"ExpireTime"`
	StructureInitialization       string                                                    `json:"StructureInitialization" xml:"StructureInitialization"`
	DataInitialization            string                                                    `json:"DataInitialization" xml:"DataInitialization"`
	Status                        string                                                    `json:"Status" xml:"Status"`
	ErrorMessage                  string                                                    `json:"ErrorMessage" xml:"ErrorMessage"`
	Delay                         string                                                    `json:"Delay" xml:"Delay"`
	SynchronizationObjects        []DescribeSynchronizationJobsSynchronizationObjects1      `json:"SynchronizationObjects" xml:"SynchronizationObjects"`
	SourceEndpoint                DescribeSynchronizationJobsSourceEndpoint1                `json:"SourceEndpoint" xml:"SourceEndpoint"`
	DestinationEndpoint           DescribeSynchronizationJobsDestinationEndpoint1           `json:"DestinationEndpoint" xml:"DestinationEndpoint"`
	PrecheckStatus                DescribeSynchronizationJobsPrecheckStatus1                `json:"PrecheckStatus" xml:"PrecheckStatus"`
	StructureInitializationStatus DescribeSynchronizationJobsStructureInitializationStatus1 `json:"StructureInitializationStatus" xml:"StructureInitializationStatus"`
	DataInitializationStatus      DescribeSynchronizationJobsDataInitializationStatus1      `json:"DataInitializationStatus" xml:"DataInitializationStatus"`
	DataSynchronizationStatus     DescribeSynchronizationJobsDataSynchronizationStatus1     `json:"DataSynchronizationStatus" xml:"DataSynchronizationStatus"`
	Performance                   DescribeSynchronizationJobsPerformance1                   `json:"Performance" xml:"Performance"`
}

type DescribeSynchronizationJobsSynchronizationObjects1 struct {
	SynchronizationObject []DescribeSynchronizationJobsSynchronizationObject2 `json:"SynchronizationObject" xml:"SynchronizationObject"`
}

type DescribeSynchronizationJobsSynchronizationObject2 struct {
	SchemaName    string                                      `json:"SchemaName" xml:"SchemaName"`
	NewSchemaName string                                      `json:"NewSchemaName" xml:"NewSchemaName"`
	TableIncludes []DescribeSynchronizationJobsTableIncludes2 `json:"TableIncludes" xml:"TableIncludes"`
	TableExcludes []DescribeSynchronizationJobsTableExcludes2 `json:"TableExcludes" xml:"TableExcludes"`
}

type DescribeSynchronizationJobsTableIncludes2 struct {
	TableInclude []DescribeSynchronizationJobsTableInclude3 `json:"TableInclude" xml:"TableInclude"`
}

type DescribeSynchronizationJobsTableInclude3 struct {
	TableName string `json:"TableName" xml:"TableName"`
}

type DescribeSynchronizationJobsTableExcludes2 struct {
	TableExclude []DescribeSynchronizationJobsTableExclude3 `json:"TableExclude" xml:"TableExclude"`
}

type DescribeSynchronizationJobsTableExclude3 struct {
	TableName string `json:"TableName" xml:"TableName"`
}

type DescribeSynchronizationJobsSourceEndpoint1 struct {
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeSynchronizationJobsDestinationEndpoint1 struct {
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeSynchronizationJobsPrecheckStatus1 struct {
	Status  string                               `json:"Status" xml:"Status"`
	Percent string                               `json:"Percent" xml:"Percent"`
	Detail  []DescribeSynchronizationJobsDetail2 `json:"Detail" xml:"Detail"`
}

type DescribeSynchronizationJobsDetail2 struct {
	CheckItem []DescribeSynchronizationJobsCheckItem3 `json:"CheckItem" xml:"CheckItem"`
}

type DescribeSynchronizationJobsCheckItem3 struct {
	ItemName     string `json:"ItemName" xml:"ItemName"`
	CheckStatus  string `json:"CheckStatus" xml:"CheckStatus"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RepairMethod string `json:"RepairMethod" xml:"RepairMethod"`
}

type DescribeSynchronizationJobsStructureInitializationStatus1 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeSynchronizationJobsDataInitializationStatus1 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeSynchronizationJobsDataSynchronizationStatus1 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Delay        string `json:"Delay" xml:"Delay"`
}

type DescribeSynchronizationJobsPerformance1 struct {
	RPS  string `json:"RPS" xml:"RPS"`
	FLOW string `json:"FLOW" xml:"FLOW"`
}

// CreateDescribeSynchronizationJobsRequest creates a request to invoke DescribeSynchronizationJobs API
func CreateDescribeSynchronizationJobsRequest() (request *DescribeSynchronizationJobsRequest) {
	request = &DescribeSynchronizationJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeSynchronizationJobs", "dts", "openAPI")
	return
}

// CreateDescribeSynchronizationJobsResponse creates a response to parse from DescribeSynchronizationJobs response
func CreateDescribeSynchronizationJobsResponse() (response *DescribeSynchronizationJobsResponse) {
	response = &DescribeSynchronizationJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
