package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// IvrCall invokes the dyvmsapi.IvrCall API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/ivrcall.html
func (client *Client) IvrCall(request *IvrCallRequest) (response *IvrCallResponse, err error) {
	response = CreateIvrCallResponse()
	err = client.DoAction(request, response)
	return
}

// IvrCallWithChan invokes the dyvmsapi.IvrCall API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/ivrcall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) IvrCallWithChan(request *IvrCallRequest) (<-chan *IvrCallResponse, <-chan error) {
	responseChan := make(chan *IvrCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.IvrCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// IvrCallWithCallback invokes the dyvmsapi.IvrCall API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/ivrcall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) IvrCallWithCallback(request *IvrCallRequest, callback func(response *IvrCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *IvrCallResponse
		var err error
		defer close(result)
		response, err = client.IvrCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// IvrCallRequest is the request struct for api IvrCall
type IvrCallRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer     `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string               `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer     `position:"Query" name:"ResourceOwnerId"`
	CalledShowNumber     string               `position:"Query" name:"CalledShowNumber"`
	CalledNumber         string               `position:"Query" name:"CalledNumber"`
	StartCode            string               `position:"Query" name:"StartCode"`
	StartTtsParams       string               `position:"Query" name:"StartTtsParams"`
	MenuKeyMap           *[]IvrCallMenuKeyMap `position:"Query" name:"MenuKeyMap"  type:"Repeated"`
	PlayTimes            requests.Integer     `position:"Query" name:"PlayTimes"`
	ByeCode              string               `position:"Query" name:"ByeCode"`
	ByeTtsParams         string               `position:"Query" name:"ByeTtsParams"`
	Timeout              requests.Integer     `position:"Query" name:"Timeout"`
	OutId                string               `position:"Query" name:"OutId"`
}

// IvrCallMenuKeyMap is a repeated param struct in IvrCallRequest
type IvrCallMenuKeyMap struct {
	Key       string `name:"Key"`
	Code      string `name:"Code"`
	TtsParams string `name:"TtsParams"`
}

// IvrCallResponse is the response struct for api IvrCall
type IvrCallResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CallId    string `json:"CallId" xml:"CallId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateIvrCallRequest creates a request to invoke IvrCall API
func CreateIvrCallRequest() (request *IvrCallRequest) {
	request = &IvrCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "IvrCall", "", "")
	return
}

// CreateIvrCallResponse creates a response to parse from IvrCall response
func CreateIvrCallResponse() (response *IvrCallResponse) {
	response = &IvrCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
