//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeContainerLog invokes the eci.DescribeContainerLog API synchronously
// api document: https://help.aliyun.com/api/eci/describecontainerlog.html
func (client *Client) DescribeContainerLog(request *DescribeContainerLogRequest) (response *DescribeContainerLogResponse, err error) {
	response = CreateDescribeContainerLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeContainerLogWithChan invokes the eci.DescribeContainerLog API asynchronously
// api document: https://help.aliyun.com/api/eci/describecontainerlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeContainerLogWithChan(request *DescribeContainerLogRequest) (<-chan *DescribeContainerLogResponse, <-chan error) {
	responseChan := make(chan *DescribeContainerLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeContainerLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeContainerLogWithCallback invokes the eci.DescribeContainerLog API asynchronously
// api document: https://help.aliyun.com/api/eci/describecontainerlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeContainerLogWithCallback(request *DescribeContainerLogRequest, callback func(response *DescribeContainerLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeContainerLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeContainerLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeContainerLogRequest is the request struct for api DescribeContainerLog
type DescribeContainerLogRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	ContainerGroupId     string           `position:"Query" name:"ContainerGroupId"`
	ContainerName        string           `position:"Query" name:"ContainerName"`
	StartTime            string           `position:"Query" name:"StartTime"`
	Tail                 requests.Integer `position:"Query" name:"Tail"`
}

// DescribeContainerLogResponse is the response struct for api DescribeContainerLog
type DescribeContainerLogResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ContainerName string `json:"ContainerName" xml:"ContainerName"`
	Content       string `json:"Content" xml:"Content"`
}

// CreateDescribeContainerLogRequest creates a request to invoke DescribeContainerLog API
func CreateDescribeContainerLogRequest() (request *DescribeContainerLogRequest) {
	request = &DescribeContainerLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "DescribeContainerLog", "eci", "openAPI")
	return
}

// CreateDescribeContainerLogResponse creates a response to parse from DescribeContainerLog response
func CreateDescribeContainerLogResponse() (response *DescribeContainerLogResponse) {
	response = &DescribeContainerLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
