//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateContainerGroupByTemplate invokes the eci.UpdateContainerGroupByTemplate API synchronously
// api document: https://help.aliyun.com/api/eci/updatecontainergroupbytemplate.html
func (client *Client) UpdateContainerGroupByTemplate(request *UpdateContainerGroupByTemplateRequest) (response *UpdateContainerGroupByTemplateResponse, err error) {
	response = CreateUpdateContainerGroupByTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateContainerGroupByTemplateWithChan invokes the eci.UpdateContainerGroupByTemplate API asynchronously
// api document: https://help.aliyun.com/api/eci/updatecontainergroupbytemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateContainerGroupByTemplateWithChan(request *UpdateContainerGroupByTemplateRequest) (<-chan *UpdateContainerGroupByTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateContainerGroupByTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateContainerGroupByTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateContainerGroupByTemplateWithCallback invokes the eci.UpdateContainerGroupByTemplate API asynchronously
// api document: https://help.aliyun.com/api/eci/updatecontainergroupbytemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateContainerGroupByTemplateWithCallback(request *UpdateContainerGroupByTemplateRequest, callback func(response *UpdateContainerGroupByTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateContainerGroupByTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateContainerGroupByTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateContainerGroupByTemplateRequest is the request struct for api UpdateContainerGroupByTemplate
type UpdateContainerGroupByTemplateRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	Template             string           `position:"Body" name:"Template"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
}

// UpdateContainerGroupByTemplateResponse is the response struct for api UpdateContainerGroupByTemplate
type UpdateContainerGroupByTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateContainerGroupByTemplateRequest creates a request to invoke UpdateContainerGroupByTemplate API
func CreateUpdateContainerGroupByTemplateRequest() (request *UpdateContainerGroupByTemplateRequest) {
	request = &UpdateContainerGroupByTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "UpdateContainerGroupByTemplate", "eci", "openAPI")
	return
}

// CreateUpdateContainerGroupByTemplateResponse creates a response to parse from UpdateContainerGroupByTemplate response
func CreateUpdateContainerGroupByTemplateResponse() (response *UpdateContainerGroupByTemplateResponse) {
	response = &UpdateContainerGroupByTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
