package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCluster invokes the ehpc.CreateCluster API synchronously
// api document: https://help.aliyun.com/api/ehpc/createcluster.html
func (client *Client) CreateCluster(request *CreateClusterRequest) (response *CreateClusterResponse, err error) {
	response = CreateCreateClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClusterWithChan invokes the ehpc.CreateCluster API asynchronously
// api document: https://help.aliyun.com/api/ehpc/createcluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateClusterWithChan(request *CreateClusterRequest) (<-chan *CreateClusterResponse, <-chan error) {
	responseChan := make(chan *CreateClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterWithCallback invokes the ehpc.CreateCluster API asynchronously
// api document: https://help.aliyun.com/api/ehpc/createcluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateClusterWithCallback(request *CreateClusterRequest, callback func(response *CreateClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterRequest is the request struct for api CreateCluster
type CreateClusterRequest struct {
	*requests.RpcRequest
	SccClusterId                string                            `position:"Query" name:"SccClusterId"`
	ImageId                     string                            `position:"Query" name:"ImageId"`
	AdditionalVolumes           *[]CreateClusterAdditionalVolumes `position:"Query" name:"AdditionalVolumes"  type:"Repeated"`
	EcsOrderManagerInstanceType string                            `position:"Query" name:"EcsOrder.Manager.InstanceType"`
	EhpcVersion                 string                            `position:"Query" name:"EhpcVersion"`
	AccountType                 string                            `position:"Query" name:"AccountType"`
	SecurityGroupId             string                            `position:"Query" name:"SecurityGroupId"`
	Description                 string                            `position:"Query" name:"Description"`
	KeyPairName                 string                            `position:"Query" name:"KeyPairName"`
	SecurityGroupName           string                            `position:"Query" name:"SecurityGroupName"`
	EcsOrderComputeInstanceType string                            `position:"Query" name:"EcsOrder.Compute.InstanceType"`
	JobQueue                    string                            `position:"Query" name:"JobQueue"`
	ImageOwnerAlias             string                            `position:"Query" name:"ImageOwnerAlias"`
	VolumeType                  string                            `position:"Query" name:"VolumeType"`
	DeployMode                  string                            `position:"Query" name:"DeployMode"`
	EcsOrderManagerCount        requests.Integer                  `position:"Query" name:"EcsOrder.Manager.Count"`
	ResourceGroupId             string                            `position:"Query" name:"ResourceGroupId"`
	Password                    string                            `position:"Query" name:"Password"`
	EcsOrderLoginCount          requests.Integer                  `position:"Query" name:"EcsOrder.Login.Count"`
	RemoteVisEnable             string                            `position:"Query" name:"RemoteVisEnable"`
	SystemDiskSize              requests.Integer                  `position:"Query" name:"SystemDiskSize"`
	ComputeSpotPriceLimit       string                            `position:"Query" name:"ComputeSpotPriceLimit"`
	AutoRenewPeriod             requests.Integer                  `position:"Query" name:"AutoRenewPeriod"`
	Period                      requests.Integer                  `position:"Query" name:"Period"`
	VolumeProtocol              string                            `position:"Query" name:"VolumeProtocol"`
	ClientVersion               string                            `position:"Query" name:"ClientVersion"`
	OsTag                       string                            `position:"Query" name:"OsTag"`
	RemoteDirectory             string                            `position:"Query" name:"RemoteDirectory"`
	EcsOrderComputeCount        requests.Integer                  `position:"Query" name:"EcsOrder.Compute.Count"`
	ComputeSpotStrategy         string                            `position:"Query" name:"ComputeSpotStrategy"`
	PostInstallScript           *[]CreateClusterPostInstallScript `position:"Query" name:"PostInstallScript"  type:"Repeated"`
	VSwitchId                   string                            `position:"Query" name:"VSwitchId"`
	PeriodUnit                  string                            `position:"Query" name:"PeriodUnit"`
	Application                 *[]CreateClusterApplication       `position:"Query" name:"Application"  type:"Repeated"`
	AutoRenew                   string                            `position:"Query" name:"AutoRenew"`
	EcsChargeType               string                            `position:"Query" name:"EcsChargeType"`
	InputFileUrl                string                            `position:"Query" name:"InputFileUrl"`
	VpcId                       string                            `position:"Query" name:"VpcId"`
	HaEnable                    requests.Boolean                  `position:"Query" name:"HaEnable"`
	Name                        string                            `position:"Query" name:"Name"`
	SchedulerType               string                            `position:"Query" name:"SchedulerType"`
	VolumeId                    string                            `position:"Query" name:"VolumeId"`
	VolumeMountpoint            string                            `position:"Query" name:"VolumeMountpoint"`
	EcsOrderLoginInstanceType   string                            `position:"Query" name:"EcsOrder.Login.InstanceType"`
	ZoneId                      string                            `position:"Query" name:"ZoneId"`
}

// CreateClusterAdditionalVolumes is a repeated param struct in CreateClusterRequest
type CreateClusterAdditionalVolumes struct {
	VolumeType       string    `name:"VolumeType"`
	VolumeProtocol   string    `name:"VolumeProtocol"`
	LocalDirectory   string    `name:"LocalDirectory"`
	RemoteDirectory  string    `name:"RemoteDirectory"`
	Roles            *[]string `name:"Roles" type:"Repeated"`
	VolumeId         string    `name:"VolumeId"`
	VolumeMountpoint string    `name:"VolumeMountpoint"`
	Location         string    `name:"Location"`
	JobQueue         string    `name:"JobQueue"`
}

// CreateClusterPostInstallScript is a repeated param struct in CreateClusterRequest
type CreateClusterPostInstallScript struct {
	Args string `name:"Args"`
	Url  string `name:"Url"`
}

// CreateClusterApplication is a repeated param struct in CreateClusterRequest
type CreateClusterApplication struct {
	Tag string `name:"Tag"`
}

// CreateClusterResponse is the response struct for api CreateCluster
type CreateClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
}

// CreateCreateClusterRequest creates a request to invoke CreateCluster API
func CreateCreateClusterRequest() (request *CreateClusterRequest) {
	request = &CreateClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "CreateCluster", "ehs", "openAPI")
	return
}

// CreateCreateClusterResponse creates a response to parse from CreateCluster response
func CreateCreateClusterResponse() (response *CreateClusterResponse) {
	response = &CreateClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
