package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNodes invokes the ehpc.DeleteNodes API synchronously
// api document: https://help.aliyun.com/api/ehpc/deletenodes.html
func (client *Client) DeleteNodes(request *DeleteNodesRequest) (response *DeleteNodesResponse, err error) {
	response = CreateDeleteNodesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNodesWithChan invokes the ehpc.DeleteNodes API asynchronously
// api document: https://help.aliyun.com/api/ehpc/deletenodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNodesWithChan(request *DeleteNodesRequest) (<-chan *DeleteNodesResponse, <-chan error) {
	responseChan := make(chan *DeleteNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNodesWithCallback invokes the ehpc.DeleteNodes API asynchronously
// api document: https://help.aliyun.com/api/ehpc/deletenodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNodesWithCallback(request *DeleteNodesRequest, callback func(response *DeleteNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNodesResponse
		var err error
		defer close(result)
		response, err = client.DeleteNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNodesRequest is the request struct for api DeleteNodes
type DeleteNodesRequest struct {
	*requests.RpcRequest
	ReleaseInstance requests.Boolean       `position:"Query" name:"ReleaseInstance"`
	Instance        *[]DeleteNodesInstance `position:"Query" name:"Instance"  type:"Repeated"`
	ClusterId       string                 `position:"Query" name:"ClusterId"`
}

// DeleteNodesInstance is a repeated param struct in DeleteNodesRequest
type DeleteNodesInstance struct {
	Id string `name:"Id"`
}

// DeleteNodesResponse is the response struct for api DeleteNodes
type DeleteNodesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNodesRequest creates a request to invoke DeleteNodes API
func CreateDeleteNodesRequest() (request *DeleteNodesRequest) {
	request = &DeleteNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DeleteNodes", "ehs", "openAPI")
	return
}

// CreateDeleteNodesResponse creates a response to parse from DeleteNodes response
func CreateDeleteNodesResponse() (response *DeleteNodesResponse) {
	response = &DeleteNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
