package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVisualServicePasswd invokes the ehpc.ModifyVisualServicePasswd API synchronously
// api document: https://help.aliyun.com/api/ehpc/modifyvisualservicepasswd.html
func (client *Client) ModifyVisualServicePasswd(request *ModifyVisualServicePasswdRequest) (response *ModifyVisualServicePasswdResponse, err error) {
	response = CreateModifyVisualServicePasswdResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVisualServicePasswdWithChan invokes the ehpc.ModifyVisualServicePasswd API asynchronously
// api document: https://help.aliyun.com/api/ehpc/modifyvisualservicepasswd.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVisualServicePasswdWithChan(request *ModifyVisualServicePasswdRequest) (<-chan *ModifyVisualServicePasswdResponse, <-chan error) {
	responseChan := make(chan *ModifyVisualServicePasswdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVisualServicePasswd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVisualServicePasswdWithCallback invokes the ehpc.ModifyVisualServicePasswd API asynchronously
// api document: https://help.aliyun.com/api/ehpc/modifyvisualservicepasswd.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVisualServicePasswdWithCallback(request *ModifyVisualServicePasswdRequest, callback func(response *ModifyVisualServicePasswdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVisualServicePasswdResponse
		var err error
		defer close(result)
		response, err = client.ModifyVisualServicePasswd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVisualServicePasswdRequest is the request struct for api ModifyVisualServicePasswd
type ModifyVisualServicePasswdRequest struct {
	*requests.RpcRequest
	Passwd            string `position:"Query" name:"Passwd"`
	RunasUserPassword string `position:"Query" name:"RunasUserPassword"`
	RunasUser         string `position:"Query" name:"RunasUser"`
	ClusterId         string `position:"Query" name:"ClusterId"`
}

// ModifyVisualServicePasswdResponse is the response struct for api ModifyVisualServicePasswd
type ModifyVisualServicePasswdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyVisualServicePasswdRequest creates a request to invoke ModifyVisualServicePasswd API
func CreateModifyVisualServicePasswdRequest() (request *ModifyVisualServicePasswdRequest) {
	request = &ModifyVisualServicePasswdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ModifyVisualServicePasswd", "ehs", "openAPI")
	return
}

// CreateModifyVisualServicePasswdResponse creates a response to parse from ModifyVisualServicePasswd response
func CreateModifyVisualServicePasswdResponse() (response *ModifyVisualServicePasswdResponse) {
	response = &ModifyVisualServicePasswdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
