package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClusterHostGroup invokes the emr.CreateClusterHostGroup API synchronously
// api document: https://help.aliyun.com/api/emr/createclusterhostgroup.html
func (client *Client) CreateClusterHostGroup(request *CreateClusterHostGroupRequest) (response *CreateClusterHostGroupResponse, err error) {
	response = CreateCreateClusterHostGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClusterHostGroupWithChan invokes the emr.CreateClusterHostGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/createclusterhostgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateClusterHostGroupWithChan(request *CreateClusterHostGroupRequest) (<-chan *CreateClusterHostGroupResponse, <-chan error) {
	responseChan := make(chan *CreateClusterHostGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClusterHostGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterHostGroupWithCallback invokes the emr.CreateClusterHostGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/createclusterhostgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateClusterHostGroupWithCallback(request *CreateClusterHostGroupRequest, callback func(response *CreateClusterHostGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterHostGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateClusterHostGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterHostGroupRequest is the request struct for api CreateClusterHostGroup
type CreateClusterHostGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Comment         string           `position:"Query" name:"Comment"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	HostGroupName   string           `position:"Query" name:"HostGroupName"`
	HostGroupType   string           `position:"Query" name:"HostGroupType"`
}

// CreateClusterHostGroupResponse is the response struct for api CreateClusterHostGroup
type CreateClusterHostGroupResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	ClusterId   string `json:"ClusterId" xml:"ClusterId"`
	HostGroupId string `json:"HostGroupId" xml:"HostGroupId"`
}

// CreateCreateClusterHostGroupRequest creates a request to invoke CreateClusterHostGroup API
func CreateCreateClusterHostGroupRequest() (request *CreateClusterHostGroupRequest) {
	request = &CreateClusterHostGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateClusterHostGroup", "emr", "openAPI")
	return
}

// CreateCreateClusterHostGroupResponse creates a response to parse from CreateClusterHostGroup response
func CreateCreateClusterHostGroupResponse() (response *CreateClusterHostGroupResponse) {
	response = &CreateClusterHostGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
