package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNavNode invokes the emr.CreateNavNode API synchronously
// api document: https://help.aliyun.com/api/emr/createnavnode.html
func (client *Client) CreateNavNode(request *CreateNavNodeRequest) (response *CreateNavNodeResponse, err error) {
	response = CreateCreateNavNodeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNavNodeWithChan invokes the emr.CreateNavNode API asynchronously
// api document: https://help.aliyun.com/api/emr/createnavnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNavNodeWithChan(request *CreateNavNodeRequest) (<-chan *CreateNavNodeResponse, <-chan error) {
	responseChan := make(chan *CreateNavNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNavNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNavNodeWithCallback invokes the emr.CreateNavNode API asynchronously
// api document: https://help.aliyun.com/api/emr/createnavnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNavNodeWithCallback(request *CreateNavNodeRequest, callback func(response *CreateNavNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNavNodeResponse
		var err error
		defer close(result)
		response, err = client.CreateNavNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNavNodeRequest is the request struct for api CreateNavNode
type CreateNavNodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	Type            string           `position:"Query" name:"Type"`
	ProjectId       string           `position:"Query" name:"ProjectId"`
	CategoryType    string           `position:"Query" name:"CategoryType"`
	ObjectId        string           `position:"Query" name:"ObjectId"`
	ParentId        string           `position:"Query" name:"ParentId"`
}

// CreateNavNodeResponse is the response struct for api CreateNavNode
type CreateNavNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateNavNodeRequest creates a request to invoke CreateNavNode API
func CreateCreateNavNodeRequest() (request *CreateNavNodeRequest) {
	request = &CreateNavNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateNavNode", "emr", "openAPI")
	return
}

// CreateCreateNavNodeResponse creates a response to parse from CreateNavNode response
func CreateCreateNavNodeResponse() (response *CreateNavNodeResponse) {
	response = &CreateNavNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
