package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVerificationCode invokes the emr.CreateVerificationCode API synchronously
// api document: https://help.aliyun.com/api/emr/createverificationcode.html
func (client *Client) CreateVerificationCode(request *CreateVerificationCodeRequest) (response *CreateVerificationCodeResponse, err error) {
	response = CreateCreateVerificationCodeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVerificationCodeWithChan invokes the emr.CreateVerificationCode API asynchronously
// api document: https://help.aliyun.com/api/emr/createverificationcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVerificationCodeWithChan(request *CreateVerificationCodeRequest) (<-chan *CreateVerificationCodeResponse, <-chan error) {
	responseChan := make(chan *CreateVerificationCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVerificationCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVerificationCodeWithCallback invokes the emr.CreateVerificationCode API asynchronously
// api document: https://help.aliyun.com/api/emr/createverificationcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVerificationCodeWithCallback(request *CreateVerificationCodeRequest, callback func(response *CreateVerificationCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVerificationCodeResponse
		var err error
		defer close(result)
		response, err = client.CreateVerificationCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVerificationCodeRequest is the request struct for api CreateVerificationCode
type CreateVerificationCodeRequest struct {
	*requests.RpcRequest
	Mode            string           `position:"Query" name:"Mode"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Target          string           `position:"Query" name:"Target"`
}

// CreateVerificationCodeResponse is the response struct for api CreateVerificationCode
type CreateVerificationCodeResponse struct {
	*responses.BaseResponse
	Status int `json:"Status" xml:"Status"`
}

// CreateCreateVerificationCodeRequest creates a request to invoke CreateVerificationCode API
func CreateCreateVerificationCodeRequest() (request *CreateVerificationCodeRequest) {
	request = &CreateVerificationCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateVerificationCode", "emr", "openAPI")
	return
}

// CreateCreateVerificationCodeResponse creates a response to parse from CreateVerificationCode response
func CreateCreateVerificationCodeResponse() (response *CreateVerificationCodeResponse) {
	response = &CreateVerificationCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
