package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFlow invokes the emr.DeleteFlow API synchronously
// api document: https://help.aliyun.com/api/emr/deleteflow.html
func (client *Client) DeleteFlow(request *DeleteFlowRequest) (response *DeleteFlowResponse, err error) {
	response = CreateDeleteFlowResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFlowWithChan invokes the emr.DeleteFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFlowWithChan(request *DeleteFlowRequest) (<-chan *DeleteFlowResponse, <-chan error) {
	responseChan := make(chan *DeleteFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFlowWithCallback invokes the emr.DeleteFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFlowWithCallback(request *DeleteFlowRequest, callback func(response *DeleteFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFlowResponse
		var err error
		defer close(result)
		response, err = client.DeleteFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFlowRequest is the request struct for api DeleteFlow
type DeleteFlowRequest struct {
	*requests.RpcRequest
	Id        string `position:"Query" name:"Id"`
	ProjectId string `position:"Query" name:"ProjectId"`
}

// DeleteFlowResponse is the response struct for api DeleteFlow
type DeleteFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteFlowRequest creates a request to invoke DeleteFlow API
func CreateDeleteFlowRequest() (request *DeleteFlowRequest) {
	request = &DeleteFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteFlow", "emr", "openAPI")
	return
}

// CreateDeleteFlowResponse creates a response to parse from DeleteFlow response
func CreateDeleteFlowResponse() (response *DeleteFlowResponse) {
	response = &DeleteFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
