package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScalingTaskGroup invokes the emr.DeleteScalingTaskGroup API synchronously
// api document: https://help.aliyun.com/api/emr/deletescalingtaskgroup.html
func (client *Client) DeleteScalingTaskGroup(request *DeleteScalingTaskGroupRequest) (response *DeleteScalingTaskGroupResponse, err error) {
	response = CreateDeleteScalingTaskGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteScalingTaskGroupWithChan invokes the emr.DeleteScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/deletescalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteScalingTaskGroupWithChan(request *DeleteScalingTaskGroupRequest) (<-chan *DeleteScalingTaskGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteScalingTaskGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScalingTaskGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteScalingTaskGroupWithCallback invokes the emr.DeleteScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/deletescalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteScalingTaskGroupWithCallback(request *DeleteScalingTaskGroupRequest, callback func(response *DeleteScalingTaskGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteScalingTaskGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteScalingTaskGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteScalingTaskGroupRequest is the request struct for api DeleteScalingTaskGroup
type DeleteScalingTaskGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostGroupId     string           `position:"Query" name:"HostGroupId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DeleteScalingTaskGroupResponse is the response struct for api DeleteScalingTaskGroup
type DeleteScalingTaskGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteScalingTaskGroupRequest creates a request to invoke DeleteScalingTaskGroup API
func CreateDeleteScalingTaskGroupRequest() (request *DeleteScalingTaskGroupRequest) {
	request = &DeleteScalingTaskGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteScalingTaskGroup", "emr", "openAPI")
	return
}

// CreateDeleteScalingTaskGroupResponse creates a response to parse from DeleteScalingTaskGroup response
func CreateDeleteScalingTaskGroupResponse() (response *DeleteScalingTaskGroupResponse) {
	response = &DeleteScalingTaskGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
