package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeETLJobInstance invokes the emr.DescribeETLJobInstance API synchronously
// api document: https://help.aliyun.com/api/emr/describeetljobinstance.html
func (client *Client) DescribeETLJobInstance(request *DescribeETLJobInstanceRequest) (response *DescribeETLJobInstanceResponse, err error) {
	response = CreateDescribeETLJobInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeETLJobInstanceWithChan invokes the emr.DescribeETLJobInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljobinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobInstanceWithChan(request *DescribeETLJobInstanceRequest) (<-chan *DescribeETLJobInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeETLJobInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeETLJobInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeETLJobInstanceWithCallback invokes the emr.DescribeETLJobInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljobinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobInstanceWithCallback(request *DescribeETLJobInstanceRequest, callback func(response *DescribeETLJobInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeETLJobInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeETLJobInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeETLJobInstanceRequest is the request struct for api DescribeETLJobInstance
type DescribeETLJobInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// DescribeETLJobInstanceResponse is the response struct for api DescribeETLJobInstance
type DescribeETLJobInstanceResponse struct {
	*responses.BaseResponse
	RequestId         string                                    `json:"RequestId" xml:"RequestId"`
	Id                string                                    `json:"Id" xml:"Id"`
	EtlJobId          string                                    `json:"EtlJobId" xml:"EtlJobId"`
	InstanceStatus    string                                    `json:"InstanceStatus" xml:"InstanceStatus"`
	TriggerUser       string                                    `json:"TriggerUser" xml:"TriggerUser"`
	StartTime         int                                       `json:"StartTime" xml:"StartTime"`
	EndTime           int                                       `json:"EndTime" xml:"EndTime"`
	TriggerHistory    TriggerHistory                            `json:"TriggerHistory" xml:"TriggerHistory"`
	Arguments         Arguments                                 `json:"Arguments" xml:"Arguments"`
	Metrics           Metrics                                   `json:"Metrics" xml:"Metrics"`
	FlowRelationList  FlowRelationListInDescribeETLJobInstance  `json:"FlowRelationList" xml:"FlowRelationList"`
	StageInstanceList StageInstanceListInDescribeETLJobInstance `json:"StageInstanceList" xml:"StageInstanceList"`
}

// CreateDescribeETLJobInstanceRequest creates a request to invoke DescribeETLJobInstance API
func CreateDescribeETLJobInstanceRequest() (request *DescribeETLJobInstanceRequest) {
	request = &DescribeETLJobInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeETLJobInstance", "emr", "openAPI")
	return
}

// CreateDescribeETLJobInstanceResponse creates a response to parse from DescribeETLJobInstance response
func CreateDescribeETLJobInstanceResponse() (response *DescribeETLJobInstanceResponse) {
	response = &DescribeETLJobInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
